/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wirelessTstat;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.message.Message;
import com.viconics.wirelessTstat.BWirelessTstatDeviceFolder;
import com.viconics.wirelessTstat.BWirelessTstatNetwork;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceAddressInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceCustomMsg;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceModelInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatDeviceModuleInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatIEEEAddress;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatLinkQualityInfo;
import com.viconics.wirelessTstat.datatypes.BWirelessTstatZigbeeAddress;
import com.viconics.wirelessTstat.enums.WirelessTstatConst;
import com.viconics.wirelessTstat.messages.WirelessTstatCustomMsgRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatCustomMsgResponse;
import com.viconics.wirelessTstat.messages.WirelessTstatPingRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatPingResponse;
import com.viconics.wirelessTstat.messages.WirelessTstatReceivedMessage;
import com.viconics.wirelessTstat.messages.WirelessTstatSignalQualityRequest;
import com.viconics.wirelessTstat.messages.WirelessTstatSignalQualityResponse;
import com.viconics.wirelessTstat.point.BWirelessTstatPointDeviceExt;
import com.viconics.wirelessTstat.point.BWirelessTstatProxyExt;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatHeartBeatMsg;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatIdentifyMsg;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatPointWriteMsg;
import com.viconics.wirelessTstat.unsolicited.WirelessTstatSignalQualityMsg;
import com.viconics.wirelessTstat.utils.BConfigStatus;
import com.viconics.wirelessTstat.utils.WirelessTstatToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.nav.BINavNode;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessTstatDevice
extends BBasicDevice
implements WirelessTstatConst {
    public static final Property faultCause = BWirelessTstatDevice.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property configStatus = BWirelessTstatDevice.newProperty((int)71, (BValue)BConfigStatus.ok, null);
    public static final Property deviceInfo = BWirelessTstatDevice.newProperty((int)0, (BValue)BWirelessTstatDeviceModelInfo.DEFAULT, null);
    public static final Property addressInfo = BWirelessTstatDevice.newProperty((int)320, (BValue)BWirelessTstatDeviceAddressInfo.DEFAULT, null);
    public static final Property communicationModuleInfo = BWirelessTstatDevice.newProperty((int)320, (BValue)BWirelessTstatDeviceModuleInfo.DEFAULT, null);
    public static final Property wirelessSignalInfo = BWirelessTstatDevice.newProperty((int)322, (BValue)BWirelessTstatLinkQualityInfo.DEFAULT, null);
    public static final Property points = BWirelessTstatDevice.newProperty((int)0, (BValue)new BWirelessTstatPointDeviceExt(), null);
    public static final Action upload = BWirelessTstatDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BWirelessTstatDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Action updateCovStatus = BWirelessTstatDevice.newAction((int)4, null);
    public static final Action sendCustomMsg = BWirelessTstatDevice.newAction((int)20, (BValue)new BWirelessTstatDeviceCustomMsg(), null);
    public static final Action readSignalStrength = BWirelessTstatDevice.newAction((int)16, null);
    public static final Action ackDuplicateCommAddress = BWirelessTstatDevice.newAction((int)0, null);
    public static final Type TYPE;
    private static final String moduleName;
    private static Log unsolicitedLog;
    private BWirelessTstatDeviceAddressInfo oldAddress;
    private BStatus oldStatus;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatDevice;
    static /* synthetic */ Class class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BConfigStatus getConfigStatus() {
        return (BConfigStatus)this.get(configStatus);
    }

    public void setConfigStatus(BConfigStatus bConfigStatus) {
        this.set(configStatus, (BValue)bConfigStatus, null);
    }

    public BWirelessTstatDeviceModelInfo getDeviceInfo() {
        return (BWirelessTstatDeviceModelInfo)this.get(deviceInfo);
    }

    public void setDeviceInfo(BWirelessTstatDeviceModelInfo bWirelessTstatDeviceModelInfo) {
        this.set(deviceInfo, (BValue)bWirelessTstatDeviceModelInfo, null);
    }

    public BWirelessTstatDeviceAddressInfo getAddressInfo() {
        return (BWirelessTstatDeviceAddressInfo)this.get(addressInfo);
    }

    public void setAddressInfo(BWirelessTstatDeviceAddressInfo bWirelessTstatDeviceAddressInfo) {
        this.set(addressInfo, (BValue)bWirelessTstatDeviceAddressInfo, null);
    }

    public BWirelessTstatDeviceModuleInfo getCommunicationModuleInfo() {
        return (BWirelessTstatDeviceModuleInfo)this.get(communicationModuleInfo);
    }

    public void setCommunicationModuleInfo(BWirelessTstatDeviceModuleInfo bWirelessTstatDeviceModuleInfo) {
        this.set(communicationModuleInfo, (BValue)bWirelessTstatDeviceModuleInfo, null);
    }

    public BWirelessTstatLinkQualityInfo getWirelessSignalInfo() {
        return (BWirelessTstatLinkQualityInfo)this.get(wirelessSignalInfo);
    }

    public void setWirelessSignalInfo(BWirelessTstatLinkQualityInfo bWirelessTstatLinkQualityInfo) {
        this.set(wirelessSignalInfo, (BValue)bWirelessTstatLinkQualityInfo, null);
    }

    public BWirelessTstatPointDeviceExt getPoints() {
        return (BWirelessTstatPointDeviceExt)this.get(points);
    }

    public void setPoints(BWirelessTstatPointDeviceExt bWirelessTstatPointDeviceExt) {
        this.set(points, (BValue)bWirelessTstatPointDeviceExt, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public void updateCovStatus() {
        this.invoke(updateCovStatus, null, null);
    }

    public void sendCustomMsg(BWirelessTstatDeviceCustomMsg bWirelessTstatDeviceCustomMsg) {
        this.invoke(sendCustomMsg, (BValue)bWirelessTstatDeviceCustomMsg, null);
    }

    public void readSignalStrength() {
        this.invoke(readSignalStrength, null, null);
    }

    public void ackDuplicateCommAddress() {
        this.invoke(ackDuplicateCommAddress, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BWirelessTstatNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        int n = this.getAddress();
        BConfigStatus bConfigStatus = this.getConfigStatus();
        boolean bl = false;
        if (n < 1 || n > 255) {
            bl = true;
        }
        this.setConfigStatus(BConfigStatus.make(bConfigStatus, 1, bl));
        BWirelessTstatDevice bWirelessTstatDevice = this.getWirelessTstatNetwork().lookupDeviceByAddress(BInteger.make((int)n));
        if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
            this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 1, true));
            this.setAddress(0);
            bWirelessTstatDevice = null;
            return;
        }
        bWirelessTstatDevice = this.getWirelessTstatNetwork().lookupDeviceByZigbeeAddress(this.getZigbeeAddress());
        if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
            this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 4, true));
        }
        bWirelessTstatDevice = null;
        bWirelessTstatDevice = this.getWirelessTstatNetwork().lookupDeviceByIEEEAddress(this.getIEEEAddress());
        if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
            this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 8, true));
        }
        bWirelessTstatDevice = null;
        this.getWirelessTstatNetwork().registerDevice(this);
        this.oldAddress = (BWirelessTstatDeviceAddressInfo)this.getAddressInfo().newCopy(true);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getWirelessTstatNetwork().unregisterDevice(this);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (Context.decoding.equals(context)) {
            return;
        }
        if (property.equals((Object)configStatus)) {
            this.updateFaultStatus();
            return;
        }
        if (!this.isRunning() || context == WirelessTstatConst.fallback) {
            return;
        }
        if (property.equals((Object)addressInfo)) {
            BWirelessTstatDeviceAddressInfo bWirelessTstatDeviceAddressInfo = this.getAddressInfo();
            BWirelessTstatNetwork bWirelessTstatNetwork = this.getWirelessTstatNetwork();
            int n = bWirelessTstatDeviceAddressInfo.getAddress();
            if (n == 0) {
                this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 1, true));
                return;
            }
            BWirelessTstatDevice bWirelessTstatDevice = bWirelessTstatNetwork.lookupDevice(n);
            if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
                if (WirelessTstatToolkit.getLog().getSeverity() <= 3) {
                    String string = "0x" + Integer.toHexString(65536 + n).substring(1);
                    String string2 = "0x" + Integer.toHexString(65536 + this.oldAddress.getAddress()).substring(1);
                    String string3 = bWirelessTstatDevice.getDisplayName(null);
                    WirelessTstatToolkit.error(WirelessTstatToolkit.getText("error.duplicateCommAddress", new Object[]{string, string3, string2}));
                }
                this.set(addressInfo, this.oldAddress.newCopy(true), WirelessTstatConst.fallback);
                return;
            }
            this.oldAddress = (BWirelessTstatDeviceAddressInfo)bWirelessTstatDeviceAddressInfo.newCopy(true);
            this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 1, false));
            bWirelessTstatDeviceAddressInfo = null;
            bWirelessTstatNetwork = null;
        }
        if (enabled.equals((Object)property)) {
            this.updateCovStatus();
        }
        this.getWirelessTstatNetwork().updateDevice(this);
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (bComponent instanceof BWirelessTstatNetwork) {
            return true;
        }
        if (bComponent instanceof BWirelessTstatDeviceFolder) {
            return true;
        }
        return bComponent.getPropertyInParent() == null;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BWirelessTstatDevice.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bINavNodeArray.length) {
            BComponent bComponent = (BComponent)bINavNodeArray[n];
            array.add((Object)bComponent);
            ++n;
        }
        array.remove((Object)this.getWirelessSignalInfo());
        return (BINavNode[])array.trim();
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getConfigStatus().isInvalidComm()) {
            return;
        }
        if (!this.asValidDeviceAddressInfo()) {
            return;
        }
        try {
            BWirelessTstatNetwork bWirelessTstatNetwork = (BWirelessTstatNetwork)this.getNetwork();
            WirelessTstatPingRequest wirelessTstatPingRequest = new WirelessTstatPingRequest(this.getAddress());
            WirelessTstatPingResponse wirelessTstatPingResponse = (WirelessTstatPingResponse)bWirelessTstatNetwork.sendSync(wirelessTstatPingRequest);
            if (wirelessTstatPingResponse == null) {
                this.pingFail(WirelessTstatToolkit.getText("device.error.pingError", new Object[]{"Timeout"}), wirelessTstatPingRequest, wirelessTstatPingResponse);
                this.oldStatus = BStatus.down;
            } else if (!wirelessTstatPingResponse.getSuccessfulResponse()) {
                this.pingFail(WirelessTstatToolkit.getText("device.error.pingError", new Object[]{wirelessTstatPingResponse.getErrorString()}), wirelessTstatPingRequest, wirelessTstatPingResponse);
                this.oldStatus = BStatus.down;
            } else {
                this.pingOk();
                if (this.asValidateDeviceIdentity(wirelessTstatPingResponse)) {
                    if (this.getIEEEAddress().isZero()) {
                        this.setIEEEAddress(wirelessTstatPingResponse.getIEEEAddress());
                    }
                    this.setZigbeeAddress(wirelessTstatPingResponse.getZigbeeAddress());
                    this.setZigbeeModuleMajorVersion(wirelessTstatPingResponse.getZbFirmwareMajNumber());
                    this.setZigbeeModuleMinorVersion(wirelessTstatPingResponse.getZbFirmwareMinNumber());
                    this.setHardwareRevision(wirelessTstatPingResponse.getChipRevision());
                    this.getDeviceInfo().setFirmwareVersion(wirelessTstatPingResponse.getFirmwareVersion());
                }
                if (this.oldStatus == BStatus.down) {
                    this.updateCovStatus();
                }
                this.oldStatus = BStatus.ok;
            }
        }
        catch (Exception exception) {
            WirelessTstatToolkit.error(WirelessTstatToolkit.getText("device.error.pingUnexpectedError"), exception);
            this.pingFail(WirelessTstatToolkit.getText("device.error.pingUnexpectedError"));
            exception.printStackTrace();
        }
    }

    public void pingFail(String string, WirelessTstatPingRequest wirelessTstatPingRequest, WirelessTstatPingResponse wirelessTstatPingResponse) {
        this.getWirelessSignalInfo().setTRSS(0);
        this.getWirelessSignalInfo().setCRSS(0);
        WirelessTstatToolkit.error(WirelessTstatToolkit.getText("device.error.pingFail", new Object[]{string, BInteger.make((int)this.getAddress()), wirelessTstatPingRequest.toString(), wirelessTstatPingResponse != null ? wirelessTstatPingResponse.toDebugString() : "null"}));
        super.pingFail(string);
    }

    public void pingFail(String string) {
        this.getWirelessSignalInfo().setTRSS(0);
        this.getWirelessSignalInfo().setCRSS(0);
        super.pingFail(string);
    }

    public void doUpdateCovStatus() {
        int n = this.getWirelessTstatNetwork().getCovManager().getCovEnabled() & this.getEnabled() ? 2 : 0;
        WirelessTstatCustomMsgRequest wirelessTstatCustomMsgRequest = new WirelessTstatCustomMsgRequest(this.getAddress(), 3, 2, n);
        WirelessTstatCustomMsgResponse wirelessTstatCustomMsgResponse = (WirelessTstatCustomMsgResponse)this.getWirelessTstatNetwork().sendSync(wirelessTstatCustomMsgRequest);
        if (wirelessTstatCustomMsgResponse == null) {
            WirelessTstatToolkit.error("Failed to receive answer from message 0x0003 from comm address " + this.getAddress());
            return;
        }
        if (!wirelessTstatCustomMsgResponse.getSuccessfulResponse()) {
            WirelessTstatToolkit.error("Error: " + wirelessTstatCustomMsgResponse.getErrorString() + " from message 0x0003 from comm address " + this.getAddress());
            return;
        }
        this.oldStatus = BStatus.ok;
    }

    public BValue getActionParameterDefault(Action action) {
        return super.getActionParameterDefault(action);
    }

    public void doSendCustomMsg(BWirelessTstatDeviceCustomMsg bWirelessTstatDeviceCustomMsg) {
        BWirelessTstatNetwork bWirelessTstatNetwork = this.getWirelessTstatNetwork();
        if (bWirelessTstatNetwork == null) {
            return;
        }
        if (!bWirelessTstatNetwork.isRunning()) {
            return;
        }
        WirelessTstatCustomMsgRequest wirelessTstatCustomMsgRequest = new WirelessTstatCustomMsgRequest(this.getAddress(), bWirelessTstatDeviceCustomMsg);
        WirelessTstatCustomMsgResponse wirelessTstatCustomMsgResponse = (WirelessTstatCustomMsgResponse)this.getWirelessTstatNetwork().sendSync(wirelessTstatCustomMsgRequest);
        if (wirelessTstatCustomMsgResponse == null) {
            System.out.println("Failed to receive answer to custom message");
            return;
        }
        if (!wirelessTstatCustomMsgResponse.getSuccessfulResponse()) {
            System.out.println("Received error code message on send custom message");
            return;
        }
    }

    public void doAckDuplicateCommAddress() {
        this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 2, false));
    }

    public void doReadSignalStrength() {
        BWirelessTstatNetwork bWirelessTstatNetwork = this.getWirelessTstatNetwork();
        if (bWirelessTstatNetwork == null) {
            return;
        }
        if (!bWirelessTstatNetwork.isRunning()) {
            return;
        }
        WirelessTstatSignalQualityRequest wirelessTstatSignalQualityRequest = new WirelessTstatSignalQualityRequest(this.getAddress());
        WirelessTstatSignalQualityResponse wirelessTstatSignalQualityResponse = (WirelessTstatSignalQualityResponse)this.getWirelessTstatNetwork().sendSync(wirelessTstatSignalQualityRequest);
        if (wirelessTstatSignalQualityResponse == null) {
            System.out.println("Failed to receive answer to custom message");
            return;
        }
        if (!wirelessTstatSignalQualityResponse.getSuccessfulResponse()) {
            System.out.println("Received error code message from read signal quality");
            return;
        }
        this.getWirelessSignalInfo().setTRSS(wirelessTstatSignalQualityResponse.getTrss());
        this.getWirelessSignalInfo().setCRSS(wirelessTstatSignalQualityResponse.getLinkQuality());
    }

    public void updateFaultStatus() {
        if (this.getConfigStatus().isValid()) {
            this.configOk();
        } else {
            this.configFail(this.getConfigStatus().toString());
        }
    }

    public final BWirelessTstatNetwork getWirelessTstatNetwork() {
        return (BWirelessTstatNetwork)this.getNetwork();
    }

    public boolean asValidateDeviceIdentity(WirelessTstatPingResponse wirelessTstatPingResponse) {
        BConfigStatus bConfigStatus = this.getConfigStatus();
        boolean bl = false;
        if (wirelessTstatPingResponse.getThermostatFirmwareNumber() != this.getThermostatFirmwareNumber()) {
            bl = true;
        }
        this.setConfigStatus(BConfigStatus.make(bConfigStatus, 16, bl));
        this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 64, (this.getIEEEAddress().isZero() ^ true) & (wirelessTstatPingResponse.getIEEEAddress().equals((Object)this.getIEEEAddress()) ^ true)));
        this.setConfigStatus(BConfigStatus.make(this.getConfigStatus(), 32, (this.getZigbeeAddress().isZero() ^ true) & (wirelessTstatPingResponse.getZigbeeAddress().equals((Object)this.getZigbeeAddress()) ^ true)));
        return this.getConfigStatus().isMismatched() ^ true;
    }

    public boolean asValidDeviceAddressInfo() {
        BSimple bSimple = this.getZigbeeAddress();
        BWirelessTstatDevice bWirelessTstatDevice = this.getWirelessTstatNetwork().lookupDeviceByZigbeeAddress((BWirelessTstatZigbeeAddress)bSimple);
        BConfigStatus bConfigStatus = this.getConfigStatus();
        boolean bl = false;
        if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
            bl = true;
        }
        this.setConfigStatus(BConfigStatus.make(bConfigStatus, 4, bl));
        bSimple = this.getIEEEAddress();
        bWirelessTstatDevice = this.getWirelessTstatNetwork().lookupDeviceByIEEEAddress((BWirelessTstatIEEEAddress)bSimple);
        BConfigStatus bConfigStatus2 = this.getConfigStatus();
        boolean bl2 = false;
        if (bWirelessTstatDevice != null && bWirelessTstatDevice != this) {
            bl2 = true;
        }
        this.setConfigStatus(BConfigStatus.make(bConfigStatus2, 8, bl2));
        return this.getConfigStatus().isDuplicate() ^ true;
    }

    protected boolean getDebug() {
        return this.getWirelessTstatNetwork().getDebug();
    }

    public void processUnsolicitedResponse(WirelessTstatReceivedMessage wirelessTstatReceivedMessage) {
        if (!this.isRunning()) {
            return;
        }
        if (wirelessTstatReceivedMessage.getCmdType() != 2) {
            WirelessTstatToolkit.warning("Received message other than write request as unsolicirted " + wirelessTstatReceivedMessage.toString());
            return;
        }
        switch (wirelessTstatReceivedMessage.getMsgType()) {
            case 0: {
                WirelessTstatIdentifyMsg wirelessTstatIdentifyMsg = new WirelessTstatIdentifyMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.getWirelessTstatNetwork().sendSync((Message)wirelessTstatIdentifyMsg);
                if (wirelessTstatIdentifyMsg.getTransSequence() != 0) break;
                this.pingFail("Device reset detected");
                WirelessTstatToolkit.warning("Reset detected for device " + this.getDisplayName(null) + " (" + wirelessTstatReceivedMessage.toString() + ')');
                this.updateCovStatus();
                this.pingOk();
                break;
            }
            case 1: {
                WirelessTstatHeartBeatMsg wirelessTstatHeartBeatMsg = new WirelessTstatHeartBeatMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.getWirelessTstatNetwork().sendSync((Message)wirelessTstatHeartBeatMsg);
                this.validateCovStatus(wirelessTstatHeartBeatMsg.getAddedStatus());
                break;
            }
            case 4212: {
                WirelessTstatSignalQualityMsg wirelessTstatSignalQualityMsg = new WirelessTstatSignalQualityMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.getWirelessTstatNetwork().sendSync((Message)wirelessTstatSignalQualityMsg);
                this.getWirelessSignalInfo().setCRSS(wirelessTstatSignalQualityMsg.getLinkQuality());
                this.getWirelessSignalInfo().setTRSS(wirelessTstatSignalQualityMsg.getTrss());
                break;
            }
            default: {
                if (wirelessTstatReceivedMessage.getMsgType() < 4096) {
                    this.updateCovStatus();
                    return;
                }
                WirelessTstatPointWriteMsg wirelessTstatPointWriteMsg = new WirelessTstatPointWriteMsg(wirelessTstatReceivedMessage.getBytes(), wirelessTstatReceivedMessage.getLength());
                this.getWirelessTstatNetwork().sendSync((Message)wirelessTstatPointWriteMsg);
                BWirelessTstatProxyExt bWirelessTstatProxyExt = this.getPoints().lookupPoint(wirelessTstatPointWriteMsg.getMsgType());
                if (bWirelessTstatProxyExt != null) {
                    bWirelessTstatProxyExt.receivedValue(wirelessTstatPointWriteMsg.getPointValue());
                    break;
                }
                unsolicitedLog.trace("Unhandeled unsolicited message for device " + this.getDisplayName(null) + ": " + ByteArrayUtil.toHexString((byte[])wirelessTstatReceivedMessage.getBytes(), (int)0, (int)wirelessTstatReceivedMessage.getLength()));
            }
        }
    }

    public void validateCovStatus(int n) {
        int n2;
        int n3 = n2 = this.getWirelessTstatNetwork().getCovManager().getCovEnabled() & this.getEnabled() ? 2 : 0;
        if (n != n2) {
            WirelessTstatCustomMsgRequest wirelessTstatCustomMsgRequest = new WirelessTstatCustomMsgRequest(this.getAddress(), 3, 2, n2);
            WirelessTstatCustomMsgResponse wirelessTstatCustomMsgResponse = (WirelessTstatCustomMsgResponse)this.getWirelessTstatNetwork().sendSync(wirelessTstatCustomMsgRequest);
            if (wirelessTstatCustomMsgResponse == null) {
                WirelessTstatToolkit.error("Failed to receive reply from COV sycnronisation message on device " + this.getDisplayName(null));
                return;
            }
            if (!wirelessTstatCustomMsgResponse.getSuccessfulResponse()) {
                WirelessTstatToolkit.error("Error: " + wirelessTstatCustomMsgResponse.getErrorString() + " from COV sycnronisation message on device " + this.getDisplayName(null));
                return;
            }
        }
        this.oldStatus = BStatus.ok;
    }

    public BWirelessTstatZigbeeAddress getZigbeeAddress() {
        return this.getAddressInfo().getZigbeeAddress();
    }

    public void setZigbeeAddress(BWirelessTstatZigbeeAddress bWirelessTstatZigbeeAddress) {
        this.getAddressInfo().setZigbeeAddress(bWirelessTstatZigbeeAddress);
    }

    public BWirelessTstatIEEEAddress getIEEEAddress() {
        return this.getAddressInfo().getIEEEAddress();
    }

    public void setIEEEAddress(BWirelessTstatIEEEAddress bWirelessTstatIEEEAddress) {
        this.getAddressInfo().setIEEEAddress(bWirelessTstatIEEEAddress);
    }

    public int getThermostatFirmwareVersion() {
        return this.getDeviceInfo().getFirmwareVersion();
    }

    public void setThermostatFirmwareVersion(int n) {
        this.getDeviceInfo().setFirmwareVersion(n);
    }

    public int getHardwareRevision() {
        return this.getCommunicationModuleInfo().getHardwareRevision();
    }

    public void setHardwareRevision(int n) {
        this.getCommunicationModuleInfo().setHardwareRevision(n);
    }

    public int getAddress() {
        return this.getAddressInfo().getAddress();
    }

    public void setAddress(int n) {
        this.getAddressInfo().setAddress(n);
    }

    public int getThermostatFirmwareNumber() {
        return this.getDeviceInfo().getFirmwareNumber();
    }

    public void setThermostatFirmwareNumber(int n) {
        this.getDeviceInfo().setFirmwareNumber(n);
    }

    public String getModelName() {
        return this.getDeviceInfo().getModelName().toString();
    }

    public void setZigbeeModuleMajorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModuleMajorVersion(n);
    }

    public void setZigbeeModuleMinorVersion(int n) {
        this.getCommunicationModuleInfo().setZigbeeModuleMinorVersion(n);
    }

    public BStatus getOldStatus() {
        return this.oldStatus;
    }

    public void setOldStatus(BStatus bStatus) {
        this.oldStatus = bStatus;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldAddress = BWirelessTstatDeviceAddressInfo.DEFAULT;
        this.oldStatus = BStatus.down;
    }

    public BWirelessTstatDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wirelessTstat$BWirelessTstatDevice;
        if (clazz == null) {
            clazz = class$com$viconics$wirelessTstat$BWirelessTstatDevice = BWirelessTstatDevice.class("[Lcom.viconics.wirelessTstat.BWirelessTstatDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$viconics$wirelessTstat$BWirelessTstatNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$viconics$wirelessTstat$BWirelessTstatNetwork = BWirelessTstatDevice.class("[Lcom.viconics.wirelessTstat.BWirelessTstatNetwork;", false);
        }
        moduleName = Sys.getModuleForClass((Class)clazz2).getModuleName();
        unsolicitedLog = Log.getLog((String)(moduleName + ".unsolicited"));
    }
}

