/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNdio;

import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import com.tridium.platNdio.NdioPlatformServiceException;
import java.io.PrintWriter;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class NdioProcessorStatusPage
extends Spy
implements NdioPlatformServiceConstants {
    private BNdioPlatformService service;
    private int addr;

    public void write(SpyWriter spyWriter) throws Exception {
        block15: {
            try {
                if (this.service.isDaemonOk()) {
                    spyWriter.startProps();
                    spyWriter.trTitle((Object)"processor", 2);
                    spyWriter.prop((Object)"address", this.addr);
                    int n = 0;
                    int n2 = 0;
                    try {
                        n = this.service.readIoType(this.addr);
                        n2 = this.service.readIoConfigState(this.addr);
                    }
                    catch (Exception exception) {}
                    if (n != 0 && n2 != 0 && n2 != 1) {
                        spyWriter.prop((Object)"firstReadTicks", (Object)String.valueOf(this.service.getFirstReadTicks(this.addr)));
                        spyWriter.prop((Object)"ioBoardType", n);
                        spyWriter.prop((Object)"ioFirmware", (Object)("" + this.service.getFirmwareIntfNum(this.addr) + '.' + this.service.getFirmwareBuildNum(this.addr)));
                        spyWriter.prop((Object)"configCode", this.service.readConfigCode(this.addr) & 0xFFFFFF);
                        spyWriter.prop((Object)"ioConfigState", n2);
                        spyWriter.prop((Object)"calibrated", this.service.isProcessorCalibrated(this.addr));
                        spyWriter.prop((Object)"successTicks", (Object)String.valueOf(this.service.getSuccessTicks(this.addr)));
                        StringBuffer stringBuffer = new StringBuffer();
                        int n3 = 0;
                        while (n3 < 8) {
                            stringBuffer.append("[").append(this.service.readUIType(this.addr, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"definitionUIs", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 8) {
                            stringBuffer.append("[").append(this.service.readValue(this.addr, 0, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"uiInValues", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 8) {
                            stringBuffer.append("[").append(this.service.readUICount(this.addr, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"uiInCounts", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 16) {
                            stringBuffer.append("[").append(this.service.readValue(this.addr, 1, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"ovrInValues", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 16) {
                            stringBuffer.append("[").append(this.service.readValue(this.addr, 3, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"doInValues", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 16) {
                            stringBuffer.append("[").append(this.service.readOutValue(this.addr, 3, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"doOutValues", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 4) {
                            stringBuffer.append("[").append(this.service.readValue(this.addr, 2, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"aoInValues", (Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < 4) {
                            stringBuffer.append("[").append(this.service.readOutValue(this.addr, 2, n3)).append("]");
                            ++n3;
                        }
                        spyWriter.prop((Object)"aoOutValues", (Object)stringBuffer.toString());
                    } else {
                        spyWriter.prop((Object)"state", (Object)"undefined");
                    }
                    spyWriter.endProps();
                    break block15;
                }
                throw new NdioPlatformServiceException("network is not running");
            }
            catch (Exception exception) {
                spyWriter.endProps();
                spyWriter.println("error getting ndio processor status:<br>");
                exception.printStackTrace((PrintWriter)spyWriter);
            }
        }
    }

    public NdioProcessorStatusPage(BNdioPlatformService bNdioPlatformService, int n) {
        this.service = bNdioPlatformService;
        this.addr = n;
    }
}

