/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.broker;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.sys.transfer.CompTransferResult;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.space.BISpaceNode;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class TransferCodec {
    public static FoxRequest transferToMessage(FoxRequest foxRequest, TransferStrategy transferStrategy) throws Exception {
        foxRequest.add("target", ((BISpaceNode)transferStrategy.getTarget()).getOrdInSession().toString());
        Mark mark = transferStrategy.getMark();
        BObject[] bObjectArray = mark.getValues();
        String[] stringArray = mark.getNames();
        int n = 0;
        while (n < bObjectArray.length) {
            FoxMessage foxMessage = new FoxMessage("mark");
            foxMessage.add("ord", ((BISpaceNode)bObjectArray[n]).getOrdInSession().toString());
            foxMessage.add("name", stringArray[n]);
            foxRequest.add(foxMessage);
            ++n;
        }
        foxRequest.add("action", transferStrategy.getAction());
        BogCodec.add(foxRequest, "params", (BValue)transferStrategy.getParameters(), null);
        return foxRequest;
    }

    public static TransferStrategy messageToTransfer(FoxMessage foxMessage, Context context) throws Exception {
        BObject bObject = BOrd.make((String)foxMessage.getString("target")).get((BObject)BLocalHost.INSTANCE, context);
        FoxTuple[] foxTupleArray = foxMessage.list("mark");
        BObject[] bObjectArray = new BObject[foxTupleArray.length];
        String[] stringArray = new String[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage2 = (FoxMessage)foxTupleArray[n];
            bObjectArray[n] = BOrd.make((String)foxMessage2.getString("ord")).get((BObject)BLocalHost.INSTANCE, context);
            stringArray[n] = foxMessage2.getString("name");
            ++n;
        }
        Mark mark = new Mark(bObjectArray, stringArray);
        int n2 = foxMessage.getInt("action");
        BComponent bComponent = (BComponent)DecoderFactory.decode(foxMessage, "params", null);
        return TransferStrategy.make((int)n2, (Mark)mark, (BObject)bObject, (BComponent)bComponent, (Context)context);
    }

    public static FoxResponse resultToMessage(FoxResponse foxResponse, TransferResult transferResult) throws Exception {
        if (!(transferResult instanceof CompTransferResult)) {
            return null;
        }
        CompTransferResult compTransferResult = (CompTransferResult)transferResult;
        foxResponse.add("class", compTransferResult.getClass().getName());
        foxResponse.add("action", compTransferResult.action);
        foxResponse.add("origParent", compTransferResult.origParent.getOrdInSession().toString());
        int n = 0;
        while (n < compTransferResult.origNames.length) {
            foxResponse.add("origName", compTransferResult.origNames[n]);
            ++n;
        }
        foxResponse.add("target", compTransferResult.target.getOrdInSession().toString());
        n = 0;
        while (n < compTransferResult.insertNames.length) {
            foxResponse.add("insertName", compTransferResult.insertNames[n]);
            ++n;
        }
        return foxResponse;
    }

    public static TransferResult messageToResult(BObject bObject, FoxMessage foxMessage) throws Exception {
        if (foxMessage == null) {
            return null;
        }
        int n = foxMessage.getInt("action");
        BOrd bOrd = BOrd.make((String)foxMessage.getString("origParent"));
        String[] stringArray = foxMessage.listStrings("origName");
        BOrd bOrd2 = BOrd.make((String)foxMessage.getString("target"));
        String[] stringArray2 = foxMessage.listStrings("insertName");
        BComponent bComponent = (BComponent)bOrd.get(bObject);
        BComponent bComponent2 = (BComponent)bOrd2.get(bObject);
        return new CompTransferResult(n, bComponent, stringArray, bComponent2, stringArray2);
    }
}

