/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.broker;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.ModuleNotFoundLocalException;
import com.tridium.fox.sys.broker.BFoxComponentSpace;
import com.tridium.fox.sys.broker.BFoxVirtualSpace;
import com.tridium.fox.sys.broker.SyntheticTypeInfo;
import com.tridium.fox.sys.broker.TransferCodec;
import com.tridium.space.BIGatewaySpace;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.NModule;
import com.tridium.sys.module.SyntheticModuleClassLoader;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.SimpleType;
import com.tridium.sys.schema.SyntheticCompiler;
import com.tridium.sys.schema.SyntheticComplexType;
import com.tridium.sys.schema.SyntheticEnumType;
import com.tridium.sys.schema.SyntheticSimpleType;
import com.tridium.sys.transfer.DeleteOp;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.NavEvent;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.util.Array;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sync.ProxyBroker;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBrokerChannel
extends BFoxChannel {
    public static final Action subscriberGc = BBrokerChannel.newAction((int)16, null);
    public static final Type TYPE;
    static final Version ver3_2_5;
    private static boolean DUMP_BUF;
    private static int POLL_RATE;
    public static final Log syncLog;
    private BrokerTypeResolver typeResolver;
    private boolean isClient;
    private boolean isServer;
    private BComponentSpace space;
    private ClientSyncThread clientThread;
    private ProxyBroker broker;
    private Object syncFromMasterLock;
    private long lastSyncFromMaster;
    private HashMap syntheticModuleMap;
    private List syncBuffers;
    private ThreadLocal eventCache;
    static /* synthetic */ Class class$com$tridium$fox$sys$broker$BBrokerChannel;

    public void subscriberGc() {
        this.invoke(subscriberGc, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public ProxyBroker getProxyBroker() {
        return this.broker;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if (string == "loadRoot") {
            return this.loadRoot(foxRequest);
        }
        if (string == "load") {
            return this.load(foxRequest);
        }
        if (string == "loadSlot") {
            return this.loadSlot(foxRequest);
        }
        if (string == "sub") {
            return this.subscribe(foxRequest);
        }
        if (string == "unsub") {
            return this.unsubscribe(foxRequest);
        }
        if (string == "transfer") {
            return this.transferReqRes(foxRequest);
        }
        if (string == "invoke") {
            return this.invoke(foxRequest);
        }
        if (string == "handleToPath") {
            return this.handleToPath(foxRequest);
        }
        if (string == "serviceToPath") {
            return this.serviceToPath(foxRequest);
        }
        if (string == "generateHandles") {
            return this.generateHandles(foxRequest);
        }
        if (string == "rpc") {
            return this.rpc(foxRequest);
        }
        if (string == "touch") {
            return this.touch(foxRequest);
        }
        if (string == "loadType") {
            return this.loadType(foxRequest);
        }
        if (string == "loadModule") {
            return this.loadModule(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "syncToMaster") {
            this.syncToMaster(foxCircuit);
            return;
        }
        if (string == "syncFromMaster") {
            this.syncFromMaster(foxCircuit);
            return;
        }
        if (string == "transferCircuit") {
            this.transferCircuit(foxCircuit);
            return;
        }
        if (string == "copy") {
            this.copy(foxCircuit);
            return;
        }
        if (string == "delete") {
            this.delete(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public void initClient(BFoxComponentSpace bFoxComponentSpace) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:initClient " + bFoxComponentSpace.getNavOrd());
        }
        this.isClient = true;
        this.isServer = false;
        this.space = bFoxComponentSpace;
        RootInfo rootInfo = this.loadRoot();
        bFoxComponentSpace.setRootComponent(rootInfo.root);
        bFoxComponentSpace.spaceReadonly = rootInfo.spaceReadonly;
        bFoxComponentSpace.defaultLeaseTime = rootInfo.defaultLeaseTime;
        this.clientThread = new ClientSyncThread("Fox:ClientSync:" + this.getConnection().session().getId());
        this.clientThread.start();
    }

    public void initServer(BComponentSpace bComponentSpace) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:initServer " + bComponentSpace.getNavOrd());
        }
        this.isClient = false;
        this.isServer = true;
        this.space = bComponentSpace;
        this.broker = new FoxProxyBroker(bComponentSpace);
        this.broker.start();
    }

    public void cleanupClient() {
        if (this.clientThread != null) {
            this.clientThread.kill();
            this.clientThread = null;
            try {
                if (this.space instanceof BFoxVirtualSpace) {
                    ((BFoxVirtualSpace)this.space).cleanup(this.getFoxSession());
                }
            }
            catch (Exception exception) {}
        }
    }

    public void cleanupServer() {
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    public void sessionClosed(Throwable throwable) {
        if (this.isClient) {
            this.cleanupClient();
        } else {
            this.cleanupServer();
        }
    }

    NModule loadModule(final ValueDocDecoder valueDocDecoder, final String string, final String string2) {
        NModule nModule;
        Version version = this.getClientConnection().getRemoteVersion();
        if (version.get(0) < 3 || version.get(1) < 7) {
            throw new ModuleNotFoundLocalException(string2, null);
        }
        if (this.syntheticModuleMap == null || !this.syntheticModuleMap.containsKey(string2)) {
            if (this.syntheticModuleMap == null) {
                this.syntheticModuleMap = new HashMap();
            }
            if (this.isTraceOn()) {
                this.trace("Synthesizing module " + string2);
            }
            try {
                FoxRequest foxRequest = this.makeRequest("loadModule");
                foxRequest.add("module", string2);
                final FoxResponse foxResponse = this.sendSync(foxRequest);
                nModule = new NModule(){
                    HashMap syntheticTypeMap;

                    public final BModule bmodule() {
                        if (this.bmodule == null) {
                            this.bmodule = new BModule((Object)this);
                        }
                        return (BModule)this.bmodule;
                    }

                    public final Type getType(String string3) throws TypeException {
                        BTypeSpec bTypeSpec = BTypeSpec.make((String)string2, (String)string3);
                        try {
                            if (this.syntheticTypeMap.containsKey(bTypeSpec)) {
                                return (Type)this.syntheticTypeMap.get(bTypeSpec);
                            }
                            Type type = BBrokerChannel.this.loadType(valueDocDecoder, this, bTypeSpec);
                            this.syntheticTypeMap.put(bTypeSpec, type);
                            return type;
                        }
                        catch (Exception exception) {
                            throw new BajaRuntimeException("Unable to synthesize " + bTypeSpec, (Throwable)exception);
                        }
                    }

                    private final /* synthetic */ void this() {
                        this.syntheticTypeMap = new HashMap();
                        this.classLoader = new SyntheticModuleClassLoader(this){

                            public final Class nfind(String string, boolean bl) {
                                BTypeSpec bTypeSpec = BTypeSpec.make((String)this.module.getModuleName(), (String)string.substring(string.lastIndexOf(46) + 2));
                                if (syntheticTypeMap.containsKey(bTypeSpec)) {
                                    return ((Type)syntheticTypeMap.get(bTypeSpec)).getTypeClass();
                                }
                                if (this.module.getTypeClassName(string.substring(string.lastIndexOf(46) + 2)) != null) {
                                    try {
                                        Type type = BBrokerChannel.this.loadType(valueDocDecoder, this.module, bTypeSpec);
                                        syntheticTypeMap.put(bTypeSpec, type);
                                        return type.getTypeClass();
                                    }
                                    catch (Exception exception) {
                                        throw new BajaRuntimeException((Throwable)exception);
                                    }
                                }
                                return super.nfind(string, bl);
                            }
                        };
                        this.name = string2;
                        this.preferredSymbol = string;
                        this.bajaVersion = new Version(foxResponse.getString("bajaVersion"));
                        this.vendor = foxResponse.getString("vendor");
                        this.description = foxResponse.getString("description");
                        this.vendorVersion = new Version(foxResponse.getString("vendorVersion"));
                        String[] stringArray = foxResponse.listStrings("types");
                        int n = 0;
                        while (n < stringArray.length) {
                            this.types.put(stringArray[n].substring(stringArray[n].lastIndexOf(46) + 2), stringArray[n]);
                            ++n;
                        }
                        String[] stringArray2 = foxResponse.listStrings("dependency");
                        String[] stringArray3 = foxResponse.listStrings("dependency_bajaVersion");
                        String[] stringArray4 = foxResponse.listStrings("dependency_vendor");
                        String[] stringArray5 = foxResponse.listStrings("dependency_vendorVersion");
                        this.depends = new Dependency[stringArray2.length];
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            String string3 = stringArray2[n2];
                            BModule bModule = BBrokerChannel.this.typeResolver.loadModule(valueDocDecoder, null, null, string3 + '=' + string3, string3);
                            this.depends[n2] = new Dependency(string3, new Version(stringArray3[n2]), stringArray4[n2], new Version(stringArray5[n2]), (NModule)bModule.fw(405));
                            ++n2;
                        }
                    }
                    {
                        this.this();
                    }
                };
                this.syntheticModuleMap.put(string2, nModule);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        } else {
            nModule = (NModule)this.syntheticModuleMap.get(string2);
        }
        return nModule;
    }

    private final FoxResponse loadModule(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("module");
        if (this.isTraceOn()) {
            this.trace("s:loadModule " + string);
        }
        ModuleInfo moduleInfo = Sys.getRegistry().getModule(string);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("vendorVersion", moduleInfo.getVendorVersion().toString());
        foxResponse.add("vendor", moduleInfo.getVendor());
        foxResponse.add("bajaVersion", moduleInfo.getBajaVersion().toString());
        foxResponse.add("description", moduleInfo.getDescription());
        TypeInfo[] typeInfoArray = moduleInfo.getTypes();
        int n = 0;
        while (n < typeInfoArray.length) {
            foxResponse.add("types", typeInfoArray[n].getTypeClassName());
            ++n;
        }
        DependencyInfo[] dependencyInfoArray = moduleInfo.getDependencies();
        int n2 = 0;
        while (n2 < dependencyInfoArray.length) {
            foxResponse.add("dependency", dependencyInfoArray[n2].getModuleName());
            if (dependencyInfoArray[n2].getBajaVersion() != null) {
                foxResponse.add("dependency_bajaVersion", dependencyInfoArray[n2].getBajaVersion().toString());
            } else {
                foxResponse.add("dependency_bajaVersion", "0.0");
            }
            if (dependencyInfoArray[n2].getVendorVersion() != null) {
                foxResponse.add("dependency_vendorVersion", dependencyInfoArray[n2].getVendorVersion().toString());
            } else {
                foxResponse.add("dependency_vendorVersion", "0.0");
            }
            if (dependencyInfoArray[n2].getVendor() != null) {
                foxResponse.add("dependency_vendor", dependencyInfoArray[n2].getVendor());
            } else {
                foxResponse.add("dependency_vendor", "");
            }
            ++n2;
        }
        return foxResponse;
    }

    Type loadType(ValueDocDecoder valueDocDecoder, NModule nModule, BTypeSpec bTypeSpec) throws Exception {
        if (this.isTraceOn()) {
            this.trace("Synthesizing type " + bTypeSpec);
        }
        FoxRequest foxRequest = this.makeRequest("loadType");
        foxRequest.add("type", bTypeSpec.toString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("classname");
        boolean bl = foxResponse.getBoolean("abstract", false);
        BTypeSpec bTypeSpec2 = BTypeSpec.make((String)((FoxMessage)foxResponse.get("superType")).getString("typespec"));
        Object object = this.typeResolver.loadModule(valueDocDecoder, null, null, bTypeSpec2.getModuleName() + '=' + bTypeSpec2.getModuleName(), bTypeSpec2.toString());
        TypeInfo typeInfo = object.getType(bTypeSpec2.getTypeName()).getTypeInfo();
        TypeInfo[] typeInfoArray = new TypeInfo[]{};
        boolean bl2 = false;
        if (typeInfo.is(BSimple.TYPE) && !bl) {
            bl2 = true;
        }
        bTypeSpec2 = SyntheticCompiler.compile((String)string, (TypeInfo)typeInfo, (TypeInfo[])typeInfoArray, (boolean)bl, (boolean)bl2, (boolean)true, (byte[])foxResponse.getBlob("default", null));
        SyntheticModuleClassLoader syntheticModuleClassLoader = (SyntheticModuleClassLoader)nModule.getClassLoader();
        object = syntheticModuleClassLoader.ndefineClass(string, bTypeSpec2.bytes, 0, bTypeSpec2.count);
        nModule.register(string.substring(string.lastIndexOf(46) + 2), string);
        Type type = (Type)((Class)object).getField("TYPE").get(null);
        if (type instanceof SyntheticEnumType) {
            SyntheticEnumType syntheticEnumType = (SyntheticEnumType)type;
            syntheticEnumType.setTypeInfo((TypeInfo)new SyntheticTypeInfo(type));
            String[] stringArray = foxResponse.listStrings("enum_ordinal");
            String[] stringArray2 = foxResponse.listStrings("enum_tag");
            int n = 0;
            while (n < stringArray.length) {
                syntheticEnumType.addEntry(Integer.parseInt(stringArray[n]), stringArray2[n]);
                ++n;
            }
        } else if (type instanceof SyntheticComplexType) {
            SyntheticComplexType syntheticComplexType = (SyntheticComplexType)type;
            syntheticComplexType.setTypeInfo((TypeInfo)new SyntheticTypeInfo(type));
            String[] stringArray = foxResponse.listStrings("slot");
            String[] stringArray3 = foxResponse.listStrings("slot_name");
            String[] stringArray4 = foxResponse.listStrings("slot_type");
            String[] stringArray5 = foxResponse.listStrings("slot_flag");
            String[] stringArray6 = foxResponse.listStrings("slot_facets");
            String[] stringArray7 = foxResponse.listStrings("slot_value");
            int n = 0;
            while (n < stringArray.length) {
                ValueDocDecoder valueDocDecoder2;
                ValueDocDecoder valueDocDecoder3;
                BTypeSpec bTypeSpec3;
                BFacets bFacets = (BFacets)BFacets.DEFAULT.decodeFromString(stringArray6[n]);
                int n2 = Integer.parseInt(stringArray5[n]);
                BTypeSpec bTypeSpec4 = bTypeSpec3 = stringArray4[n].length() == 0 ? null : BTypeSpec.make((String)stringArray4[n]);
                if (stringArray[n].equals("p")) {
                    valueDocDecoder3 = new ValueDocDecoder((InputStream)new ByteArrayInputStream(stringArray7[n].getBytes()));
                    valueDocDecoder3.setTypeResolver((ValueDocDecoder.ITypeResolver)this.typeResolver);
                    try {
                        valueDocDecoder3.next();
                        valueDocDecoder2 = valueDocDecoder3.decode();
                    }
                    catch (XException xException) {
                        throw new BajaRuntimeException("Unable to decode default value for '" + stringArray3[n] + "' from " + stringArray7[n], (Throwable)xException);
                    }
                    BModule bModule = this.typeResolver.loadModule(valueDocDecoder, null, null, bTypeSpec3.getModuleName() + '=' + bTypeSpec3.getModuleName(), bTypeSpec3.toString());
                    Type type2 = bModule.getType(bTypeSpec3.getTypeName());
                    syntheticComplexType.addProperty(stringArray3[n], type2, n2, (BValue)valueDocDecoder2, bFacets);
                } else if (stringArray[n].equals("a")) {
                    valueDocDecoder3 = null;
                    if (bTypeSpec3 != null) {
                        valueDocDecoder2 = new ValueDocDecoder((InputStream)new ByteArrayInputStream(stringArray7[n].getBytes()));
                        valueDocDecoder2.setTypeResolver((ValueDocDecoder.ITypeResolver)this.typeResolver);
                        valueDocDecoder2.next();
                        valueDocDecoder3 = valueDocDecoder2.decode();
                    }
                    syntheticComplexType.addAction(stringArray3[n], n2, (BValue)valueDocDecoder3, bFacets);
                } else if (stringArray[n].equals("t")) {
                    valueDocDecoder3 = this.typeResolver.loadModule(valueDocDecoder, null, null, bTypeSpec3.getModuleName() + '=' + bTypeSpec3.getModuleName(), bTypeSpec3.toString());
                    syntheticComplexType.addTopic(stringArray3[n], n2, valueDocDecoder3.getType(bTypeSpec3.getTypeName()), bFacets);
                }
                ++n;
            }
        } else if (type instanceof SimpleType) {
            SyntheticSimpleType syntheticSimpleType = (SyntheticSimpleType)type;
            syntheticSimpleType.setTypeInfo((TypeInfo)new SyntheticTypeInfo(type));
        } else {
            throw new IllegalStateException("Invalid type " + type.getClass());
        }
        return type;
    }

    private final FoxResponse loadType(FoxRequest foxRequest) throws Exception {
        Object object;
        BTypeSpec bTypeSpec = BTypeSpec.make((String)foxRequest.getString("type"));
        if (this.isTraceOn()) {
            this.trace("s:loadType " + bTypeSpec.toString());
        }
        Object object2 = object = new FoxResponse(foxRequest);
        do {
            int n;
            Object object3;
            Object object4;
            ((FoxMessage)object2).add("classname", bTypeSpec.getResolvedType().getTypeClass().getName());
            ((FoxMessage)object2).add("typespec", bTypeSpec.toString());
            ((FoxMessage)object2).add("abstract", Modifier.isAbstract(bTypeSpec.getResolvedType().getTypeClass().getModifiers()));
            if (bTypeSpec.getResolvedType().is(BSimple.TYPE) && !bTypeSpec.getResolvedType().isAbstract()) {
                object4 = new ByteArrayOutputStream();
                object3 = new DataOutputStream((OutputStream)object4);
                ((BSimple)bTypeSpec.getInstance()).encode((DataOutput)object3);
                ((FoxMessage)object2).add("default", ((ByteArrayOutputStream)object4).toByteArray());
            }
            if ((object4 = bTypeSpec.getResolvedType()) instanceof EnumType) {
                if (object4 != BFrozenEnum.TYPE && (object3 = (Object)((EnumType)object4).getOrdinals()) != null) {
                    n = 0;
                    while (n < ((NSlot[])object3).length) {
                        ((FoxMessage)object2).add("enum_ordinal", Integer.toString((int)object3[n]));
                        ((FoxMessage)object2).add("enum_tag", ((EnumType)object4).getTag((int)object3[n]));
                        ++n;
                    }
                }
            } else if (object4 instanceof ComplexType) {
                object3 = ((ComplexType)object4).getFrozenSlots();
                n = 0;
                while (n < ((NSlot[])object3).length) {
                    if (object3[n].getDeclaringType().is(bTypeSpec.getResolvedType())) {
                        ValueDocEncoder valueDocEncoder;
                        ByteArrayOutputStream byteArrayOutputStream;
                        Object object5;
                        ((FoxMessage)object2).add("slot_name", object3[n].getName());
                        ((FoxMessage)object2).add("slot_flag", Integer.toString(object3[n].getDefaultFlags()));
                        ((FoxMessage)object2).add("slot_facets", object3[n].getFacets().encodeToString());
                        if (object3[n].isAction()) {
                            ((FoxMessage)object2).add("slot", "a");
                            object5 = object3[n].asAction().getParameterType();
                            if (object5 == null) {
                                ((FoxMessage)object2).add("slot_type", "");
                                ((FoxMessage)object2).add("slot_value", "");
                            } else {
                                ((FoxMessage)object2).add("slot_type", object5.toString());
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
                                valueDocEncoder.encode(object3[n].asAction().getParameterDefault());
                                valueDocEncoder.flush();
                                ((FoxMessage)object2).add("slot_value", byteArrayOutputStream.toString());
                            }
                        } else if (object3[n].isProperty()) {
                            ((FoxMessage)object2).add("slot", "p");
                            ((FoxMessage)object2).add("slot_type", object3[n].asProperty().getType().toString());
                            object5 = new ByteArrayOutputStream();
                            byteArrayOutputStream = new ValueDocEncoder((OutputStream)object5);
                            valueDocEncoder = object3[n].asProperty().getDefaultValue();
                            byteArrayOutputStream.encode((BValue)valueDocEncoder);
                            byteArrayOutputStream.flush();
                            ((FoxMessage)object2).add("slot_value", ((ByteArrayOutputStream)object5).toString());
                        } else if (object3[n].isTopic()) {
                            ((FoxMessage)object2).add("slot", "t");
                            object5 = object3[n].asTopic().getEventType();
                            if (object5 == null) {
                                ((FoxMessage)object2).add("slot_type", "");
                            } else {
                                ((FoxMessage)object2).add("slot_type", object5.toString());
                            }
                            ((FoxMessage)object2).add("slot_value", "");
                        }
                    }
                    ++n;
                }
            }
            if (bTypeSpec.getTypeInfo().getSuperType() != null && !bTypeSpec.getModuleName().equals(Sys.getBajaModule().getModuleName())) {
                object3 = new FoxMessage("superType");
                ((FoxMessage)object2).add((FoxTuple)object3);
                object2 = object3;
                bTypeSpec = bTypeSpec.getTypeInfo().getSuperType().getTypeSpec();
                continue;
            }
            bTypeSpec = null;
        } while (bTypeSpec != null);
        return object;
    }

    RootInfo loadRoot() throws Exception {
        FoxRequest foxRequest = this.makeRequest("loadRoot");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("handle");
        BTypeSpec bTypeSpec = BTypeSpec.make((String)foxResponse.getString("type"));
        boolean bl = foxResponse.getBoolean("spaceReadonly", false);
        long l = foxResponse.getTime("defaultLeaseTime", 60000L);
        if (this.isTraceOn()) {
            this.trace("c:loadRoot " + string + ' ' + bTypeSpec);
        }
        BComponent bComponent = (BComponent)bTypeSpec.getInstance();
        ((ComponentSlotMap)bComponent.fw(1)).setHandle((Object)string);
        return new RootInfo(bComponent, bl, l);
    }

    private final FoxResponse loadRoot(FoxRequest foxRequest) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:loadRoot");
        }
        BComponent bComponent = this.space.getRootComponent();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("handle", String.valueOf(bComponent.getHandle()));
        foxResponse.add("type", bComponent.getType().toString());
        foxResponse.add("spaceReadonly", this.space.isSpaceReadonly());
        foxResponse.add("defaultLeaseTime", this.space.getDefaultLeaseTime());
        return foxResponse;
    }

    public void ensureLoaded(String[] stringArray, int n) throws Exception {
        FoxRequest foxRequest = this.space instanceof BFoxVirtualSpace ? this.makeRequest("loadSlot") : this.makeRequest("load");
        foxRequest.add("depth", n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            foxRequest.add("ord", stringArray[n2].toString());
            ++n2;
        }
        if (this.isTraceOn()) {
            this.trace("c:ensureLoaded[" + stringArray.length + "] depth=" + n);
            n2 = 0;
            while (n2 < stringArray.length) {
                this.trace("  " + stringArray[n2]);
                ++n2;
            }
        }
        this.sendSync(foxRequest);
        this.syncFromMaster();
    }

    public void load(BComponent bComponent, int n) throws Exception {
        this.load(bComponent, n, false);
    }

    public void load(BComponent bComponent, int n, boolean bl) throws Exception {
        String string = this.toOrd(bComponent);
        FoxRequest foxRequest = this.makeRequest("load");
        foxRequest.add("ord", string);
        foxRequest.add("depth", n);
        if (bl) {
            foxRequest.add("reload", bl);
        }
        if (this.isTraceOn()) {
            if (bl) {
                this.trace("c:load \"" + bComponent.toPathString() + "\" depth=" + n + "\" reload=" + bl);
            } else {
                this.trace("c:load \"" + bComponent.toPathString() + "\" depth=" + n);
            }
        }
        this.sendSync(foxRequest);
        this.syncFromMaster();
        if (bComponent instanceof BVirtualComponent) {
            ((ComponentSlotMap)bComponent.fw(1)).setBrokerPropsLoaded(true);
        }
    }

    private final FoxResponse load(FoxRequest foxRequest) throws Exception {
        int n = foxRequest.getInt("depth");
        boolean bl = foxRequest.getBoolean("reload", false);
        FoxTuple[] foxTupleArray = foxRequest.list("ord");
        int n2 = 0;
        while (n2 < foxTupleArray.length) {
            String string = ((FoxString)foxTupleArray[n2]).value;
            try {
                BComponent bComponent = this.fromOrd(string);
                if (this.isTraceOn()) {
                    if (foxTupleArray.length == 1) {
                        this.trace("s:load \"" + bComponent.toPathString() + "\" depth=" + n);
                    } else {
                        if (n2 == 0) {
                            this.trace("s:load[" + foxTupleArray.length + "] depth=" + n);
                        }
                        this.trace("  \"" + bComponent.toPathString() + '\"');
                    }
                }
                BUser bUser = this.getSessionContext().getUser();
                bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
                if (this.space instanceof BVirtualComponentSpace) {
                    if (bl) {
                        ((ComponentSlotMap)bComponent.fw(1)).setBrokerPropsLoaded(false);
                    }
                    bComponent.loadSlots();
                    this.broker.loadOp(bComponent, n, bComponent instanceof BVirtualComponent);
                } else {
                    if (this.space instanceof BIGatewaySpace) {
                        bComponent.loadSlots();
                    }
                    this.broker.loadOp(bComponent, n);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return null;
    }

    public Slot loadSlot(BComponent bComponent, String string, int n) throws Exception {
        String string2 = this.toOrd(bComponent);
        FoxRequest foxRequest = this.makeRequest("loadSlot");
        foxRequest.add("ord", string2);
        foxRequest.add("slotName", string);
        foxRequest.add("depth", n);
        if (this.isTraceOn()) {
            this.trace("c:loadSlot \"" + bComponent.toPathString() + "\" slotName= \"" + string + "\" depth=" + n);
        }
        this.sendSync(foxRequest);
        this.syncFromMaster();
        return bComponent.getSlot(string);
    }

    /*
     * Exception decompiling
     */
    private final FoxResponse loadSlot(FoxRequest var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 490->493)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BValue[] copy(BValue[] bValueArray, CopyHints copyHints) throws Exception {
        Object object;
        BValue[] bValueArray2 = new BValue[bValueArray.length];
        if (this.isTraceOn()) {
            this.trace("c:copy[" + bValueArray.length + ']');
            int n = 0;
            while (n < bValueArray.length) {
                if (bValueArray[n] instanceof BComponent) {
                    this.trace("  \"" + ((BComponent)bValueArray[n]).toPathString() + '\"');
                }
                ++n;
            }
        }
        FoxRequest foxRequest = this.makeRequest("copy");
        foxRequest.add("defaultOnClone", copyHints.defaultOnClone);
        foxRequest.add("swizzleHandles", copyHints.swizzleHandles);
        int n = 0;
        while (n < bValueArray.length) {
            object = bValueArray[n];
            if (object.isComponent()) {
                foxRequest.add("ord", this.toOrd((BComponent)object));
            } else {
                bValueArray2[n] = object.newCopy(copyHints);
            }
            ++n;
        }
        FoxCircuit foxCircuit = this.openCircuit("copy");
        foxCircuit.writeMessage(foxRequest);
        object = foxCircuit.readMessage();
        if (((FoxMessage)object).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)object);
        }
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder(foxCircuit.getInputStream());
        int n2 = 0;
        while (n2 < bValueArray2.length) {
            if (bValueArray2[n2] == null) {
                valueDocDecoder.next();
                bValueArray2[n2] = valueDocDecoder.decode();
            }
            ++n2;
        }
        valueDocDecoder.close();
        return bValueArray2;
    }

    private final void copy(FoxCircuit foxCircuit) throws Exception {
        Object object;
        FoxMessage foxMessage = foxCircuit.readMessage();
        CopyHints copyHints = new CopyHints();
        copyHints.defaultOnClone = foxMessage.getBoolean("defaultOnClone", copyHints.defaultOnClone);
        copyHints.swizzleHandles = foxMessage.getBoolean("swizzleHandles", copyHints.swizzleHandles);
        copyHints.cx = this.getSessionContext();
        FoxTuple[] foxTupleArray = foxMessage.list("ord");
        BValue[] bValueArray = new BValue[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            String string = ((FoxString)foxTupleArray[n]).value;
            object = this.fromOrd(string);
            bValueArray[n] = object;
            if (this.isTraceOn()) {
                if (foxTupleArray.length == 1) {
                    this.trace("s:copy \"" + object.toPathString() + '\"');
                } else {
                    if (n == 0) {
                        this.trace("s:copy[" + foxTupleArray.length + ']');
                    }
                    this.trace("  \"" + object.toPathString() + '\"');
                }
            }
            ++n;
        }
        try {
            bValueArray = BValue.newCopy((BValue[])bValueArray, (CopyHints)copyHints);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(exception));
            foxCircuit.close();
            return;
        }
        foxCircuit.writeMessage(new FoxMessage());
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(foxCircuit.getOutputStream());
        valueDocEncoder.setEncodeTransients(true);
        valueDocEncoder.setEncodeComments(false);
        int n2 = 0;
        while (n2 < bValueArray.length) {
            object = new FoxMessage();
            valueDocEncoder.encode(bValueArray[n2]);
            valueDocEncoder.flush();
            ++n2;
        }
        valueDocEncoder.close();
    }

    public DeleteOp delete(DeleteOp deleteOp, boolean bl) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:delete undo=" + bl);
        }
        FoxRequest foxRequest = this.makeRequest("delete");
        foxRequest.add("undo", bl);
        FoxCircuit foxCircuit = this.openCircuit("delete");
        foxCircuit.writeMessage(foxRequest);
        OutputStream outputStream = foxCircuit.getOutputStream();
        deleteOp.write(outputStream);
        outputStream.flush();
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (foxMessage.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage);
        }
        InputStream inputStream = foxCircuit.getInputStream();
        deleteOp = DeleteOp.make((BComponentSpace)this.space, null, (InputStream)inputStream);
        inputStream.close();
        return deleteOp;
    }

    private final void delete(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        boolean bl = foxMessage.getBoolean("undo");
        if (this.isTraceOn()) {
            this.trace("s:delete undo=" + bl);
        }
        InputStream inputStream = foxCircuit.getInputStream();
        DeleteOp deleteOp = DeleteOp.make((BComponentSpace)this.space, (Context)this.getSessionContext(), (InputStream)inputStream);
        try {
            deleteOp = bl ? deleteOp.undelete() : deleteOp.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(exception));
            foxCircuit.close();
            return;
        }
        foxCircuit.writeMessage(new FoxMessage());
        OutputStream outputStream = foxCircuit.getOutputStream();
        deleteOp.write(outputStream);
        outputStream.close();
    }

    public void subscribe(BComponent[] bComponentArray, int n) throws Exception {
        if (this.isTraceOn()) {
            if (bComponentArray.length == 1) {
                this.trace("c:sub \"" + bComponentArray[0].toPathString() + "\" depth=" + n);
            } else {
                this.trace("c:sub[" + bComponentArray.length + "] depth=" + n);
                int n2 = 0;
                while (n2 < bComponentArray.length) {
                    this.trace("  " + bComponentArray[n2].toPathString());
                    ++n2;
                }
            }
        }
        FoxRequest foxRequest = this.makeRequest("sub");
        int n3 = 0;
        while (n3 < bComponentArray.length) {
            foxRequest.add("ord", this.toOrd(bComponentArray[n3]));
            ++n3;
        }
        foxRequest.add("depth", n);
        this.sendSync(foxRequest);
        this.syncFromMaster();
    }

    private final FoxResponse subscribe(FoxRequest foxRequest) throws Exception {
        int n = foxRequest.getInt("depth");
        FoxTuple[] foxTupleArray = foxRequest.list("ord");
        int n2 = 0;
        while (n2 < foxTupleArray.length) {
            String string = ((FoxString)foxTupleArray[n2]).value;
            BComponent bComponent = this.fromOrd(string);
            if (this.isTraceOn()) {
                if (foxTupleArray.length == 1) {
                    this.trace("s:sub \"" + bComponent.toPathString() + "\" n = " + bComponent.getName() + " depth=" + n + " ord = " + string);
                } else {
                    if (n2 == 0) {
                        this.trace("s:sub[" + foxTupleArray.length + "] depth=" + n);
                    }
                    this.trace("  " + bComponent.toPathString());
                }
            }
            BUser bUser = this.getSessionContext().getUser();
            bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
            if (this.space instanceof BVirtualComponentSpace) {
                this.broker.subscribeOp(bComponent, n, true);
            } else {
                this.broker.subscribeOp(bComponent, n);
            }
            ++n2;
        }
        return null;
    }

    public void unsubscribe(BComponent[] bComponentArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("unsub");
        int n = 0;
        while (n < bComponentArray.length) {
            try {
                foxRequest.add("ord", this.toOrd(bComponentArray[n]));
            }
            catch (Exception exception) {}
            ++n;
        }
        if (this.isTraceOn()) {
            if (bComponentArray.length == 1) {
                this.trace("c:unsub \"" + bComponentArray[0].toPathString() + '\"');
            } else {
                this.trace("c:unsub[" + bComponentArray.length + ']');
                n = 0;
                while (n < bComponentArray.length) {
                    this.trace("  " + bComponentArray[n].toPathString());
                    ++n;
                }
            }
        }
        try {
            this.sendAsync(foxRequest);
        }
        catch (NotConnectedException notConnectedException) {}
    }

    private final FoxResponse unsubscribe(FoxRequest foxRequest) throws Exception {
        FoxTuple[] foxTupleArray = foxRequest.list("ord");
        int n = 0;
        while (n < foxTupleArray.length) {
            String string = ((FoxString)foxTupleArray[n]).value;
            try {
                BComponent bComponent = this.fromOrd(string);
                if (this.isTraceOn()) {
                    this.trace("s:unsub \"" + bComponent.toPathString() + '\"');
                }
                this.broker.unsubscribe(this.fromOrd(string));
            }
            catch (UnresolvedException unresolvedException) {}
            ++n;
        }
        return null;
    }

    public Object[] generateHandles(int n) throws Exception {
        FoxRequest foxRequest = this.makeRequest("generateHandles");
        foxRequest.add("count", n);
        if (this.isTraceOn()) {
            this.trace("c:generateHandles " + n);
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        Object[] objectArray = new Object[n];
        StringTokenizer stringTokenizer = new StringTokenizer(foxResponse.getString("handles"), "|");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return objectArray;
    }

    private final FoxResponse generateHandles(FoxRequest foxRequest) throws Exception {
        int n = foxRequest.getInt("count");
        if (this.isTraceOn()) {
            this.trace("s:generateHandles " + n);
        }
        Object[] objectArray = (Object[])this.space.fw(103, (Object)new Integer(n), null, null, null);
        StringBuffer stringBuffer = new StringBuffer(objectArray.length * 5);
        int n2 = 0;
        while (n2 < objectArray.length) {
            stringBuffer.append(objectArray[n2]).append('|');
            ++n2;
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("handles", stringBuffer.toString());
        return foxResponse;
    }

    public SlotPath[] handleToPath(Object[] objectArray) throws Exception {
        FoxResponse foxResponse;
        FoxTuple[] foxTupleArray;
        FoxRequest foxRequest = this.makeRequest("handleToPath");
        int n = 0;
        while (n < objectArray.length) {
            foxRequest.add("handle", objectArray[n].toString());
            ++n;
        }
        if (this.isTraceOn()) {
            if (objectArray.length == 1) {
                this.trace("c:handleToPath \"" + objectArray[0] + '\"');
            } else {
                this.trace("c:handleToPath[" + objectArray.length + ']');
                n = 0;
                while (n < objectArray.length) {
                    this.trace("  \"" + objectArray[n] + '\"');
                    ++n;
                }
            }
        }
        if ((foxTupleArray = (foxResponse = this.sendSync(foxRequest)).list("path")).length != objectArray.length) {
            throw new IllegalStateException();
        }
        SlotPath[] slotPathArray = new SlotPath[foxTupleArray.length];
        int n2 = 0;
        while (n2 < foxTupleArray.length) {
            String string = ((FoxString)foxTupleArray[n2]).value;
            if (!string.equals("\u0000")) {
                slotPathArray[n2] = new SlotPath(string);
            }
            ++n2;
        }
        return slotPathArray;
    }

    private final FoxResponse handleToPath(FoxRequest foxRequest) throws Throwable {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        FoxTuple[] foxTupleArray = foxRequest.list("handle");
        int n = 0;
        while (n < foxTupleArray.length) {
            SlotPath slotPath;
            String string = ((FoxString)foxTupleArray[n]).value;
            if (this.isTraceOn()) {
                if (foxTupleArray.length == 1) {
                    this.trace("s:handleToPath \"" + string + '\"');
                } else {
                    if (n == 0) {
                        this.trace("s:handleToPath[" + foxTupleArray.length + ']');
                    }
                    this.trace("  \"" + string + '\"');
                }
            }
            String string2 = (slotPath = this.space.handleToSlotPath((Object)string)) == null ? "\u0000" : slotPath.getBody();
            foxResponse.add("path", string2);
            ++n;
        }
        return foxResponse;
    }

    public SlotPath serviceToPath(String string) throws Exception {
        FoxResponse foxResponse;
        String string2;
        FoxRequest foxRequest = this.makeRequest("serviceToPath");
        foxRequest.add("typeSpec", string);
        if (this.isTraceOn()) {
            this.trace("c:serviceToPath " + string);
        }
        if ((string2 = (foxResponse = this.sendSync(foxRequest)).getString("path")) == null) {
            return null;
        }
        return new SlotPath(string2);
    }

    private final FoxResponse serviceToPath(FoxRequest foxRequest) throws Throwable {
        FoxResponse foxResponse;
        block3: {
            String string = foxRequest.getString("typeSpec");
            if (this.isTraceOn()) {
                this.trace("s:serviceToPath " + string);
            }
            foxResponse = new FoxResponse(foxRequest);
            try {
                Type type = Sys.getType((String)string);
                BComponent bComponent = Sys.getService((Type)type);
                SlotPath slotPath = bComponent.getSlotPath();
                foxResponse.add("path", slotPath.getBody());
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                if (!this.isTraceOn()) break block3;
                this.trace("s:serviceToPath " + string + " - ERROR: not found");
            }
        }
        return foxResponse;
    }

    public BValue invoke(BComponent bComponent, Action action, BValue bValue) throws Exception {
        String string = this.toOrd(bComponent);
        FoxRequest foxRequest = this.makeRequest("invoke");
        foxRequest.add("ord", string);
        foxRequest.add("action", action.getName());
        BogCodec.add(foxRequest, "arg", bValue, null);
        if (this.isTraceOn()) {
            this.trace("c:invoke " + string + '.' + action.getName());
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return (BValue)DecoderFactory.decode(foxResponse, "return", null);
    }

    private final FoxResponse invoke(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.getString("ord");
        String string2 = foxRequest.getString("action");
        BValue bValue = (BValue)DecoderFactory.decode(foxRequest, "arg", null);
        if (this.isTraceOn()) {
            this.trace("s:invoke " + string + '.' + string2);
        }
        BComponent bComponent = this.fromOrd(string);
        Action action = bComponent.getAction(string2);
        BValue bValue2 = null;
        Context context = this.getSessionContext();
        try {
            bValue2 = bComponent.invoke(action, bValue, context);
        }
        catch (ActionInvokeException actionInvokeException) {
            this.log.error("Cannot invoke action: " + string + ' ' + string2, actionInvokeException.getCause());
            throw actionInvokeException.getCause();
        }
        catch (Exception exception) {
            this.log.error("Cannot invoke action: " + string + ' ' + string2, exception);
            throw exception;
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BogCodec.add(foxResponse, "return", bValue2, null);
        return foxResponse;
    }

    public BValue rpc(BComponent bComponent, String string, BValue bValue) throws Exception {
        String string2 = this.toOrd(bComponent);
        FoxRequest foxRequest = this.makeRequest("rpc");
        foxRequest.add("ord", string2);
        foxRequest.add("id", string);
        BogCodec.add(foxRequest, "arg", bValue, null);
        if (this.isTraceOn()) {
            this.trace("c:rpc " + string2 + '.' + string);
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return (BValue)DecoderFactory.decode(foxResponse, "return", null);
    }

    private final FoxResponse rpc(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.getString("ord");
        String string2 = foxRequest.getString("id");
        BValue bValue = (BValue)DecoderFactory.decode(foxRequest, "arg", null);
        if (this.isTraceOn()) {
            this.trace("s:rpc " + string + '.' + string2);
        }
        BComponent bComponent = this.fromOrd(string);
        BValue bValue2 = null;
        Context context = this.getSessionContext();
        try {
            bValue2 = (BValue)this.space.fw(109, (Object)bComponent, (Object)string2, (Object)bValue, (Object)context);
        }
        catch (Exception exception) {
            this.log.error("Cannot invoke rpc: " + string + ' ' + string2, exception);
            throw exception;
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BogCodec.add(foxResponse, "return", bValue2, null);
        return foxResponse;
    }

    public void touch(String[] stringArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("touch");
        int n = 0;
        while (n < stringArray.length) {
            foxRequest.add("ord", stringArray[n]);
            ++n;
        }
        if (this.isTraceOn()) {
            this.trace("c:touch[" + stringArray.length + ']');
            n = 0;
            while (n < stringArray.length) {
                this.trace("  " + stringArray[n]);
                ++n;
            }
        }
        try {
            this.sendAsync(foxRequest);
        }
        catch (NotConnectedException notConnectedException) {}
    }

    private final FoxResponse touch(FoxRequest foxRequest) throws Throwable {
        FoxTuple[] foxTupleArray = foxRequest.list("ord");
        if (foxTupleArray == null) {
            return null;
        }
        if (this.isTraceOn()) {
            this.trace("s:touch[" + foxTupleArray.length + ']');
        }
        BOrd[] bOrdArray = new BOrd[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            bOrdArray[n] = (BOrd)BOrd.DEFAULT.decodeFromString(((FoxString)foxTupleArray[n]).value);
            if (this.isTraceOn()) {
                this.trace("  " + bOrdArray[n]);
            }
            ++n;
        }
        this.space.fw(110, (Object)bOrdArray, null, null, null);
        return null;
    }

    public void syncToMaster(SyncBuffer syncBuffer) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:syncToMaster");
        }
        BBrokerChannel.dump(syncBuffer, null);
        FoxCircuit foxCircuit = this.openCircuit("syncToMaster");
        FoxMessage foxMessage = new FoxMessage();
        foxCircuit.writeMessage(foxMessage);
        SyncEncoder syncEncoder = new SyncEncoder(foxCircuit.getOutputStream(), null);
        syncBuffer.encode(syncEncoder);
        syncEncoder.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        FoxMessage foxMessage3 = (FoxMessage)foxMessage2.getOptional("error");
        if (foxMessage3 != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage3);
        }
        this.syncFromMaster();
    }

    public void syncToMaster(FoxCircuit foxCircuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s: --> syncToMaster");
        }
        FoxMessage foxMessage = foxCircuit.readMessage();
        FoxMessage foxMessage2 = new FoxMessage();
        try {
            SyncDecoder syncDecoder = new SyncDecoder(foxCircuit.getInputStream());
            try {
                syncDecoder.setTypeResolver((ValueDocDecoder.ITypeResolver)this.typeResolver);
            }
            catch (Throwable throwable) {}
            SyncBuffer syncBuffer = new SyncBuffer(this.space, false);
            syncBuffer.decode(syncDecoder);
            BBrokerChannel.dump(syncBuffer, null);
            Context context = this.getSessionContext();
            syncBuffer.commit(context);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            foxMessage2.add("error", Fox.exceptionTranslator.exceptionToMessage(throwable));
        }
        foxCircuit.writeMessage(foxMessage2);
        if (this.isTraceOn()) {
            this.trace("s: <--- syncToMaster");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncFromMaster() throws Exception {
        var1_1 = Clock.ticks();
        if (BBrokerChannel.syncLog.isTraceOn()) {
            this.trace("c:doSyncFromMaster " + (var1_1 - this.lastSyncFromMaster) + "ms");
        }
        this.lastSyncFromMaster = var1_1;
        var3_2 = this.syncFromMasterLock;
        synchronized (var3_2) {
            var5_3 = this.openCircuit("syncFromMaster");
            var6_4 = new FoxMessage();
            var5_3.writeMessage(var6_4);
            var7_5 = new SyncBuffer(this.space, false);
            var8_6 = new SyncDecoder(var5_3.getInputStream());
            ** try [egrp 1[TRYBLOCK] [1 : 115->127)] { 
lbl14:
            // 1 sources

            {
                var8_6.setTypeResolver((ValueDocDecoder.ITypeResolver)this.typeResolver);
            }
lbl19:
            // 1 sources

            catch (Throwable v1) {}
            try {
                var7_5.decode(var8_6);
                var10_11 = null;
            }
            catch (Throwable var9_9) {
                var10_10 = null;
                var8_6.close();
                throw var9_9;
            }
            var8_6.close();
            this.syncBuffers.add(this.syncBuffers.size(), var7_5);
            var11_8 = this.syncBuffers.toArray(new SyncBuffer[this.syncBuffers.size()]);
            var12_12 = 0;
            while (var12_12 < var11_8.length) {
                var11_8[var12_12].commit(Context.commit);
                ++var12_12;
            }
            this.syncBuffers.remove(var7_5);
            return;
        }
    }

    public void syncFromMaster(FoxCircuit foxCircuit) throws Exception {
        if (syncLog.isTraceOn()) {
            this.trace("s:syncFromMaster");
        }
        FoxMessage foxMessage = foxCircuit.readMessage();
        SyncBuffer syncBuffer = this.broker.detachBuffer();
        Context context = this.getSessionContext();
        BBrokerChannel.dump(syncBuffer, context);
        SyncEncoder syncEncoder = new SyncEncoder(foxCircuit.getOutputStream(), context);
        syncBuffer.encode(syncEncoder);
        syncEncoder.close();
    }

    public TransferResult transfer(TransferStrategy transferStrategy) throws Exception {
        Version version;
        if (this.isTraceOn()) {
            this.trace("c:transfer");
            transferStrategy.dump();
        }
        if ((version = this.getConnection().getRemoteVersion()) == null || version.compareTo((Object)ver3_2_5) < 0) {
            return this.transferReqRes(transferStrategy);
        }
        return this.transferCircuit(transferStrategy);
    }

    private final TransferResult transferReqRes(TransferStrategy transferStrategy) throws Exception {
        FoxRequest foxRequest = this.makeRequest("transfer");
        TransferCodec.transferToMessage(foxRequest, transferStrategy);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (this.isTraceOn()) {
            if (foxResponse == null) {
                this.trace(" resp:  null");
            } else {
                foxResponse.dump();
            }
        }
        TransferResult transferResult = TransferCodec.messageToResult((BObject)this.space, foxResponse);
        this.syncFromMaster();
        return transferResult;
    }

    FoxResponse transferReqRes(FoxRequest foxRequest) throws Exception {
        Context context = this.getSessionContext();
        TransferStrategy transferStrategy = TransferCodec.messageToTransfer(foxRequest, context);
        if (this.isTraceOn()) {
            this.trace("s:transfer");
            transferStrategy.dump();
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        TransferResult transferResult = transferStrategy.transfer();
        if (transferResult == null) {
            return null;
        }
        return TransferCodec.resultToMessage(foxResponse, transferResult);
    }

    private final TransferResult transferCircuit(TransferStrategy transferStrategy) throws Exception {
        FoxMessage foxMessage;
        FoxRequest foxRequest = this.makeRequest("transferCircuit");
        TransferCodec.transferToMessage(foxRequest, transferStrategy);
        FoxCircuit foxCircuit = this.openCircuit("transferCircuit");
        foxCircuit.writeMessage(foxRequest);
        while (true) {
            foxMessage = null;
            foxMessage = foxCircuit.readMessage();
            String string = foxMessage.getString("s", null);
            if (string == null) break;
            transferStrategy.updateStatus(string);
        }
        if (foxMessage.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage);
        }
        if (foxMessage.getBoolean("done", false)) {
            TransferResult transferResult = TransferCodec.messageToResult((BObject)this.space, foxMessage);
            this.syncFromMaster();
            return transferResult;
        }
        throw new IllegalStateException();
    }

    void transferCircuit(FoxCircuit foxCircuit) throws Exception {
        try {
            Context context = this.getSessionContext();
            FoxMessage foxMessage = foxCircuit.readMessage();
            TransferStrategy transferStrategy = TransferCodec.messageToTransfer(foxMessage, context);
            if (this.isTraceOn()) {
                this.trace("s:transfer");
                transferStrategy.dump();
            }
            transferStrategy.setListener((TransferListener)new BFoxChannel.TransferStatusPipe(foxCircuit));
            TransferResult transferResult = transferStrategy.transfer();
            FoxResponse foxResponse = TransferCodec.resultToMessage(new FoxResponse(), transferResult);
            foxResponse.add("done", true);
            foxCircuit.writeMessage(foxResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(exception));
        }
        foxCircuit.close();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (this.broker != null) {
            this.broker.spy(spyWriter);
        }
        super.spy(spyWriter);
    }

    public final String toOrd(BComponent bComponent) {
        String string = (String)bComponent.getHandle();
        if (string == null) {
            throw new IllegalStateException(bComponent.toDebugString());
        }
        return "h:" + string;
    }

    public final BComponent fromOrd(String string) {
        return (BComponent)BOrd.make((String)string).get((BObject)this.space);
    }

    public static void dump(SyncBuffer syncBuffer, Context context) throws Exception {
        if (DUMP_BUF) {
            try {
                SyncEncoder syncEncoder = new SyncEncoder((OutputStream)System.out, context);
                syncBuffer.encode(syncEncoder);
                syncEncoder.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doSubscriberGc() {
        ProxyBroker proxyBroker = this.broker;
        if (proxyBroker != null) {
            proxyBroker.gc();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.typeResolver = new BrokerTypeResolver();
        this.syncFromMasterLock = new Object();
        this.syntheticModuleMap = null;
        this.syncBuffers = Collections.synchronizedList(new ArrayList());
        this.eventCache = new ThreadLocal();
    }

    public BBrokerChannel() {
        super("broker");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$fox$sys$broker$BBrokerChannel;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$broker$BBrokerChannel = BBrokerChannel.class("[Lcom.tridium.fox.sys.broker.BBrokerChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ver3_2_5 = new Version("3.2.5");
        DUMP_BUF = false;
        POLL_RATE = 500;
        syncLog = Log.getLog((String)"fox.broker.sync");
    }

    static class RootInfo {
        BComponent root;
        boolean spaceReadonly;
        long defaultLeaseTime;

        RootInfo(BComponent bComponent, boolean bl, long l) {
            this.root = bComponent;
            this.spaceReadonly = bl;
            this.defaultLeaseTime = l;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ClientSyncThread
    extends Thread {
        boolean isAlive;
        int count;

        public void kill() {
            this.isAlive = false;
            this.interrupt();
        }

        public synchronized void run() {
            while (this.isAlive) {
                try {
                    ClientSyncThread.sleep(POLL_RATE);
                    if (Clock.ticks() - BBrokerChannel.this.lastSyncFromMaster < (long)POLL_RATE) continue;
                    BBrokerChannel.this.syncFromMaster();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    if (!this.isAlive) continue;
                    exception.printStackTrace();
                }
            }
        }

        private final /* synthetic */ void this() {
            this.isAlive = true;
        }

        ClientSyncThread(String string) {
            super(Fox.threadGroup, string);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FoxProxyBroker
    extends ProxyBroker {
        public void event(BComponentEvent bComponentEvent) {
            Array array = (Array)BBrokerChannel.this.eventCache.get();
            if (array != null) {
                array.add((Object)bComponentEvent);
                return;
            }
            super.event(bComponentEvent);
        }

        public void navEvent(NavEvent navEvent) {
            Array array = (Array)BBrokerChannel.this.eventCache.get();
            if (array != null) {
                array.add((Object)navEvent);
                return;
            }
            super.navEvent(navEvent);
            if (!(navEvent.getParent() instanceof BComponent)) {
                return;
            }
            switch (navEvent.getId()) {
                case 2: 
                case 5: {
                    BBrokerChannel.this.subscriberGc();
                    break;
                }
            }
        }

        public String toString() {
            return "ProxyBroker for FoxServerConnection [" + BBrokerChannel.this.getConnection().session() + ']';
        }

        FoxProxyBroker(BComponentSpace bComponentSpace) {
            super(bComponentSpace);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BrokerTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        public BModule loadModule(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, String string2, String string3) {
            try {
                return super.loadModule(valueDocDecoder, bComplex, string, string2, string3);
            }
            catch (XException xException) {
                int n = string2.indexOf(61);
                String string4 = string2.substring(0, n).trim();
                String string5 = string2.substring(n + 1).trim();
                Throwable throwable = xException.getCause();
                if (throwable instanceof ModuleException && Fox.appName.equals("Station")) {
                    try {
                        this.getModuleMap(valueDocDecoder).put(string4, null);
                    }
                    catch (Exception exception) {
                        throw xException;
                    }
                    if (syncLog.isTraceOn()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Skipping property '").append(string);
                        stringBuffer.append("', type='").append(string3);
                        stringBuffer.append("' on parent '");
                        if (bComplex == null) {
                            stringBuffer.append("null");
                        } else {
                            stringBuffer.append(bComplex.getType().getDisplayName(null));
                        }
                        stringBuffer.append("': ").append(xException.getMessage());
                        stringBuffer.append(" [").append(valueDocDecoder.line()).append(":").append(valueDocDecoder.column()).append("]");
                        syncLog.trace(stringBuffer.toString());
                    }
                    return null;
                }
                NModule nModule = BBrokerChannel.this.loadModule(valueDocDecoder, string4, string5);
                this.getModuleMap(valueDocDecoder).put(string4, nModule);
                return nModule.bmodule();
            }
        }

        NModule getModule(ValueDocDecoder valueDocDecoder, String string) {
            return (NModule)this.getModuleMap(valueDocDecoder).get(string);
        }

        public BValue newInstance(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, Property property, String string2) {
            try {
                return super.newInstance(valueDocDecoder, bComplex, string, property, string2);
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof ModuleException && Fox.appName.equals("Station")) {
                    if (syncLog.isTraceOn()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Skipping property '").append(string);
                        stringBuffer.append("', type='").append(string2);
                        stringBuffer.append("' on parent '");
                        if (bComplex == null) {
                            stringBuffer.append("null");
                        } else {
                            stringBuffer.append(bComplex.getType().getDisplayName(null));
                        }
                        stringBuffer.append("': ").append(runtimeException.getMessage());
                        stringBuffer.append(" [").append(valueDocDecoder.line()).append(":").append(valueDocDecoder.column()).append("]");
                        syncLog.trace(stringBuffer.toString());
                    }
                    try {
                        valueDocDecoder.skip();
                    }
                    catch (XException xException) {
                        throw xException;
                    }
                    catch (Exception exception) {
                        throw new XException((Throwable)exception);
                    }
                    return null;
                }
                throw runtimeException;
            }
        }

        BrokerTypeResolver() {
        }
    }
}

