/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.LocalizableServerException;
import com.tridium.fox.sys.ModuleNotFoundRemoteException;
import com.tridium.util.ThrowableUtil;
import java.io.IOException;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleNotFoundException;

public class LocalizableExceptionTranslator
extends Fox.ExceptionTranslator {
    public FoxMessage exceptionToMessage(Throwable throwable) {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("exception", throwable.toString());
        try {
            ModuleNotFoundException moduleNotFoundException = LocalizableExceptionTranslator.getModuleNotFoundException(throwable);
            if (moduleNotFoundException != null) {
                foxMessage.add("moduleNotFound", moduleNotFoundException.getModuleName());
                return foxMessage;
            }
            if (throwable instanceof LocalizableException) {
                LocalizableException localizableException = (LocalizableException)throwable;
                foxMessage.add("lexModule", localizableException.getLexiconModule());
                foxMessage.add("lexKey", localizableException.getLexiconKey());
                Object[] objectArray = localizableException.getLexiconArguments();
                if (objectArray != null && objectArray.length > 0) {
                    foxMessage.add(this.argsToMessage(objectArray));
                }
            } else if (throwable instanceof LocalizableRuntimeException) {
                LocalizableRuntimeException localizableRuntimeException = (LocalizableRuntimeException)throwable;
                foxMessage.add("lexModule", localizableRuntimeException.getLexiconModule());
                foxMessage.add("lexKey", localizableRuntimeException.getLexiconKey());
                Object[] objectArray = localizableRuntimeException.getLexiconArguments();
                if (objectArray != null && objectArray.length > 0) {
                    foxMessage.add(this.argsToMessage(objectArray));
                }
            }
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
        return foxMessage;
    }

    public Exception messageToException(FoxMessage foxMessage) throws IOException {
        try {
            String string = foxMessage.getString("moduleNotFound", null);
            if (string != null) {
                return new ModuleNotFoundRemoteException(string);
            }
            String string2 = foxMessage.getString("lexModule", null);
            if (string2 != null) {
                String string3 = foxMessage.getString("lexKey", null);
                Object[] objectArray = this.messageToArgs((FoxMessage)foxMessage.getOptional("lexArgs"));
                return new LocalizableServerException(string2, string3, objectArray);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (foxMessage == null) {
            return new ServerException("cause unknown");
        }
        return new ServerException(foxMessage.getString("exception", "cause unknown"));
    }

    FoxMessage argsToMessage(Object[] objectArray) {
        FoxMessage foxMessage = new FoxMessage("lexArgs");
        int n = 0;
        while (n < objectArray.length) {
            foxMessage.add("a", String.valueOf(objectArray[n]));
            ++n;
        }
        return foxMessage;
    }

    Object[] messageToArgs(FoxMessage foxMessage) {
        if (foxMessage == null) {
            return null;
        }
        FoxTuple[] foxTupleArray = foxMessage.list("a");
        Object[] objectArray = new Object[foxTupleArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = ((FoxString)foxTupleArray[n]).value;
            ++n;
        }
        return objectArray;
    }

    static ModuleNotFoundException getModuleNotFoundException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof ModuleNotFoundException) {
                return (ModuleNotFoundException)throwable;
            }
            throwable = ThrowableUtil.getCause((Throwable)throwable);
        }
        return null;
    }
}

