/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxScheme;
import com.tridium.fox.sys.BFoxsScheme;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.sys.FatalAuthenticationException;
import com.tridium.fox.sys.LocalizableExceptionTranslator;
import com.tridium.fox.sys.LocalizableServerException;
import com.tridium.fox.sys.ModuleNotFoundLocalException;
import com.tridium.fox.sys.ModuleNotFoundRemoteException;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.util.ArrayUtil;
import com.tridium.util.BSessionInfo;
import com.tridium.util.IFoxSession;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BServiceScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nav.NavFileDecoder;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxSession
extends BFoxProxySession
implements AuthenticationRealm,
BServiceScheme.ServiceSession,
IFoxSession,
BFoxClientConnection.Interest {
    public static final Type TYPE;
    private static final BIcon iconConnected;
    private static final BIcon iconDisconnected;
    private static final BIcon tunnelIconConnected;
    private static final BIcon tunnelIconDisconnected;
    private static final BIcon secureBadgeConnected;
    private static final BIcon secureBadgeDisconnected;
    String[] tunnelAuthorities;
    private final BHost host;
    private boolean useFoxs;
    private int port;
    private final BFoxClientConnection connection;
    private boolean connected;
    private BOrd absOrd;
    private BOrd ordInHost;
    private String stationName;
    private BIUserCredentials credentials;
    private String authenticationScheme;
    private Context sessionContext;
    String stationFault;
    public Object uiCache;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxSession;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$sys$BAbsTime;
    static /* synthetic */ Class class$java$net$Socket;

    public Type getType() {
        return TYPE;
    }

    public static BFoxSession[] list() {
        ArrayList<BINavNode> arrayList = new ArrayList<BINavNode>();
        BHost[] bHostArray = BHost.getAllHosts();
        int n = 0;
        while (n < bHostArray.length) {
            BHost bHost = bHostArray[n];
            BINavNode[] bINavNodeArray = bHost.getNavChildren();
            int n2 = 0;
            while (n2 < bINavNodeArray.length) {
                if (bINavNodeArray[n2] instanceof BFoxSession) {
                    arrayList.add(bINavNodeArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new BFoxSession[arrayList.size()]);
    }

    public static BFoxSession make(BHost bHost, int n) {
        return BFoxSession.make(null, bHost, n, false);
    }

    public static BFoxSession make(BHost bHost, int n, boolean bl) {
        return BFoxSession.make(null, bHost, n, bl);
    }

    public static BFoxSession make(String string, BHost bHost, int n, boolean bl) {
        return BFoxSession.make(string, bHost, n, bl, null);
    }

    public static BFoxSession make(String string, BHost bHost, int n, boolean bl, String string2) {
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = new String[]{string2};
        }
        return BFoxSession.make(string, bHost, n, bl, stringArray);
    }

    public static BFoxSession make(String string, BHost bHost, int n, boolean bl, String[] stringArray) {
        String string2 = BFoxSession.buildNavName(n, bl, stringArray);
        BFoxSession bFoxSession = (BFoxSession)bHost.getNavChild(string2);
        if (bFoxSession == null) {
            bFoxSession = new BFoxSession(string2, string, bHost, n, bl, stringArray);
            bHost.addNavChild((BINavNode)bFoxSession);
        }
        return bFoxSession;
    }

    protected static String buildNavName(int n, boolean bl, String[] stringArray) {
        int n2;
        String string = bl ? "foxs" : "fox";
        int n3 = n2 = bl ? 4911 : 1911;
        if (n != n2) {
            string = string + ':' + n;
        }
        if (stringArray != null) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4] != null) {
                    string = string + '/' + stringArray[n4];
                }
                ++n4;
            }
        }
        return string;
    }

    public BHost getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean getUseFoxs() {
        return this.useFoxs;
    }

    public void setUseFoxs(boolean bl) {
        this.useFoxs = bl;
    }

    public String[] getTunnelAuthorities() {
        return this.tunnelAuthorities;
    }

    public BFoxClientConnection getConnection() {
        return this.connection;
    }

    public String getStationName() {
        return this.stationName;
    }

    public BSessionInfo getSessionInfo() {
        BSessionInfo bSessionInfo;
        FoxSession foxSession = this.connection.session();
        BAbsTime bAbsTime = BAbsTime.make((long)foxSession.getConnectTime());
        Type type = BSessionInfo.TYPE;
        if (this.useFoxs) {
            type = Sys.getType((String)"platCrypto:SslSessionInfo");
        }
        Class clazz = type.getTypeClass();
        String string = null;
        if (this.getCredentials() instanceof BIUserCredentials) {
            string = ((BIUserCredentials)this.getCredentials()).getUsername();
        }
        try {
            Class clazz2;
            Class clazz3;
            Class clazz4;
            Class[] classArray = new Class[4];
            Class clazz5 = class$java$lang$String;
            if (clazz5 == null) {
                clazz5 = classArray[0] = (class$java$lang$String = BFoxSession.class("[Ljava.lang.String;", false));
            }
            if ((clazz4 = class$javax$baja$sys$BAbsTime) == null) {
                clazz4 = classArray[1] = (class$javax$baja$sys$BAbsTime = BFoxSession.class("[Ljavax.baja.sys.BAbsTime;", false));
            }
            if ((clazz3 = class$java$net$Socket) == null) {
                clazz3 = classArray[2] = (class$java$net$Socket = BFoxSession.class("[Ljava.net.Socket;", false));
            }
            if ((clazz2 = class$java$lang$String) == null) {
                clazz2 = class$java$lang$String = BFoxSession.class("[Ljava.lang.String;", false);
            }
            classArray[3] = clazz2;
            Method method = clazz.getMethod("make", classArray);
            Socket socket = foxSession.getSocket();
            bSessionInfo = (BSessionInfo)method.invoke(null, this.stationName, bAbsTime, socket, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bSessionInfo = null;
        }
        return bSessionInfo;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect() throws Exception {
        if (this.connected) {
            return;
        }
        if (this.credentials == null) {
            this.credentials = new BUsernameAndPassword();
        }
        this.connection.setCredentials((BICredentials)this.credentials);
        this.connection.setUsername(this.credentials.getUsername());
        try {
            this.connection.connect();
            BOrd bOrd = null;
            if (this.tunnelAuthorities != null) {
                this.setLexiconText(LexiconText.make((String)"fox", (String)"nav.foxTunnelSession"));
                bOrd = this.useFoxs ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(this.port, this.tunnelAuthorities)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(this.port, this.tunnelAuthorities));
            } else {
                bOrd = this.useFoxs ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(this.port)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(this.port));
            }
            if (!bOrd.equivalent((Object)this.ordInHost)) {
                this.ordInHost = bOrd;
                this.absOrd = BOrd.make((BOrd)this.host.getAbsoluteOrd(), (BOrd)this.ordInHost);
            }
            if (!this.connection.hasInterests()) {
                this.connection.engageNoRetry(this, 0L);
            }
        }
        catch (FoxAuthenticationException foxAuthenticationException) {
            if (foxAuthenticationException.fatal != null) {
                throw new FatalAuthenticationException(foxAuthenticationException.fatal);
            }
            this.authenticationScheme = foxAuthenticationException.method == null ? "Fox" : "Fox (" + foxAuthenticationException.method + ')';
            throw new AuthenticationException((AuthenticationRealm)this, (Throwable)foxAuthenticationException);
        }
    }

    void postConnect() throws Exception {
        FoxMessage foxMessage = this.connection.session().getRemoteHello();
        this.stationName = null;
        try {
            this.stationName = foxMessage.getString("station.name");
        }
        catch (Exception exception) {}
        this.connection.getChannels().getUserChannel().fetchPrefs();
        this.connection.getChannels().getSysChannel().subscribeNavEvents();
        this.loadSubSpaces();
        this.loadNavFileSpace();
        BTimeZone bTimeZone = BTimeZone.getLocal();
        try {
            bTimeZone = (BTimeZone)BTimeZone.DEFAULT.decodeFromString(foxMessage.getString("timeZone"));
        }
        catch (Exception exception) {}
        this.sessionContext = BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone, (String)"username", (BIDataValue)BString.make((String)this.getUsername()));
        this.connected = true;
    }

    public void disconnect() {
        this.connection.disengage(this);
        this.connection.close();
    }

    public void close() {
        this.disconnect();
        this.host.removeNavChild((BINavNode)this);
    }

    public String getStationFault() {
        return this.stationFault;
    }

    public Context getSessionContext() {
        return this.sessionContext;
    }

    public String getUsername() {
        return this.connection.getUsername();
    }

    public BAbsTime getLastFailureTime() {
        return this.connection.getLastFailureTime();
    }

    public String getLastFailureCause() {
        return this.connection.getLastFailureCause();
    }

    public BRelTime getRetryPeriod() {
        return this.connection.getRetryPeriod();
    }

    public void setRetryPeriod(BRelTime bRelTime) {
        this.connection.setRetryPeriod(bRelTime);
    }

    public BAbsTime getNextAttemptTime() {
        return this.connection.getNextAttemptTime();
    }

    public boolean isEngaged(String string) {
        return this.connection.isEngaged(this.toInterest(string));
    }

    public void engageNoRetry(String string) throws Exception {
        this.connection.engageNoRetry(this.toInterest(string));
    }

    public void engageNoRetry(String string, long l) throws Exception {
        this.connection.engageNoRetry(this.toInterest(string), l);
    }

    public void engageRetry(String string) throws Exception {
        this.connection.engageRetry(this.toInterest(string));
    }

    public void disengage(String string) {
        this.connection.disengage(this.toInterest(string));
    }

    private final BFoxClientConnection.Interest toInterest(String string) {
        return new BFoxClientConnection.StringInterest(string);
    }

    synchronized void sessionOpened() {
    }

    synchronized void sessionClosed() {
        this.connected = false;
        this.stationFault = null;
        this.unloadSubSpaces();
        this.credentials = null;
        this.connection.setUsername("");
        this.connection.setPassword(BPassword.DEFAULT);
    }

    public String getAuthenticationRealmName() {
        return this.absOrd.toString();
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    public BICredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(BICredentials bICredentials) {
        if (!(bICredentials instanceof BIUserCredentials)) {
            throw new IllegalArgumentException();
        }
        this.credentials = (BIUserCredentials)bICredentials;
    }

    public void loadSubSpaces() {
        try {
            BSysChannel bSysChannel = this.getConnection().getChannels().getSysChannel();
            HashMap hashMap = bSysChannel.listLocalSpaces();
            TypeInfo[] typeInfoArray = Sys.getRegistry().getTypes(BIFoxProxySpace.TYPE.getTypeInfo());
            int n = 0;
            while (n < typeInfoArray.length) {
                TypeInfo typeInfo = typeInfoArray[n];
                if (!typeInfo.isInterface() && !typeInfo.isAbstract()) {
                    try {
                        BSpace bSpace = (BSpace)typeInfoArray[n].getInstance();
                        if (hashMap.containsKey(bSpace.getNavName()) && this.getNavChild(bSpace.getNavName()) == null) {
                            ((BIFoxProxySpace)bSpace).init(this);
                            this.addNavChild((BINavNode)bSpace);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
        }
        catch (LocalizableServerException localizableServerException) {
            if (localizableServerException.getLexiconModule().equals("fox") && localizableServerException.getLexiconKey().equals("error.NoPermissionForStation")) {
                throw localizableServerException;
            }
            localizableServerException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void loadNavFileSpace() {
        BOrd bOrd = null;
        try {
            Object[] objectArray = this.getNavChildren();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof BNavFileSpace) {
                    this.removeNavChild(objectArray[n]);
                    break;
                }
                ++n;
            }
            bOrd = this.connection.getChannels().getUserChannel().getNavFile();
            if (bOrd.isNull()) {
                return;
            }
            BIFile bIFile = (BIFile)bOrd.get((BObject)this);
            BNavFileSpace bNavFileSpace = new NavFileDecoder(bIFile).decodeDocument();
            this.addNavChild((BINavNode)bNavFileSpace);
            objectArray = this.getNavChildren();
            objectArray = (BINavNode[])ArrayUtil.toTop((Object[])objectArray, (int)(objectArray.length - 1));
            this.reorderNavChildren((BINavNode[])objectArray);
        }
        catch (Throwable throwable) {
            System.out.println("ERROR:  Cannot load nav file \"" + bOrd + "\": " + throwable);
        }
    }

    public void unloadSubSpaces() {
        try {
            BINavNode[] bINavNodeArray = this.getNavChildren();
            int n = 0;
            while (n < bINavNodeArray.length) {
                try {
                    BINavNode bINavNode = bINavNodeArray[n];
                    if (bINavNode instanceof BIFoxProxySpace) {
                        BIFoxProxySpace bIFoxProxySpace = (BIFoxProxySpace)bINavNode;
                        bIFoxProxySpace.cleanup(this);
                    }
                    this.removeNavChild(bINavNode);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public String getNavDisplayName(Context context) {
        String string = super.getNavDisplayName(context);
        if (!this.useFoxs) {
            if (this.connection.getPort() != 1911) {
                string = string + ':' + this.connection.getPort();
            }
        } else if (this.connection.getPort() != 4911) {
            string = string + ':' + this.connection.getPort();
        }
        if (this.stationName != null) {
            string = string + " (" + this.stationName + ')';
            return string;
        }
        return string;
    }

    public BOrd getNavOrd() {
        return this.absOrd;
    }

    public BComponent getService(Type type) {
        try {
            BBrokerChannel bBrokerChannel = (BBrokerChannel)this.connection.getChannels().get("station", BBrokerChannel.TYPE);
            SlotPath slotPath = bBrokerChannel.serviceToPath(type.toString());
            BOrd bOrd = BOrd.make((String)("station:|" + slotPath));
            return (BComponent)bOrd.get((BObject)this);
        }
        catch (Exception exception) {
            throw new ServiceNotFoundException(type.toString(), (Throwable)exception);
        }
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        if (this.tunnelAuthorities != null) {
            agentList.toTop("workbench:FoxTunnelSessionAgent");
        } else {
            agentList.toTop("workbench:FoxSessionAgent");
        }
        agentList.toTop("workbench:StationSummary");
        agentList.remove("workbench:NavContainerView");
        return agentList;
    }

    public BIcon getIcon() {
        BIcon bIcon = null;
        if (this.isConnected()) {
            BIcon bIcon2 = bIcon = this.tunnelAuthorities == null ? iconConnected : tunnelIconConnected;
            if (this.useFoxs) {
                return BIcon.make((BIcon)bIcon, (BIcon)secureBadgeConnected);
            }
        } else {
            BIcon bIcon3 = bIcon = this.tunnelAuthorities == null ? iconDisconnected : tunnelIconDisconnected;
            if (this.useFoxs) {
                return BIcon.make((BIcon)bIcon, (BIcon)secureBadgeDisconnected);
            }
        }
        return bIcon;
    }

    public static RuntimeException toException(Throwable throwable) {
        if (throwable instanceof ModuleNotFoundLocalException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof ModuleNotFoundRemoteException) {
            return (RuntimeException)throwable;
        }
        ModuleNotFoundException moduleNotFoundException = LocalizableExceptionTranslator.getModuleNotFoundException(throwable);
        if (moduleNotFoundException != null) {
            return new ModuleNotFoundLocalException(moduleNotFoundException.getModuleName(), throwable);
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new BajaRuntimeException(throwable);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        boolean bl = false;
        switch (n) {
            case 805: 
            case 806: {
                bl = true;
            }
            case 801: 
            case 802: {
                String string = (String)object;
                BHost bHost = (BHost)object2;
                String string2 = bl ? "fwFoxs-" + bHost.getHostname() : "fwFox-" + bHost.getHostname();
                int n2 = bl ? 4911 : 1911;
                int n3 = object3 != null ? (Integer)object3 : n2;
                String[] stringArray = (String[])object4;
                if (n3 != n2) {
                    string2 = string2 + ':' + n3;
                }
                if (stringArray != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray[n4] != null) {
                            string2 = string2 + '/' + stringArray[n4];
                        }
                        ++n4;
                    }
                }
                BFoxSession bFoxSession = new BFoxSession(string2, string, bHost, n3, bl, stringArray);
                Integer n5 = n == 801 || n == 805 ? FoxSession.FW_FOX_SESSION : FoxSession.FW_STATION_FOX_SESSION;
                bFoxSession.connection.fw(803, n5, null, null, null);
                return bFoxSession;
            }
            case 404: {
                if (object == null || ((String)object).equalsIgnoreCase("baja")) {
                    return this.getConnection().getRemoteVersion();
                }
                if (this.getConnection().getRemoteVersion().compareTo((Object)new Version(new int[]{3, 6, 13})) != -1) {
                    BSysChannel bSysChannel = this.getConnection().getChannels().getSysChannel();
                    try {
                        byte[] byArray = bSysChannel.stationCall("module.version", ((String)object).getBytes());
                        return new Version(new String(byArray));
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tunnelAuthorities = null;
        this.authenticationScheme = "Fox";
        this.uiCache = null;
    }

    private BFoxSession(String string, String string2, BHost bHost, int n, boolean bl, String[] stringArray) {
        super(string);
        this.this();
        this.stationName = string2;
        this.host = bHost;
        this.port = n;
        this.useFoxs = bl;
        this.tunnelAuthorities = stringArray;
        if (stringArray != null) {
            this.setLexiconText(LexiconText.make((String)"fox", (String)"nav.foxTunnelSession"));
            this.ordInHost = bl ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(n, stringArray)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(n, stringArray));
        } else {
            this.ordInHost = bl ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(n)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(n));
        }
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.connection = new BFoxClientConnection(this);
        if (Fox.appVersion == "unknown") {
            try {
                Fox.appVersion = "" + Sys.getBajaModule().getVendorVersion();
            }
            catch (Exception exception) {}
            try {
                Fox.hostName = Sys.getLocalHost().getHostName();
            }
            catch (Exception exception) {}
            try {
                Fox.hostAddress = Sys.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {}
        }
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxSession;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxSession = BFoxSession.class("[Lcom.tridium.fox.sys.BFoxSession;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        iconConnected = BIcon.std((String)"fox.png");
        iconDisconnected = BIcon.std((String)"foxDisconnected.png");
        tunnelIconConnected = BIcon.std((String)"foxTunnel.png");
        tunnelIconDisconnected = BIcon.std((String)"foxTunnelDisconnected.png");
        secureBadgeConnected = BIcon.std((String)"badges/lock.png");
        secureBadgeDisconnected = BIcon.std((String)"badges/lockDisconnected.png");
    }
}

