/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxAuthAgent;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.FatalAuthenticationException;
import com.tridium.nre.auth.ScramSha256Server;
import com.tridium.util.ValueByteBuffer;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.AuthenticateUtil;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxDefaultAuthAgent
extends BFoxAuthAgent {
    public static final BFoxDefaultAuthAgent INSTANCE = new BFoxDefaultAuthAgent();
    public static final Type TYPE;
    Lexicon lex;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxDefaultAuthAgent;

    public Type getType() {
        return TYPE;
    }

    protected boolean authenticateBasic(FoxSession foxSession) throws Exception {
        BUsernameAndPassword bUsernameAndPassword;
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("method", "basic");
        foxSession.setState("server.tune sendChallenge basic");
        foxSession.sendTuning("challenge", foxMessage);
        foxSession.setState("server.tune receiveLogin");
        FoxMessage foxMessage2 = foxSession.receiveTuning("login");
        String string = foxMessage2.getString("username");
        String string2 = foxMessage2.getString("password", null);
        BICredentials bICredentials = this.extractCredentials(foxSession, foxMessage2);
        if (bICredentials != null) {
            if (bICredentials instanceof BUsernameAndPassword) {
                bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
                string = bUsernameAndPassword.getUsername();
                string2 = bUsernameAndPassword.getPassword().encodeToString();
            } else if (bICredentials instanceof BHttpFoxCredentials) {
                bUsernameAndPassword = (BHttpFoxCredentials)bICredentials;
                string = bUsernameAndPassword.getUsername();
                string2 = "";
            } else {
                throw new FoxAuthenticationException("Unsupported credential type: " + bICredentials.getType().getTypeName(), foxSession);
            }
        }
        foxSession.setState("server.tune receivedLogin user=" + string + " pass.len=" + string2.length());
        Acceptor.accept(foxSession);
        bUsernameAndPassword = this.authenticateAttempt(foxSession, string);
        Context context = this.getAuditContext(foxSession);
        BUser bUser = null;
        if (bICredentials instanceof BHttpFoxCredentials) {
            try {
                bUser = BUserService.httpHandler.processCredentials((BHttpFoxCredentials)bICredentials, foxSession.getRemoteHost());
                bUser.authenticateOk((BUserService)bUsernameAndPassword);
                bUsernameAndPassword.auditLoginAttempt(true, bUser, context);
            }
            catch (AuthenticationException authenticationException) {
                if (bUser != null) {
                    bUser.authenticateFailed((BUserService)bUsernameAndPassword);
                    bUsernameAndPassword.auditLoginAttempt(false, bUser, context);
                }
                if (authenticationException.getMessage().startsWith("Fatal")) {
                    throw authenticationException;
                }
                return false;
            }
        }
        try {
            bUser = this.authenticateUser((BUserService)bUsernameAndPassword, string, string2, context);
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        this.authenticateSuccess(foxSession, bUser);
        return true;
    }

    protected boolean authenticateDigest(FoxSession foxSession) throws Exception {
        FoxMessage foxMessage = foxSession.getRemoteHello();
        if (foxMessage.getString("fox.version", "1.0").compareTo("1.0.1") < 0) {
            BFoxService bFoxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            BAbsTime bAbsTime = bFoxService.getLegacyAuthentication();
            if (!bAbsTime.isNull() && bAbsTime.isAfter(BAbsTime.now())) {
                return this.authenticateBasic(foxSession);
            }
            Log log = Log.getLog((String)"fox");
            if (log.isTraceOn()) {
                log.error(this.lex.getText("fox.legacy.cannotAuth"));
            }
            return false;
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("method", "digest");
        foxSession.setState("server.tune sendChallenge digest");
        foxSession.sendTuning("challenge", foxMessage2);
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser bUser = null;
        Context context = this.getAuditContext(foxSession);
        try {
            Acceptor.accept(foxSession);
            ScramSha256Server scramSha256Server = new ScramSha256Server((ScramSha256Server.IUserKeyFactory)new FoxUserKeyFactory(foxSession));
            bUserService = this.authenticateAttempt(foxSession, scramSha256Server.getUserName());
            foxSession.setState("server.tune receive firstMessage");
            FoxMessage foxMessage3 = foxSession.receiveTuning("authMessage1");
            String string = foxMessage3.getString("authInput");
            if (string.equals("authInputHttp")) {
                try {
                    byte[] byArray = foxMessage3.getBlob("credentials");
                    BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)ValueByteBuffer.unmarshal((byte[])byArray);
                    bUser = BUserService.httpHandler.processCredentials(bHttpFoxCredentials, foxSession.getRemoteHost());
                }
                catch (AuthenticationException authenticationException) {
                    if (authenticationException.getMessage().startsWith("Fatal")) {
                        throw new FatalAuthenticationException(authenticationException.getMessage());
                    }
                    throw authenticationException;
                }
            } else if (string.equals("authInputScram")) {
                String string2 = foxMessage3.getString("authHandshake1");
                String string3 = scramSha256Server.createServerFirstMessage(string2);
                bUser = bUserService.getUser(scramSha256Server.getUserName());
                FoxMessage foxMessage4 = new FoxMessage();
                foxMessage4.add("authHandshake1", string3);
                foxSession.setState("server.tune send scramsha1-serverFirstMessage");
                foxSession.sendTuning("authMessage1", foxMessage4);
                foxSession.setState("server.tune receive scramsha1-clientFinalMessage");
                foxMessage3 = foxSession.receiveTuning("authMessage2");
                String string4 = foxMessage3.getString("authHandshake2");
                String string5 = scramSha256Server.createServerFinalMessage(string4);
                foxMessage4 = new FoxMessage();
                foxMessage4.add("authHandshake2", string5);
                foxSession.setState("server.tune send scramsha1-serverFinalMessage");
                foxSession.sendTuning("authMessage2", foxMessage4);
            } else if (string.equals("authInputRetrieve")) {
                throw new IllegalStateException("Password retrieval is not supported.");
            }
            bUser.authenticateOk(bUserService);
            bUserService.auditLoginAttempt(true, bUser, context);
            this.authenticateSuccess(foxSession, bUser);
            return true;
        }
        catch (FatalAuthenticationException fatalAuthenticationException) {
            throw fatalAuthenticationException;
        }
        catch (Exception exception) {
            if (bUser != null) {
                bUser.authenticateFailed(bUserService);
                bUserService.auditLoginAttempt(false, bUser, context);
            }
            return false;
        }
    }

    protected Context getAuditContext(FoxSession foxSession) {
        BFacets bFacets = null;
        if (BFoxService.auditConnection(foxSession)) {
            bFacets = BFacets.make((String)"target", (BIDataValue)BString.make((String)((BFoxServerConnection)foxSession.conn()).toPathString()), (String)"slotName", (BIDataValue)BString.make((String)foxSession.getRemoteHost()));
        }
        return bFacets;
    }

    protected BUser authenticateUser(BUserService bUserService, String string, String string2, Context context) {
        return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)bUserService, (Context)context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$fox$sys$BFoxDefaultAuthAgent;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxDefaultAuthAgent = BFoxDefaultAuthAgent.class("[Lcom.tridium.fox.sys.BFoxDefaultAuthAgent;", false);
        }
        this.lex = Lexicon.make((Class)clazz);
    }

    public BFoxDefaultAuthAgent() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxDefaultAuthAgent;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxDefaultAuthAgent = BFoxDefaultAuthAgent.class("[Lcom.tridium.fox.sys.BFoxDefaultAuthAgent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FoxUserKeyFactory
    implements ScramSha256Server.IUserKeyFactory {
        private FoxSession session;

        public String getUserKey(String string) {
            BUserService bUserService = BFoxDefaultAuthAgent.this.authenticateAttempt(this.session, string);
            BUser bUser = bUserService.getUser(string);
            if (bUser == null || !bUserService.canLogin(bUser)) {
                BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = BPbkdf2HmacSha256PasswordEncoder.makeFake((String)string);
                return bPbkdf2HmacSha256PasswordEncoder.getValue();
            }
            BPbkdf2HmacSha256PasswordEncoder.makeFake((String)string);
            BPassword bPassword = bUser.getPassword();
            BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = (BPbkdf2HmacSha256PasswordEncoder)bPassword.getPasswordEncoder();
            return bPbkdf2HmacSha256PasswordEncoder.getValue();
        }

        public FoxUserKeyFactory(FoxSession foxSession) {
            this.session = foxSession;
        }
    }
}

