/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BIFoxAuthAgent;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.user.BUserServicePasswordConfiguration;
import com.tridium.util.ValueByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Random;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BICredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BAuthAgent;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BFoxAuthAgent
extends BAuthAgent
implements BIFoxAuthAgent {
    public static final Type TYPE;
    private static TypeInfo USER_SYNC_EXT_TYPE;
    private static int nonceCount;
    private static Random nonceRandom;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxAuthAgent;
    static /* synthetic */ Class class$com$tridium$user$BUserServicePasswordConfiguration;
    static /* synthetic */ Class class$com$tridium$user$BUserPasswordConfiguration;

    public Type getType() {
        return TYPE;
    }

    public boolean authenticate(FoxSession foxSession, FoxServer foxServer) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            switch (foxServer.getAuthenticationPolicy()) {
                case 0: {
                    bl = this.authenticateBasic(foxSession);
                    break;
                }
                case 1: {
                    bl = this.authenticateDigest(foxSession);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown authentication policy");
                }
            }
        }
        catch (Throwable throwable3) {
            bl = false;
            if (!bl2) {
                throwable = throwable3;
            }
            throwable2 = throwable3;
        }
        if (bl) {
            this.acceptAuthentication(foxSession);
        } else {
            this.rejectAuthentication(foxSession, throwable, throwable2);
        }
        return bl;
    }

    protected boolean authenticateBasic(FoxSession foxSession) throws Exception {
        throw new FoxAuthenticationException("unimplemented method authenticateBasic", foxSession);
    }

    protected boolean authenticateDigest(FoxSession foxSession) throws Exception {
        throw new FoxAuthenticationException("unimplemented method authenticateDigest", foxSession);
    }

    protected boolean authenticateTransactional(FoxSession foxSession) throws Exception {
        throw new FoxAuthenticationException("unimplemented method authenticateSpecialized", foxSession);
    }

    public byte[] generateNonce(FoxSession foxSession) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF("nonce");
        dataOutputStream.writeInt(nonceCount++);
        dataOutputStream.writeUTF(foxSession.getRemoteHost());
        dataOutputStream.writeInt(foxSession.getRemotePort());
        dataOutputStream.writeLong(System.currentTimeMillis());
        dataOutputStream.writeInt(nonceRandom.nextInt());
        return byteArrayOutputStream.toByteArray();
    }

    public void acceptAuthentication(FoxSession foxSession) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        boolean bl = false;
        try {
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser bUser = foxSession.getUser();
            if (bUserService.canUsePasswordFeatures(bUser)) {
                BObject[] bObjectArray;
                Class clazz = class$com$tridium$user$BUserServicePasswordConfiguration;
                if (clazz == null) {
                    clazz = class$com$tridium$user$BUserServicePasswordConfiguration = BFoxAuthAgent.class("[Lcom.tridium.user.BUserServicePasswordConfiguration;", false);
                }
                if ((bObjectArray = (BObject[])bUserService.getChildren(clazz)).length > 0 && bObjectArray[0].getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"baja:UserServicePasswordConfiguration"))) {
                    BObject[] bObjectArray2;
                    foxMessage.add("userHandle", bUser.getHandle().toString());
                    Class clazz2 = class$com$tridium$user$BUserPasswordConfiguration;
                    if (clazz2 == null) {
                        clazz2 = class$com$tridium$user$BUserPasswordConfiguration = BFoxAuthAgent.class("[Lcom.tridium.user.BUserPasswordConfiguration;", false);
                    }
                    if ((bObjectArray2 = (BObject[])bUser.getChildren(clazz2)).length > 0 && bObjectArray2[0].getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"baja:UserPasswordConfiguration"))) {
                        BBoolean bBoolean;
                        BAbsTime bAbsTime = (BAbsTime)((BUserPasswordConfiguration)bObjectArray2[0]).get("expiration");
                        BRelTime bRelTime = (BRelTime)((BUserServicePasswordConfiguration)bObjectArray[0]).get("warningPeriod");
                        if (!bAbsTime.isNull() && bAbsTime.subtract(bRelTime).isBefore(BAbsTime.now())) {
                            foxMessage.add("passwordExpires", bAbsTime.getMillis());
                        }
                        if ((bBoolean = (BBoolean)((BUserPasswordConfiguration)bObjectArray2[0]).get("forceResetAtNextLogin")).getBoolean()) {
                            if (USER_SYNC_EXT_TYPE == null) {
                                USER_SYNC_EXT_TYPE = BTypeSpec.make((String)"niagaraDriver", (String)"UserSyncExt").getTypeInfo();
                            }
                            Property property = bUser.getProperty("syncExt");
                            boolean bl2 = false;
                            if (bUser.getNetworkUser() && Flags.isReadonly((BComplex)bUser.getParent(), (Slot)bUser.getPropertyInParent()) && property != null && USER_SYNC_EXT_TYPE != null && property.getType().is(USER_SYNC_EXT_TYPE)) {
                                bl2 = true;
                            }
                            bl = bl2;
                            foxMessage.add("forceReset", true);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl && (foxSession.getRemoteHello().getString("station.name", null) == null || !foxSession.getRemoteHello().getString("app.name", "").equals("Station"))) {
            this.rejectAuthentication(foxSession, (Throwable)new LocalizableRuntimeException("fox", "fox.illegal.network.user.passwordReset"), null);
        } else {
            foxSession.setState("server.tune sendWelcome");
            foxSession.sendTuning("welcome", foxMessage);
            foxSession.setState("server.tune starting");
            foxSession.start();
        }
    }

    public void rejectAuthentication(FoxSession foxSession, Throwable throwable, Throwable throwable2) throws Exception {
        FoxMessage foxMessage = this.generateRejectedMessage(throwable, throwable2, foxSession.getSessionContext());
        foxSession.setState("server.tune sendRejected");
        foxSession.sendTuning("rejected", foxMessage);
        throw new FoxAuthenticationException("client login failed", foxSession);
    }

    protected FoxMessage generateRejectedMessage(Throwable throwable, Throwable throwable2, Context context) {
        FoxMessage foxMessage = new FoxMessage();
        if (throwable != null) {
            foxMessage.add("fatal", this.toFatalMessage(throwable, context));
            if (throwable instanceof FoxAuthenticationException) {
                foxMessage.add("data", ((FoxAuthenticationException)throwable).data);
            }
        }
        if (throwable2 != null) {
            foxMessage.add("msg", this.toFatalMessage(throwable2, context));
            if (throwable2 instanceof FoxAuthenticationException) {
                foxMessage.add("data", ((FoxAuthenticationException)throwable).data);
            }
        }
        return foxMessage;
    }

    public String toFatalMessage(Throwable throwable, Context context) {
        String string;
        if (throwable instanceof Localizable) {
            return ((Localizable)throwable).toString(context);
        }
        String string2 = throwable.getClass().getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        if ((string = throwable.getMessage()) != null && string.length() > 0) {
            string2 = string2 + ": " + string;
        }
        return string2;
    }

    protected BICredentials extractCredentials(FoxSession foxSession, FoxMessage foxMessage) throws Exception {
        byte[] byArray = foxMessage.getBlob("credentials", null);
        if (byArray != null) {
            foxSession.setState("server.tune receivedLogin data.len=" + byArray.length);
            BICredentials bICredentials = (BICredentials)ValueByteBuffer.unmarshal((byte[])byArray);
            return bICredentials;
        }
        return null;
    }

    protected BUserService authenticateAttempt(FoxSession foxSession, String string) {
        BFoxServerConnection bFoxServerConnection = (BFoxServerConnection)foxSession.conn();
        bFoxServerConnection.setLastLoginTime(Clock.time());
        if (string != null) {
            bFoxServerConnection.setLastLoginUsername(string);
        }
        bFoxServerConnection.setLastLoginAddress(foxSession.getRemoteHost() + ':' + foxSession.getRemotePort());
        bFoxServerConnection.setLastLoginApp(foxSession.getRemoteHello().getString("app.name", "") + ' ' + foxSession.getRemoteHello().getString("app.version", ""));
        return (BUserService)Sys.getService((Type)BUserService.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void authenticateSuccess(FoxSession foxSession, BUser bUser) {
        Object object = foxSession.getSessionStateLock();
        synchronized (object) {
            FoxMessage foxMessage = foxSession.getRemoteHello();
            String string = foxMessage.getString("lang", null);
            String string2 = foxMessage.getString("vmUuid", null);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("foxSessionId", BInteger.make((int)foxSession.getId()));
            if (string2 != null) {
                hashMap.put("foxRemoteVmUuid", BString.make((String)string2));
            }
            foxSession.setUser(bUser);
            foxSession.setSessionContext((Context)new BasicContext((Context)new BasicContext(bUser, string), BFacets.make(hashMap)));
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$fox$sys$BFoxAuthAgent;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxAuthAgent = BFoxAuthAgent.class("[Lcom.tridium.fox.sys.BFoxAuthAgent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        USER_SYNC_EXT_TYPE = null;
        nonceRandom = new Random();
    }
}

