/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.MismatchedStationNamesException;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.sys.license.Brand;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;

public class Acceptor {
    public static final Log log = Log.getLog((String)"fox");
    private static boolean licenseChecked = false;
    private static boolean foxTunnelingLicensed = false;

    public static void accept(FoxSession foxSession) {
        boolean bl;
        boolean bl2 = foxSession.isServer();
        boolean bl3 = false;
        if (foxSession.getRemoteHello().getString("station.name", null) != null || foxSession.getRemoteHello().getString("app.name", "").equals("Station")) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (Sys.getStation() != null) {
            bl5 = bl = true;
        }
        if (bl2) {
            if (bl4) {
                Acceptor.acceptStationIn(foxSession);
            } else {
                Acceptor.acceptWbIn(foxSession);
            }
        } else if (bl) {
            Acceptor.acceptStationOut(foxSession);
        } else {
            Acceptor.acceptWbOut(foxSession);
        }
    }

    static final void acceptTunnel(FoxConnection foxConnection) {
        Object object;
        int n = -1;
        if (foxConnection instanceof BObject && (object = ((BObject)foxConnection).fw(803, null, null, null, null)) instanceof Integer) {
            n = (Integer)object;
        }
        if (foxConnection.isTunnelServerConnection() && !Acceptor.foxTunnelingLicensed() && n == -1) {
            throw new LicenseException("Connection failure, fox tunneling is not licensed.");
        }
    }

    private static final void acceptStationIn(FoxSession foxSession) {
        log.trace("Accept.station.in: " + foxSession);
        String string = foxSession.getRemoteHello().getString("brandId", null);
        Brand.checkStationIn((String)string);
        BFoxConnection bFoxConnection = (BFoxConnection)foxSession.conn();
        NiagaraStation niagaraStation = bFoxConnection.getParentStation();
        if (niagaraStation != null && niagaraStation.isFatalFault()) {
            throw new LicenseException("Station in fatal fault: " + niagaraStation.getFaultCause());
        }
    }

    private static final void acceptStationOut(FoxSession foxSession) {
        String string;
        log.trace("Accept.station.out: " + foxSession);
        BFoxConnection bFoxConnection = (BFoxConnection)foxSession.conn();
        NiagaraStation niagaraStation = bFoxConnection.getParentStation();
        if (niagaraStation != null) {
            string = niagaraStation.getStationName();
            String string2 = foxSession.getRemoteHello().getString("station.name", null);
            if (string != null && string2 != null && !string.equals(string2)) {
                throw new MismatchedStationNamesException(string, string2);
            }
        }
        string = foxSession.getRemoteHello().getString("brandId", null);
        Brand.checkStationOut((String)string);
    }

    private static final void acceptWbIn(FoxSession foxSession) {
        log.trace("Accept.wb.in: " + foxSession);
        String string = foxSession.getRemoteHello().getString("brandId", null);
        Brand.checkWbIn((String)string);
    }

    private static final void acceptWbOut(FoxSession foxSession) {
        log.trace("Accept.wb.out: " + foxSession);
        String string = foxSession.getRemoteHello().getString("brandId", null);
        Brand.checkWbOut((String)string);
    }

    public static final boolean foxTunnelingLicensed() {
        block4: {
            if (!licenseChecked) {
                licenseChecked = true;
                try {
                    Feature feature = Sys.getLicenseManager().getFeature("tridium", "tunneling");
                    feature.check();
                    foxTunnelingLicensed = feature.getb("fox", false);
                }
                catch (Exception exception) {
                    foxTunnelingLicensed = false;
                    if (!Fox.tunnelingEnabled) break block4;
                    BFoxService.log.trace("Fox tunneling not licensed.");
                }
            }
        }
        if (!foxTunnelingLicensed) {
            Fox.tunnelingEnabled = false;
        }
        return foxTunnelingLicensed;
    }
}

