/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;

public class SessionReceiver
implements Runnable {
    FoxSession session;
    String name;
    volatile boolean isAlive;
    Thread thread;

    public SessionReceiver(FoxSession foxSession) {
        this.session = foxSession;
        this.name = "Fox:Receiver:" + foxSession.getId();
        this.isAlive = true;
    }

    public void start() {
        this.thread = this.session.conn.makeThread(Fox.threadGroup, this, this.name);
        this.thread.start();
    }

    public void kill() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void run() {
        while (this.isAlive && !this.session.isClosed()) {
            try {
                FoxFrame foxFrame = this.session.readFrame();
                if (this.session.isClosed()) break;
                if (foxFrame == null) continue;
                if (foxFrame.frameType == 115 || foxFrame.frameType == 97) {
                    this.session.requestReceived(foxFrame);
                    continue;
                }
                this.session.replyReceived(foxFrame);
            }
            catch (Throwable throwable) {
                if (this.isAlive) {
                    this.session.close(throwable);
                }
                return;
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

