/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.MulticastUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;
import javax.baja.sys.LocalizableRuntimeException;

public class MulticastServer
extends Thread {
    private FoxServer server;
    private boolean isAlive = true;
    private MulticastSocket socket;
    private Object rollcallLock = new Object();
    private Vector announcements;

    public MulticastServer(FoxServer foxServer) throws IOException {
        super(Fox.threadGroup, "Fox:MulticastServer");
        if (!Fox.multicastEnabled) {
            throw new LocalizableRuntimeException("fox", "error.multicastDisabled");
        }
        this.server = foxServer;
        this.socket = new MulticastSocket(1911);
        Throwable throwable = null;
        Throwable throwable2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (Fox.ipv4Enabled) {
            try {
                this.socket.joinGroup(InetAddress.getByName(Fox.MULTICAST_ADDRESS));
                bl = true;
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Could not join IPv4 multicast group: " + iOException);
                throwable = iOException;
                bl = false;
            }
        }
        if (Fox.ipv6Enabled) {
            try {
                this.socket.joinGroup(InetAddress.getByName(Fox.IPV6_MULTICAST_ADDRESS));
                bl2 = true;
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Could not join IPv6 multicast group: " + iOException);
                throwable2 = iOException;
                bl2 = false;
            }
        }
        if (!bl2 && !bl) {
            String string = Fox.ipv4Enabled && throwable != null ? throwable.getMessage() : null;
            String string2 = Fox.ipv6Enabled && throwable2 != null ? throwable2.getMessage() : null;
            String string3 = "OK";
            if (string != null) {
                string3 = string;
            }
            if (string2 != null) {
                string3 = string == null ? string2 : string3 + ", " + string2;
            }
            throw new IOException(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoxMessage[] rollcall(FoxMessage foxMessage, long l, RollcallCallback rollcallCallback) throws Exception {
        Object object = this.rollcallLock;
        synchronized (object) {
            Vector vector = this.announcements = new Vector();
            MulticastUtil.send("rollcall", foxMessage, 3);
            long l2 = l / 100L;
            for (int i = 0; i < 100; ++i) {
                Thread.sleep(l2);
                if (rollcallCallback == null) continue;
                rollcallCallback.completed(i);
            }
            this.announcements = null;
            Object[] objectArray = new FoxMessage[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public void sendAnnouncement() throws Exception {
        FoxMessage foxMessage;
        if (this.server != null && (foxMessage = this.server.getAnnouncement()) != null) {
            MulticastUtil.send("announcement", foxMessage, 3);
        }
    }

    private void receiveAnnouncement(FoxMessage foxMessage) {
        Vector vector = this.announcements;
        if (vector != null) {
            vector.addElement(foxMessage);
        }
    }

    public void kill() {
        this.isAlive = false;
        this.interrupt();
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public void run() {
        while (this.isAlive) {
            try {
                FoxFrame foxFrame = MulticastUtil.receive(this.socket);
                if (Fox.traceMulticast) {
                    System.out.println("-- Fox.multicast.recevied");
                    foxFrame.dump();
                }
                if (foxFrame.command == "rollcall") {
                    this.sendAnnouncement();
                    continue;
                }
                if (foxFrame.command != "announcement") continue;
                this.receiveAnnouncement(foxFrame.message);
            }
            catch (Throwable throwable) {
                if (!this.isAlive) continue;
                throwable.printStackTrace();
            }
        }
    }

    public static interface RollcallCallback {
        public void completed(int var1);
    }
}

