/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

public class IntMap {
    private Entry[] table = new Entry[31];
    private int count;
    private int threshold = (int)(31.0f * this.loadFactor);
    private float loadFactor = 75.0f;

    public int size() {
        return this.count;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        entry = new Entry();
        entry.hash = n;
        entry.value = object;
        entry.next = entryArray[n2];
        entryArray[n2] = entry;
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null && n < this.count) {
                objectArray[n++] = entry.value;
                entry = entry.next;
            }
        }
        return objectArray;
    }

    static class Entry {
        int hash;
        Object value;
        Entry next;

        Entry() {
        }
    }
}

