/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import java.io.IOException;
import java.io.OutputStream;

public class FoxFrame {
    public static final int SYNC = 115;
    public static final int ASYNC = 97;
    public static final int REPLY = 114;
    public static final int ERROR = 101;
    public static final int NULL = 110;
    public static final int KEEPALIVE = 107;
    public final int frameType;
    public final int sequenceNumber;
    public final int replyNumber;
    public final String channel;
    public final String command;
    public final FoxMessage message;
    FoxAsyncCallbacks callbacks;
    FoxFrame next;

    public FoxFrame(int n, int n2, int n3, String string, String string2, FoxMessage foxMessage) {
        this.frameType = n;
        this.sequenceNumber = n2;
        this.replyNumber = n3;
        this.channel = string;
        this.command = string2;
        this.message = foxMessage;
    }

    public final void write(MessageWriter messageWriter) throws IOException {
        this.writeHeader(messageWriter);
        this.message.writeValue(messageWriter);
        this.writeFooter(messageWriter);
    }

    private final void writeHeader(MessageWriter messageWriter) throws IOException {
        messageWriter.write(102).write(111).write(120).write(32).write(this.frameType).write(32).writeInt(this.sequenceNumber).write(32).writeInt(this.replyNumber).write(32).writeName(this.channel).write(32).writeName(this.command).write(10);
    }

    private final void writeFooter(MessageWriter messageWriter) throws IOException {
        messageWriter.write(59).write(59).write(10);
    }

    public static FoxFrame read(MessageReader messageReader) throws IOException {
        messageReader.consume("fox ");
        int n = messageReader.read();
        messageReader.consume(32);
        int n2 = messageReader.readInt();
        messageReader.consume(32);
        int n3 = messageReader.readInt();
        messageReader.consume(32);
        String string = messageReader.readName().intern();
        messageReader.consume(32);
        String string2 = messageReader.readName().intern();
        messageReader.consume(10);
        FoxMessage foxMessage = n == 97 || n == 115 ? new FoxRequest(string, string2) : (n == 114 ? new FoxResponse() : new FoxMessage());
        foxMessage.readValue(messageReader);
        messageReader.consume(59);
        messageReader.consume(59);
        messageReader.consume(10);
        return new FoxFrame(n, n2, n3, string, string2, foxMessage);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.frameType).append(' ').append(this.sequenceNumber).append(' ').append(this.replyNumber).append(' ').append(this.channel).append(' ').append(this.command);
        return stringBuffer.toString();
    }

    public void dump(OutputStream outputStream) {
        try {
            MessageWriter messageWriter = new MessageWriter(outputStream, true);
            this.write(messageWriter);
            messageWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.toString());
        }
    }

    public void dump() {
        this.dump(System.out);
    }
}

