/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.session.Tuner;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import javax.baja.security.BICredentials;

public class Fox {
    public static final int BASIC_AUTHENTICATION = 0;
    public static final int DIGEST_AUTHENTICATION = 1;
    public static final int TRANSACTIONAL_AUTHENTICATION = 2;
    public static String MULTICAST_ADDRESS = "224.0.1.84";
    public static String IPV6_MULTICAST_ADDRESS = "FF02::137";
    public static final int MULTICAST_PORT = 1911;
    public static final String UNKNOWN_STRING = "unknown";
    public static long sessionCloseTimeout = 10000L;
    public static boolean ipv4Enabled = true;
    public static boolean ipv6Enabled = false;
    public static boolean multicastEnabled = true;
    public static int requestTimeout = 60000;
    public static int keepAliveInterval = 5000;
    public static int soTimeout = 60000;
    public static boolean tcpNoDelay = true;
    public static boolean failsafeTimeouts = true;
    public static int maxServerSessions = 100;
    public static int maxQueueSize = 1000;
    public static int circuitChunkSize = 4096;
    public static int circuitMaxReceiveBuffer = 102400;
    public static int multicastTimeToLive = 4;
    public static boolean traceWriteFrame = false;
    public static boolean traceReadFrame = false;
    public static boolean traceSessionStates = false;
    public static boolean traceMulticast = false;
    public static boolean tunnelingEnabled = true;
    public static boolean onlyTunnelKnownStations = false;
    public static String appName = "unknown";
    public static String appVersion = "unknown";
    public static String vmName = System.getProperty("java.vm.name", "unknown");
    public static String vmVersion = System.getProperty("java.vm.version", "unknown");
    public static String osName = System.getProperty("os.name", "unknown");
    public static String osVersion = System.getProperty("os.version", "unknown");
    public static String hostAddress = "";
    public static String hostName;
    public static ExceptionTranslator exceptionTranslator;
    public static Clock clock;
    public static final ThreadGroup threadGroup;
    private static Vector sessions;
    private static int serverSessionCount;
    public static volatile int deadlocks;
    static /* synthetic */ Class class$com$tridium$fox$session$Fox;

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    private static int getInt(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    private static Object getInstance(String string, Object object) {
        try {
            String string2 = System.getProperty(string);
            if (string2 == null) {
                return object;
            }
            return (class$com$tridium$fox$session$Fox == null ? (class$com$tridium$fox$session$Fox = Fox.class$("com.tridium.fox.session.Fox")) : class$com$tridium$fox$session$Fox).getClassLoader().loadClass(string2).newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return object;
        }
    }

    public static FoxSession open(FoxConnection foxConnection, Socket socket, String string, String string2) throws Exception {
        return Fox.open(foxConnection, socket, string, string2, FoxSession.nullListeners);
    }

    public static FoxSession open(FoxConnection foxConnection, Socket socket, String string, String string2, FoxSession.IFoxSessionListener[] iFoxSessionListenerArray) throws Exception {
        return Tuner.openClient(foxConnection, socket, string, string2, iFoxSessionListenerArray);
    }

    public static FoxSession open(FoxConnection foxConnection, Socket socket, BICredentials bICredentials, FoxSession.IFoxSessionListener[] iFoxSessionListenerArray) throws Exception {
        return Tuner.openClient(foxConnection, socket, bICredentials, iFoxSessionListenerArray);
    }

    public static FoxSession getSession(int n) {
        for (int i = 0; i < sessions.size(); ++i) {
            FoxSession foxSession = (FoxSession)sessions.elementAt(i);
            if (foxSession.getId() != n) continue;
            return foxSession;
        }
        return null;
    }

    public static int getServerSessionCount() {
        return serverSessionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FoxSession[] getSessions() {
        Vector vector = sessions;
        synchronized (vector) {
            Object[] objectArray = new FoxSession[sessions.size()];
            sessions.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(FoxSession foxSession) {
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(foxSession);
            if (foxSession.isServer()) {
                ++serverSessionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(FoxSession foxSession) {
        Vector vector = sessions;
        synchronized (vector) {
            for (int i = 0; i < sessions.size(); ++i) {
                if (sessions.elementAt(i) != foxSession) continue;
                if (foxSession.isServer()) {
                    --serverSessionCount;
                }
                sessions.removeElementAt(i);
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        exceptionTranslator = new ExceptionTranslator();
        try {
            clock = new DefaultClock();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        threadGroup = new ThreadGroup(Nre.findMainThreadGroup((ThreadGroup)Thread.currentThread().getThreadGroup()), "fox");
        try {
            soTimeout = Fox.getInt("niagara.fox.soTimeout", soTimeout);
            tcpNoDelay = Fox.getBoolean("niagara.fox.tcpNoDelay", tcpNoDelay);
            keepAliveInterval = Fox.getInt("niagara.fox.keepAliveInterval", keepAliveInterval);
            requestTimeout = Fox.getInt("niagara.fox.requestTimeout", requestTimeout);
            maxServerSessions = Fox.getInt("niagara.fox.maxServerSessions", maxServerSessions);
            maxQueueSize = Fox.getInt("niagara.fox.maxQueueSize", maxQueueSize);
            circuitChunkSize = Fox.getInt("niagara.fox.circuitChunkSize", circuitChunkSize);
            circuitMaxReceiveBuffer = Fox.getInt("niagara.fox.circuitMaxReceiveBuffer", circuitMaxReceiveBuffer);
            failsafeTimeouts = Fox.getBoolean("niagara.fox.failsafeTimeouts", failsafeTimeouts);
            multicastTimeToLive = Fox.getInt("niagara.fox.multicastTimeToLive", multicastTimeToLive);
            exceptionTranslator = (ExceptionTranslator)Fox.getInstance("niagara.fox.exceptionTranslator", exceptionTranslator);
            traceWriteFrame = Fox.getBoolean("niagara.fox.traceWriteFrame", traceWriteFrame);
            traceReadFrame = Fox.getBoolean("niagara.fox.traceReadFrame", traceReadFrame);
            traceSessionStates = Fox.getBoolean("niagara.fox.traceSessionStates", traceSessionStates);
            traceMulticast = Fox.getBoolean("niagara.fox.traceMulticast", traceMulticast);
            tunnelingEnabled = Fox.getBoolean("niagara.fox.tunnelingEnabled", tunnelingEnabled);
            onlyTunnelKnownStations = Fox.getBoolean("niagara.fox.onlyTunnelKnownStations", onlyTunnelKnownStations);
            ipv6Enabled = Fox.getBoolean("niagara.ipv6Enabled", ipv6Enabled);
            multicastEnabled = Fox.getBoolean("niagara.fox.multicastEnabled", multicastEnabled);
            sessionCloseTimeout = Long.getLong("niagara.fox.sessionCloseTimeout", sessionCloseTimeout);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        FailsafeTimeoutThread failsafeTimeoutThread = new FailsafeTimeoutThread();
        failsafeTimeoutThread.setDaemon(true);
        failsafeTimeoutThread.start();
        sessions = new Vector();
        deadlocks = 0;
    }

    static class FailsafeTimeoutThread
    extends Thread {
        FailsafeTimeoutThread() {
            super(threadGroup, "Fox:FailsafeTimeout");
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(10000L);
                        if (!Fox.failsafeTimeouts) continue;
                        var1_1 = Fox.getSessions();
                        var2_3 = 0;
                        while (true) {
                            if (var2_3 < var1_1.length) ** break;
                            continue block3;
                            var3_4 = var1_1[var2_3];
                            var4_5 = Fox.clock.ticks() - var3_4.getLastReadTicks();
                            var6_6 = Fox.clock.ticks() - var3_4.getLastWriteTicks();
                            if (var4_5 > (long)Fox.soTimeout) {
                                var8_7 = new IOException("Failsafe timeout on read " + var4_5 + " > " + Fox.soTimeout);
                                System.out.println("ERROR: " + var8_7.getMessage());
                                var3_4.close(var8_7);
                            } else if (var6_6 > (long)Fox.soTimeout) {
                                var8_7 = new IOException("Failsafe timeout on write " + var6_6 + " > " + Fox.soTimeout);
                                System.out.println("ERROR: " + var8_7.getMessage());
                                var3_4.close(var8_7);
                            }
                            ++var2_3;
                        }
                        break;
                    }
                }
                catch (Exception var1_2) {
                    var1_2.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class DefaultClock
    extends Clock {
        private DefaultClock() {
        }

        public long ticks() {
            return javax.baja.sys.Clock.ticks();
        }
    }

    public static abstract class Clock {
        public abstract long ticks();
    }

    public static class ExceptionTranslator {
        public FoxMessage exceptionToMessage(Throwable throwable) {
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("exception", throwable.toString());
            return foxMessage;
        }

        public Exception messageToException(FoxMessage foxMessage) throws IOException {
            return new ServerException(foxMessage.getString("exception"));
        }
    }
}

