/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import java.io.IOException;
import java.io.OutputStream;

public class MessageWriter {
    public int indent = 0;
    public boolean isDebug;
    private OutputStream out;

    public MessageWriter(OutputStream outputStream, boolean bl) {
        this.out = outputStream;
        this.isDebug = bl;
    }

    public MessageWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    public final MessageWriter write(int n) throws IOException {
        this.out.write(n);
        return this;
    }

    public final MessageWriter write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isDebug) {
            this.writeDebug(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
        return this;
    }

    public final MessageWriter write(byte[] byArray) throws IOException {
        if (this.isDebug) {
            this.writeDebug(byArray, 0, byArray.length);
        } else {
            this.out.write(byArray, 0, byArray.length);
        }
        return this;
    }

    private void writeDebug(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, 30);
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i];
            if (n4 == 10) {
                this.write(92).write(110);
                continue;
            }
            if (n4 < 32 || n4 > 127) {
                n4 = 63;
            }
            this.write(n4);
        }
        if (n3 < n2) {
            this.write(46).write(46).write(46);
        }
    }

    public final void writeIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write(32);
        }
    }

    public final MessageWriter writeName(String string) throws IOException {
        try {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.out.write(string.charAt(i));
            }
        }
        catch (NullPointerException nullPointerException) {
            this.write(110).write(117).write(108).write(108);
        }
        return this;
    }

    public final MessageWriter writeInt(int n) throws IOException {
        return this.writeName(Integer.toString(n));
    }

    public final MessageWriter writeLong(long l) throws IOException {
        return this.writeName(Long.toString(l));
    }

    public final MessageWriter writeHex(int n) throws IOException {
        return this.writeName(Integer.toHexString(n));
    }

    public final MessageWriter writeHexLong(long l) throws IOException {
        return this.writeName(Long.toHexString(l));
    }

    public final MessageWriter writeSafe(String string) throws IOException {
        if (string == null) {
            this.writeName("#null;");
            return this;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f' || c == '#') {
                this.write(35).writeHex(c).write(59);
                continue;
            }
            this.write(c);
        }
        return this;
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    public final void close() throws IOException {
        this.out.close();
    }
}

