/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxFloat;
import com.tridium.fox.message.FoxInteger;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTime;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FoxTuple {
    public String name;

    public abstract int getType();

    public final void write(MessageWriter messageWriter) throws IOException {
        messageWriter.writeName(this.name).write(61).write(this.getType()).write(58);
        this.writeValue(messageWriter);
    }

    protected abstract void writeValue(MessageWriter var1) throws IOException;

    public static FoxTuple read(MessageReader messageReader) throws IOException {
        String string = messageReader.readName();
        messageReader.consume(61);
        int n = messageReader.read();
        FoxTuple foxTuple = null;
        switch (n) {
            case 98: {
                foxTuple = new FoxBlob();
                break;
            }
            case 102: {
                foxTuple = new FoxFloat();
                break;
            }
            case 105: {
                foxTuple = new FoxInteger();
                break;
            }
            case 109: {
                foxTuple = new FoxMessage();
                break;
            }
            case 111: {
                foxTuple = new FoxObject();
                break;
            }
            case 115: {
                foxTuple = new FoxString();
                break;
            }
            case 116: {
                foxTuple = new FoxTime();
                break;
            }
            case 122: {
                foxTuple = new FoxBoolean();
            }
        }
        messageReader.consume(58);
        foxTuple.name = string.intern();
        foxTuple.readValue(messageReader);
        messageReader.consume(10);
        return foxTuple;
    }

    protected void readValue(MessageReader messageReader) throws IOException {
        throw messageReader.error("not implemented");
    }

    public void dump(OutputStream outputStream) {
        try {
            MessageWriter messageWriter = new MessageWriter(outputStream, true);
            this.write(messageWriter);
            messageWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.toString());
        }
    }

    public void dump() {
        this.dump(System.out);
    }
}

