/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxFloat;
import com.tridium.fox.message.FoxInteger;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTime;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import java.io.IOException;
import java.util.Vector;

public class FoxMessage
extends FoxTuple {
    public static final FoxTuple[] noTuples = new FoxTuple[0];
    public FoxTuple[] tuples = noTuples;
    public int count;

    public FoxMessage(String string) {
        this.name = string;
    }

    public FoxMessage() {
    }

    public final int getType() {
        return 109;
    }

    public final void writeValue(MessageWriter messageWriter) throws IOException {
        boolean bl = messageWriter.isDebug;
        messageWriter.write(123).write(10);
        ++messageWriter.indent;
        for (int i = 0; i < this.count; ++i) {
            if (bl) {
                messageWriter.writeIndent();
            }
            this.tuples[i].write(messageWriter);
            messageWriter.write(10);
        }
        --messageWriter.indent;
        if (bl) {
            messageWriter.writeIndent();
        }
        messageWriter.write(125);
    }

    public void readValue(MessageReader messageReader) throws IOException {
        messageReader.consume(123);
        messageReader.consume(10);
        int n;
        while ((n = messageReader.read()) != 125) {
            messageReader.pushBack(n);
            this.add(FoxTuple.read(messageReader));
        }
        return;
    }

    public final FoxTuple get(String string) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            if (string != this.tuples[i].name) continue;
            return this.tuples[i];
        }
        throw new IOException("Missing key \"" + string + "\"");
    }

    public final FoxTuple[] list(String string) {
        Vector<FoxTuple> vector = new Vector<FoxTuple>();
        for (int i = 0; i < this.count; ++i) {
            if (string != this.tuples[i].name) continue;
            vector.addElement(this.tuples[i]);
        }
        Object[] objectArray = new FoxTuple[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final String[] listStrings(String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.count; ++i) {
            if (string != this.tuples[i].name) continue;
            vector.addElement(((FoxString)this.tuples[i]).value);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final FoxTuple getOptional(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (string != this.tuples[i].name) continue;
            return this.tuples[i];
        }
        return null;
    }

    public final FoxMessage getMessage(String string) throws IOException {
        return (FoxMessage)this.get(string);
    }

    public final boolean getBoolean(String string) throws IOException {
        return ((FoxBoolean)this.get((String)string)).value;
    }

    public final int getInt(String string) throws IOException {
        return ((FoxInteger)this.get((String)string)).value;
    }

    public final double getFloat(String string) throws IOException {
        return ((FoxFloat)this.get((String)string)).value;
    }

    public final String getString(String string) throws IOException {
        return ((FoxString)this.get((String)string)).value;
    }

    public final long getTime(String string) throws IOException {
        return ((FoxTime)this.get((String)string)).millis;
    }

    public final byte[] getBlob(String string) throws IOException {
        return ((FoxBlob)this.get((String)string)).data;
    }

    public final boolean getBoolean(String string, boolean bl) {
        FoxBoolean foxBoolean = (FoxBoolean)this.getOptional(string);
        if (foxBoolean == null) {
            return bl;
        }
        return foxBoolean.value;
    }

    public final int getInt(String string, int n) {
        FoxInteger foxInteger = (FoxInteger)this.getOptional(string);
        if (foxInteger == null) {
            return n;
        }
        return foxInteger.value;
    }

    public final double getFloat(String string, double d) {
        FoxFloat foxFloat = (FoxFloat)this.getOptional(string);
        if (foxFloat == null) {
            return d;
        }
        return foxFloat.value;
    }

    public final String getString(String string, String string2) {
        FoxString foxString = (FoxString)this.getOptional(string);
        if (foxString == null) {
            return string2;
        }
        return foxString.value;
    }

    public final long getTime(String string, long l) {
        FoxTime foxTime = (FoxTime)this.getOptional(string);
        if (foxTime == null) {
            return l;
        }
        return foxTime.millis;
    }

    public final byte[] getBlob(String string, byte[] byArray) {
        FoxBlob foxBlob = (FoxBlob)this.getOptional(string);
        if (foxBlob == null) {
            return byArray;
        }
        return foxBlob.data;
    }

    public final void add(FoxTuple foxTuple) {
        if (this.count >= this.tuples.length) {
            if (this.count == 0) {
                this.tuples = new FoxTuple[8];
            } else {
                FoxTuple[] foxTupleArray = new FoxTuple[this.count * 2];
                System.arraycopy(this.tuples, 0, foxTupleArray, 0, this.count);
                this.tuples = foxTupleArray;
            }
        }
        this.tuples[this.count++] = foxTuple;
    }

    public final void add(String string, boolean bl) {
        this.add(new FoxBoolean(string, bl));
    }

    public final void add(String string, int n) {
        this.add(new FoxInteger(string, n));
    }

    public final void add(String string, double d) {
        this.add(new FoxFloat(string, d));
    }

    public final void add(String string, String string2) {
        this.add(new FoxString(string, string2));
    }

    public final void add(String string, long l) {
        this.add(new FoxTime(string, l));
    }

    public final void add(String string, byte[] byArray) {
        this.add(new FoxBlob(string, byArray));
    }

    public final void add(String string, byte[] byArray, int n) {
        this.add(new FoxBlob(string, byArray, n));
    }

    public final void add(String string, byte[] byArray, int n, int n2) {
        this.add(new FoxBlob(string, byArray, n, n2));
    }

    public final void add(String string, String string2, byte[] byArray, int n) {
        this.add(new FoxObject(string, string2, byArray, n));
    }

    public final FoxMessage add(String string, FoxMessage foxMessage) {
        foxMessage.name = string;
        this.add(foxMessage);
        return foxMessage;
    }
}

