/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import java.io.IOException;

public final class FoxFloat
extends FoxTuple {
    public double value;

    public FoxFloat(String string, double d) {
        this.name = string;
        this.value = d;
    }

    public FoxFloat() {
    }

    public final int getType() {
        return 102;
    }

    protected final void writeValue(MessageWriter messageWriter) throws IOException {
        if (Double.isNaN(this.value)) {
            messageWriter.writeSafe("nan");
        } else if (this.value == Double.POSITIVE_INFINITY) {
            messageWriter.writeSafe("+inf");
        } else if (this.value == Double.NEGATIVE_INFINITY) {
            messageWriter.writeSafe("-inf");
        } else {
            messageWriter.writeSafe(String.valueOf(this.value));
        }
    }

    protected void readValue(MessageReader messageReader) throws IOException {
        String string = messageReader.readSafe();
        this.value = string.equals("nan") ? Double.NaN : (string.equals("+inf") ? Double.POSITIVE_INFINITY : (string.equals("-inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(string)));
    }
}

