/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.kerberos;

import com.sun.security.jgss.GSSUtil;
import com.tridium.fox.kerberos.GSSDelegCredAction;
import com.tridium.fox.kerberos.KerberosCallbackHandler;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import javax.baja.log.Log;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosAuthenticator {
    private static final String KERB_AUTH_STARTED = "fox.kerberos.authStarted";
    private static final String KERB_USER_KERB = "fox.kerberos.user.kerberos";
    private static final String KERB_USER_LOCAL = "fox.kerberos.user.local";
    private static final String KERB_LOGIN = "fox.kerberos.login";
    private static final String KERB_LOGIN_FAILED = "fox.kerberos.loginFailed";
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$fox$kerberos$KerberosAuthenticator == null ? (class$com$tridium$fox$kerberos$KerberosAuthenticator = KerberosAuthenticator.class$("com.tridium.fox.kerberos.KerberosAuthenticator")) : class$com$tridium$fox$kerberos$KerberosAuthenticator));
    static final Log log = Log.getLog((String)"fox.kerberos");
    static /* synthetic */ Class class$com$tridium$fox$kerberos$KerberosAuthenticator;

    public static void authenticate(FoxSession foxSession, FoxMessage foxMessage, BICredentials bICredentials) throws Exception {
        Object object;
        log.trace(lex.getText(KERB_AUTH_STARTED));
        boolean bl = false;
        String string = "";
        String string2 = "";
        if (bICredentials instanceof BUsernameAndPassword) {
            object = (BUsernameAndPassword)bICredentials;
            string = object.getUsername();
            if (string.startsWith("kerberos:")) {
                bl = true;
                string = string.substring(string.indexOf(":") + 1);
            }
            string2 = object.getPassword().getValue();
        } else if (bICredentials instanceof BKerberosCredentials) {
            bl = true;
        } else {
            throw new IllegalStateException();
        }
        object = new FoxMessage();
        String string3 = bl ? "authInputKerb" : "authInputLocal";
        ((FoxMessage)object).add("authInput", string3);
        foxSession.setState("client.tune send firstMessage: userType=" + string3);
        foxSession.sendTuning("authMessage1", (FoxMessage)object);
        if (bl) {
            log.trace(lex.getText(KERB_USER_KERB, new Object[]{string}));
            String string4 = foxMessage.getString("realm");
            String string5 = foxMessage.getString("kdc");
            String string6 = foxMessage.getString("server") + "@" + string4;
            System.setProperty("java.security.krb5.realm", string4);
            System.setProperty("java.security.krb5.kdc", string5);
            if (bICredentials instanceof BKerberosCredentials) {
                BKerberosCredentials bKerberosCredentials = (BKerberosCredentials)bICredentials;
                Subject subject = GSSUtil.createSubject(bKerberosCredentials.getCredential().getName(), bKerberosCredentials.getCredential());
                Subject.doAs(subject, new GSSDelegCredAction(string6, foxSession));
                bKerberosCredentials.destroyTicket();
            } else {
                try {
                    string = string + "@" + string4;
                    LoginContext loginContext = KerberosAuthenticator.kerberosClientLogin(string, string2, foxSession);
                    Subject.doAs(loginContext.getSubject(), new GSSDelegCredAction(string6, foxSession));
                    loginContext.logout();
                }
                catch (LoginException loginException) {
                    FoxMessage foxMessage2 = new FoxMessage();
                    byte[] byArray = new byte[]{};
                    foxMessage2.add("token", byArray);
                    foxSession.setState("client.tune sendLogin");
                    foxSession.sendTuning("clientToken", foxMessage2);
                }
            }
        } else {
            log.trace(lex.getText(KERB_USER_LOCAL, new Object[]{string}));
            FoxMessage foxMessage3 = new FoxMessage();
            foxMessage3.add("username", string);
            foxMessage3.add("password", string2);
            foxSession.setState("client.tune sendLogin");
            foxSession.sendTuning("login", foxMessage3);
        }
    }

    private static LoginContext kerberosClientLogin(String string, String string2, FoxSession foxSession) throws LoginException {
        log.trace(lex.getText(KERB_LOGIN));
        KerberosConfig kerberosConfig = new KerberosConfig(string);
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext("com.tridium.fox.session.KerberosAuthenticator", null, new KerberosCallbackHandler(string, string2), kerberosConfig);
            loginContext.login();
        }
        catch (LoginException loginException) {
            log.error(lex.getText(KERB_LOGIN_FAILED));
            throw loginException;
        }
        return loginContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

