/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.kerberos;

import com.tridium.fox.kerberos.KerberosAuthenticator;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import java.security.PrivilegedAction;
import javax.baja.util.Lexicon;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSDelegCredAction
implements PrivilegedAction {
    private static final String KERB_DELEG_CRED = "fox.kerberos.gss.delegating";
    private static final String KERB_NO_TOKEN = "fox.kerberos.gss.noToken";
    private static final String KERB_CTX_ESTABLISHED = "fox.kerberos.gss.contextEstablished";
    private static final String KERB_ERR_NO_DELEG = "fox.kerberos.gss.couldNotDelegate";
    String serverPrincipal;
    FoxSession session;
    static /* synthetic */ Class class$com$tridium$fox$kerberos$GSSDelegCredAction;

    public GSSDelegCredAction(String string, FoxSession foxSession) {
        this.serverPrincipal = string;
        this.session = foxSession;
    }

    public Object run() {
        Lexicon lexicon = Lexicon.make((Class)(class$com$tridium$fox$kerberos$GSSDelegCredAction == null ? (class$com$tridium$fox$kerberos$GSSDelegCredAction = GSSDelegCredAction.class$("com.tridium.fox.kerberos.GSSDelegCredAction")) : class$com$tridium$fox$kerberos$GSSDelegCredAction));
        KerberosAuthenticator.log.trace(lexicon.getText(KERB_DELEG_CRED));
        try {
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(this.serverPrincipal, null);
            gSSName = gSSName.canonicalize(oid);
            GSSContext gSSContext = gSSManager.createContext(gSSName, oid, null, 0);
            gSSContext.requestCredDeleg(true);
            gSSContext.requestMutualAuth(true);
            byte[] byArray = new byte[]{};
            while (!gSSContext.isEstablished()) {
                FoxMessage foxMessage;
                if ((byArray = gSSContext.initSecContext(byArray, 0, byArray.length)) != null) {
                    foxMessage = new FoxMessage();
                    foxMessage.add("token", byArray);
                    this.session.setState("client.tune sendToken ");
                    this.session.sendTuning("clientToken", foxMessage);
                }
                if (gSSContext.isEstablished()) continue;
                this.session.setState("client.tune receiveToken");
                foxMessage = this.session.receiveTuning("serverToken");
                byArray = foxMessage.getBlob("token", null);
                if (byArray != null) continue;
                KerberosAuthenticator.log.warning(lexicon.getText(KERB_NO_TOKEN));
                return null;
            }
            KerberosAuthenticator.log.trace(lexicon.getText(KERB_CTX_ESTABLISHED, new Object[]{gSSContext.getSrcName(), gSSContext.getTargName()}));
        }
        catch (Exception exception) {
            KerberosAuthenticator.log.error(lexicon.getText(KERB_ERR_NO_DELEG, new Object[]{exception.toString()}));
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

