/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.encoding;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import java.io.IOException;
import java.util.HashMap;

public class DecoderFactory {
    private static final HashMap providers = new HashMap();

    public static Object decode(FoxMessage foxMessage, String string, Object object) throws Exception {
        FoxObject foxObject = (FoxObject)foxMessage.get(string);
        return DecoderFactory.decode(foxObject.encoding, foxObject.data, object);
    }

    public static Object decode(FoxObject foxObject, Object object) throws Exception {
        return DecoderFactory.decode(foxObject.encoding, foxObject.data, object);
    }

    public static Object decode(String string, byte[] byArray, Object object) throws Exception {
        Provider provider = (Provider)providers.get(string);
        if (provider != null) {
            return provider.decode(byArray, object);
        }
        throw new IOException("Unknown object encoding: " + string);
    }

    public static void register(String string, Provider provider) {
        providers.put(string, provider);
    }

    public static void unregister(String string) {
        providers.remove(string);
    }

    static {
        DecoderFactory.register("bog", new BogCodec.Provider());
    }

    public static interface Provider {
        public Object decode(byte[] var1, Object var2) throws Exception;
    }
}

