/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.encoding;

import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.io.ByteBuffer;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.xml.XException;
import javax.baja.xml.XWriter;

public final class BogCodec {
    public static void add(FoxMessage foxMessage, String string, BValue bValue, Context context) throws IOException {
        ByteBuffer byteBuffer = BogCodec.encode(bValue, context);
        foxMessage.add(string, "bog", byteBuffer.getBytes(), byteBuffer.getLength());
    }

    public static ByteBuffer encode(BValue bValue, Context context) throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer(1024);
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(byteBuffer.getOutputStream());
        XWriter xWriter = ((ValueDocEncoder.BogEncoderPlugin)valueDocEncoder.getPlugin()).getWriter();
        xWriter.w((Object)"<bog version=\"1.0\"");
        if (bValue != null) {
            xWriter.w((Object)">\n");
            valueDocEncoder.setEncodeTransients(true);
            valueDocEncoder.setEncodeComments(false);
            valueDocEncoder.encode(bValue);
            xWriter.w((Object)"</bog>\n");
        } else {
            xWriter.w((Object)"/>\n");
        }
        valueDocEncoder.close();
        return byteBuffer;
    }

    static class Provider
    implements DecoderFactory.Provider {
        Provider() {
        }

        public Object decode(byte[] byArray, Object object) throws Exception {
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder((InputStream)new ByteArrayInputStream(byArray));
            valueDocDecoder.next();
            if (!valueDocDecoder.elem().name().equals("bog")) {
                throw new XException("Expected <bog>, not " + valueDocDecoder.elem(), ((ValueDocDecoder.BogDecoderPlugin)valueDocDecoder.getPlugin()).getXmlParser());
            }
            valueDocDecoder.next();
            if (valueDocDecoder.type() == 2) {
                return null;
            }
            return valueDocDecoder.decode();
        }
    }
}

