/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.flexSerial.BFlexSerialDevice;
import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.BFlexMessageBlock;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import com.tridium.flexSerial.messages.BFlexRequestResponse;
import com.tridium.flexSerial.messages.BFlexResponseMessage;
import com.tridium.flexSerial.point.BFlexPointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFlexProxyExt
extends BBasicProxyExt
implements BIBasicPollable {
    public static final Property pollFrequency = BFlexProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property address = BFlexProxyExt.newProperty((int)0, (String)"", null);
    public static final Property address1 = BFlexProxyExt.newProperty((int)0, (String)"", null);
    public static final Property address2 = BFlexProxyExt.newProperty((int)0, (String)"", null);
    public static final Property pollMessage = BFlexProxyExt.newProperty((int)0, (BValue)new BFlexRequestResponse(), null);
    public static final Property writeMessage = BFlexProxyExt.newProperty((int)0, (BValue)new BFlexRequestResponse(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$flexSerial$point$BFlexProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public String getAddress1() {
        return this.getString(address1);
    }

    public void setAddress1(String string) {
        this.setString(address1, string, null);
    }

    public String getAddress2() {
        return this.getString(address2);
    }

    public void setAddress2(String string) {
        this.setString(address2, string, null);
    }

    public BFlexRequestResponse getPollMessage() {
        return (BFlexRequestResponse)this.get(pollMessage);
    }

    public void setPollMessage(BFlexRequestResponse bFlexRequestResponse) {
        this.set(pollMessage, (BValue)bFlexRequestResponse, null);
    }

    public BFlexRequestResponse getWriteMessage() {
        return (BFlexRequestResponse)this.get(writeMessage);
    }

    public void setWriteMessage(BFlexRequestResponse bFlexRequestResponse) {
        this.set(writeMessage, (BValue)bFlexRequestResponse, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BFlexSerialNetwork getFlexNetwork() {
        return (BFlexSerialNetwork)this.getNetwork();
    }

    public final BFlexSerialDevice getFlexDevice() {
        return (BFlexSerialDevice)this.getDevice();
    }

    public final String getFlexDeviceAddress() {
        return ((BFlexSerialDevice)this.getDevice()).getAddress();
    }

    public final BFlexPointDeviceExt getFlexPointDeviceExt() {
        return (BFlexPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BFlexPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParentPoint().isWritablePoint()) {
            return this.getPollMessage().isRequestDefined() ? BReadWriteMode.readWrite : BReadWriteMode.writeonly;
        }
        return BReadWriteMode.readonly;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)readValue) || slot.equals((Object)writeValue)) {
            return this.getPointFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void poll() {
        if (this.isUnoperational()) {
            return;
        }
        BFlexSerialNetwork bFlexSerialNetwork = (BFlexSerialNetwork)this.getNetwork();
        if (bFlexSerialNetwork.getLog().isTraceOn()) {
            bFlexSerialNetwork.getLog().trace((Object)((Object)this) + ".poll()");
        }
        this.pollForData();
        bFlexSerialNetwork = null;
    }

    private final void pollForData() {
        block9: {
            if (this.getMode().equals((Object)BReadWriteMode.writeonly)) {
                this.readOk(this.getWriteValue());
                return;
            }
            BFlexRequestResponse bFlexRequestResponse = this.getPollMessage();
            String string = bFlexRequestResponse.sendMessage(null);
            if (string.equalsIgnoreCase("OK")) {
                try {
                    if (!this.getPollMessage().isResponseDefined()) {
                        this.readFail("poll response message not defined!");
                        return;
                    }
                    BStatusValue bStatusValue = this.decodeResponseStatusValue(bFlexRequestResponse.getResponse());
                    if (bStatusValue != null) {
                        this.readOk(bStatusValue);
                        this.getDevice().pingOk();
                        break block9;
                    }
                    this.readFail("unable to convert response");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.readFail(exception.toString());
                }
            } else if (string.equals("response timeout")) {
                this.getDevice().pingFail(string);
            } else {
                this.readFail(string);
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        block8: {
            if (this.isUnoperational()) {
                return;
            }
            try {
                BFlexRequestResponse bFlexRequestResponse = this.getWriteMessage();
                String string = bFlexRequestResponse.sendMessage(null);
                if (string.equalsIgnoreCase("OK")) {
                    if (!this.getWriteMessage().isResponseDefined()) {
                        this.writeOk(bStatusValue);
                        return;
                    }
                    try {
                        BStatusValue bStatusValue2 = this.decodeResponseStatusValue(bFlexRequestResponse.getResponse());
                        if (bStatusValue2 != null) {
                            this.writeOk(bStatusValue2);
                            break block8;
                        }
                        this.writeOk(bStatusValue);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.writeFail(exception.toString());
                    }
                    break block8;
                }
                this.writeFail(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.writeFail(exception.toString());
            }
        }
    }

    private final BStatusValue decodeResponseStatusValue(BFlexResponseMessage bFlexResponseMessage) {
        BStatusNumeric bStatusNumeric = null;
        try {
            BFlexMessageElement bFlexMessageElement;
            BFlexMessageBlock bFlexMessageBlock = (BFlexMessageBlock)bFlexResponseMessage.get("instance");
            if (bFlexMessageBlock == null) {
                bFlexResponseMessage.doCreateInstance();
                bFlexMessageBlock = (BFlexMessageBlock)bFlexResponseMessage.get("instance");
            }
            if ((bFlexMessageElement = bFlexMessageBlock.getMessageElement(bFlexResponseMessage.getElementSelect().getElementSelect())) == null) {
                return null;
            }
            if (this.isNumeric()) {
                bStatusNumeric = new BStatusNumeric(bFlexMessageElement.getDoubleValue());
            } else if (this.isBoolean()) {
                bStatusNumeric = new BStatusBoolean(bFlexMessageElement.getBooleanValue());
            } else if (this.isString()) {
                bStatusNumeric = new BStatusString(bFlexMessageElement.getStringValue());
            } else if (this.isEnum()) {
                bStatusNumeric = new BStatusEnum(bFlexMessageElement.getEnumValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bStatusNumeric;
    }

    protected boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    protected boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    protected boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    protected boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$flexSerial$point$BFlexProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$flexSerial$point$BFlexProxyExt = BFlexProxyExt.class("[Lcom.tridium.flexSerial.point.BFlexProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

