/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import java.io.ByteArrayOutputStream;
import javax.baja.sys.BFacets;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FlexOutputStream
extends ByteArrayOutputStream {
    int cksumStart;

    public void write(int n, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        switch (bEncodeTypeEnum.getOrdinal()) {
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("000");
                stringBuffer.append(Integer.toString(n & 0xFF, 16));
                String string = stringBuffer.toString().toUpperCase();
                this.write((byte)string.charAt(string.length() - 2));
                this.write((byte)string.charAt(string.length() - 1));
                break;
            }
            default: {
                super.write(n);
            }
        }
    }

    public void writeInt(int n, int n2, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        boolean bl = BFlexMessageElement.isBigEndian(bFacets);
        if (bl) {
            this.writeBigEndianInt(n, n2, bEncodeTypeEnum, bFacets);
        } else {
            this.writeLittleEndianInt(n, n2, bEncodeTypeEnum, bFacets);
        }
    }

    public void writeBigEndianInt(int n, int n2, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        byte[] byArray = new byte[n2];
        switch (n2) {
            case 4: {
                byArray[0] = (byte)(n >> 24 & 0xFF);
                byArray[1] = (byte)(n >> 16 & 0xFF);
                byArray[2] = (byte)(n >> 8 & 0xFF);
                byArray[3] = (byte)(n & 0xFF);
                break;
            }
            case 3: {
                byArray[0] = (byte)(n >> 16 & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
                byArray[2] = (byte)(n & 0xFF);
                break;
            }
            case 2: {
                byArray[0] = (byte)(n >> 8 & 0xFF);
                byArray[1] = (byte)(n & 0xFF);
                break;
            }
            default: {
                byArray[0] = (byte)(n & 0xFF);
            }
        }
        switch (bEncodeTypeEnum.getOrdinal()) {
            case 2: {
                byte[] byArray2 = this.toAsciiHexByteArray(byArray);
                this.write(byArray2, 0, byArray2.length);
                break;
            }
            default: {
                this.write(byArray, 0, byArray.length);
            }
        }
    }

    public void writeLittleEndianInt(int n, int n2, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        byte[] byArray = new byte[n2];
        switch (n2) {
            case 4: {
                byArray[0] = (byte)(n & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
                byArray[2] = (byte)(n >> 16 & 0xFF);
                byArray[3] = (byte)(n >> 24 & 0xFF);
                break;
            }
            case 3: {
                byArray[0] = (byte)(n & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
                byArray[2] = (byte)(n >> 16 & 0xFF);
                break;
            }
            case 2: {
                byArray[0] = (byte)(n & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
                break;
            }
            default: {
                byArray[0] = (byte)(n & 0xFF);
            }
        }
        switch (bEncodeTypeEnum.getOrdinal()) {
            case 2: {
                byte[] byArray2 = this.toAsciiHexByteArray(byArray);
                this.write(byArray2, 0, byArray2.length);
                break;
            }
            default: {
                this.write(byArray, 0, byArray.length);
            }
        }
    }

    public void writeString(String string, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        try {
            this.write(string.getBytes());
        }
        catch (Exception exception) {}
        if (bFacets.getb(BFlexMessageElement.NULL_TERMINATE, false)) {
            this.write(0);
        }
    }

    public byte[] toAsciiHexByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] >= 0 && byArray[n] < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        String string = stringBuffer.toString().toUpperCase();
        byte[] byArray2 = new byte[string.length()];
        string.getBytes(0, stringBuffer.length(), byArray2, 0);
        return byArray2;
    }

    public void setCksumStart(int n) {
        this.cksumStart = n;
    }

    public int getCksumStart() {
        return this.cksumStart;
    }

    private final /* synthetic */ void this() {
        this.cksumStart = 0;
    }

    public FlexOutputStream() {
        this.this();
    }

    public FlexOutputStream(int n) {
        super(n);
        this.this();
    }
}

