/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import java.io.ByteArrayInputStream;
import javax.baja.sys.BFacets;

public class FlexInputStream
extends ByteArrayInputStream {
    public int read(BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.AsciiHex)) {
            return this.readHexByte();
        }
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.Ascii)) {
            return this.readStringInt(bEncodeTypeEnum, bFacets);
        }
        return this.read();
    }

    public int readInt(int n, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        boolean bl;
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.Ascii)) {
            return this.readStringInt(bEncodeTypeEnum, bFacets);
        }
        if (n > 4 || n < 1) {
            System.out.println("\n**************************************************");
            System.out.println("         Invalid int size: " + n);
            System.out.println("**************************************************\n");
            if (n > 4) {
                n = 4;
            }
            if (n < 1) {
                n = 1;
            }
        }
        if (bl = BFlexMessageElement.isBigEndian(bFacets)) {
            return this.readBigEndianInt(n, bEncodeTypeEnum, bFacets);
        }
        return this.readLittleEndianInt(n, bEncodeTypeEnum, bFacets);
    }

    private final int readBigEndianInt(int n, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 24;
            }
            case 3: {
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 16;
            }
            case 2: {
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 8;
            }
            case 1: {
                n2 |= this.read(bEncodeTypeEnum, bFacets);
            }
        }
        return n2;
    }

    private final int readLittleEndianInt(int n, BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 |= this.read(bEncodeTypeEnum, bFacets);
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 8;
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 16;
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 24;
                break;
            }
            case 3: {
                n2 |= this.read(bEncodeTypeEnum, bFacets);
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 8;
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 16;
                break;
            }
            case 2: {
                n2 |= this.read(bEncodeTypeEnum, bFacets);
                n2 |= this.read(bEncodeTypeEnum, bFacets) << 8;
                break;
            }
            case 1: {
                n2 |= this.read(bEncodeTypeEnum, bFacets);
            }
        }
        return n2;
    }

    public float readFloat(BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.Ascii)) {
            String string = this.readString(bEncodeTypeEnum, bFacets);
            try {
                return Float.parseFloat(string.trim());
            }
            catch (Exception exception) {
                return Float.NaN;
            }
        }
        try {
            return Float.intBitsToFloat(this.readInt(4, bEncodeTypeEnum, bFacets));
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    public int readWord(BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        boolean bl = BFlexMessageElement.isBigEndian(bFacets);
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.AsciiHex)) {
            return this.readHexWord(bl);
        }
        if (bEncodeTypeEnum.equals((Object)BEncodeTypeEnum.Ascii)) {
            String string = this.readString(bEncodeTypeEnum, bFacets);
            try {
                return Integer.parseInt(string.trim());
            }
            catch (Exception exception) {
                return -1;
            }
        }
        int n = this.read() & 0xFF;
        if (bl) {
            return n << 8 | this.read() & 0xFF;
        }
        return (this.read() & 0xFF) << 8 | n;
    }

    public int readHexWord(boolean bl) {
        if (bl) {
            return this.readHexByte() << 8 | this.readHexByte();
        }
        return this.readHexByte() | this.readHexByte() << 8;
    }

    public int readHexByte() {
        int n = this.readDigit();
        n = n << 4 | this.readDigit();
        return n;
    }

    public int readDigit() {
        return Character.digit((char)(this.read() & 0xFF), 16) & 0xF;
    }

    private final int readStringInt(BEncodeTypeEnum bEncodeTypeEnum, BFacets bFacets) {
        String string = this.readString(bEncodeTypeEnum, bFacets);
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String readString(BEncodeTypeEnum var1_1, BFacets var2_2) {
        block8: {
            block9: {
                var3_3 = var2_2.gets("endDelimiter", "");
                var4_4 = var2_2.geti("fieldWidth", -1);
                var5_5 = var2_2.getb("nullTerminate", false);
                var6_6 = new StringBuffer();
                var7_7 = false;
                if (var3_3.length() <= 0) break block9;
                while (!var7_7) {
                    var8_8 = this.read();
                    if (var8_8 < 0) {
                        var7_7 = true;
                        continue;
                    }
                    if (var8_8 == var3_3.charAt(0)) {
                        var7_7 = true;
                        continue;
                    }
                    var6_6.append((char)var8_8);
                }
                break block8;
            }
            if (var4_4 <= 0) ** GOTO lbl40
            var8_9 = 0;
            while (var8_9 < var4_4) {
                var9_11 = this.read();
                if (var9_11 >= 0) {
                    var6_6.append((char)var9_11);
                    ++var8_9;
                    continue;
                }
                break block8;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                var8_10 = this.read();
                if (var8_10 < 0) {
                    var7_7 = true;
                    continue;
                }
                if (var8_10 == 0) {
                    var7_7 = true;
                    continue;
                }
                var6_6.append((char)var8_10);
lbl40:
                // 4 sources

                ** while (!var7_7)
            }
        }
        return var6_6.toString();
    }

    public FlexInputStream(byte[] byArray) {
        super(byArray);
    }

    public FlexInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }
}

