/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BDataTypeEnum;
import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageSelect;
import com.tridium.flexSerial.messages.BIFlexMessageBlock;
import com.tridium.flexSerial.messages.BIFlexMessageElement;
import com.tridium.flexSerial.messages.FlexInputStream;
import com.tridium.flexSerial.messages.FlexOutputStream;
import com.tridium.program.BProgram;
import java.text.DecimalFormat;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BFlexMessageElement
extends BComponent
implements BIFlexMessageElement {
    public static final Property offset = BFlexMessageElement.newProperty((int)1, (int)0, null);
    public static final Property size = BFlexMessageElement.newProperty((int)1, (int)1, null);
    public static final Property dataType = BFlexMessageElement.newProperty((int)0, (BValue)BDataTypeEnum.Byte, null);
    public static final Property source = BFlexMessageElement.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property exposeInParent = BFlexMessageElement.newProperty((int)0, (boolean)false, null);
    public static final Property value = BFlexMessageElement.newProperty((int)0, (BValue)BInteger.make((int)0), null);
    public static final Property encode = BFlexMessageElement.newProperty((int)0, (BValue)BEncodeTypeEnum.None, null);
    public static final Property facets = BFlexMessageElement.newProperty((int)0, (BValue)BFacets.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"flexSerial:FlexFacetsFE")));
    public static final Type TYPE;
    private static final BIcon icon;
    public static String BIG_ENDIAN;
    public static String ACTIVE_VALUE;
    public static String INACTIVE_VALUE;
    public static String ACTIVE_TEXT;
    public static String INACTIVE_TEXT;
    public static String PAD_WITH;
    public static String NULL_TERMINATE;
    public static String DECIMAL_FORMAT;
    public static String FIELD_WIDTH;
    public static String MAX;
    public static String MIN;
    public static String SHOW_ASCII;
    public static String CKSUM_START_MARKER_NAME;
    static /* synthetic */ Class class$com$tridium$flexSerial$messages$BFlexMessageElement;

    public int getOffset() {
        return this.getInt(offset);
    }

    public void setOffset(int n) {
        this.setInt(offset, n, null);
    }

    public int getSize() {
        return this.getInt(size);
    }

    public void setSize(int n) {
        this.setInt(size, n, null);
    }

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum bDataTypeEnum) {
        this.set(dataType, (BValue)bDataTypeEnum, null);
    }

    public BOrd getSource() {
        return (BOrd)this.get(source);
    }

    public void setSource(BOrd bOrd) {
        this.set(source, (BValue)bOrd, null);
    }

    public boolean getExposeInParent() {
        return this.getBoolean(exposeInParent);
    }

    public void setExposeInParent(boolean bl) {
        this.setBoolean(exposeInParent, bl, null);
    }

    public BValue getValue() {
        return this.get(value);
    }

    public void setValue(BValue bValue) {
        this.set(value, bValue, null);
    }

    public BEncodeTypeEnum getEncode() {
        return (BEncodeTypeEnum)this.get(encode);
    }

    public void setEncode(BEncodeTypeEnum bEncodeTypeEnum) {
        this.set(encode, (BValue)bEncodeTypeEnum, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)value)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals((Object)value)) {
                this.exposeInParent();
            }
            if (context != null && context.equals(Context.decoding)) {
                this.exposeInParent();
                return;
            }
        }
        if (property.equals((Object)dataType) || property.equals((Object)source)) {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(1);
                    break;
                }
                case 1: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(2);
                    break;
                }
                case 2: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(4);
                    break;
                }
                case 3: {
                    this.setValue((BValue)BFloat.make((float)0.0f));
                    this.setSize(4);
                    break;
                }
                case 4: {
                    this.setValue((BValue)BString.make((String)""));
                    break;
                }
                case 5: {
                    this.setValue((BValue)BString.make((String)""));
                    this.setSize(0);
                    break;
                }
            }
        } else if ((property.equals((Object)value) || property.equals((Object)facets)) && this.getDataType().equals((Object)BDataTypeEnum.String)) {
            this.setSize(this.convertInputToString((BObject)this.getValue()).length());
        }
        BIFlexMessageBlock bIFlexMessageBlock = this.getParentMessageComponent();
        if (bIFlexMessageBlock != null) {
            bIFlexMessageBlock.calculateItemOffsets();
        }
    }

    protected void exposeInParent() {
        BComplex bComplex;
        if (this.getExposeInParent() && (bComplex = this.getParent().getParent()) instanceof BFlexMessageSelect) {
            BFlexMessageSelect bFlexMessageSelect = (BFlexMessageSelect)bComplex;
            String string = this.getName();
            BStatusNumeric bStatusNumeric = new BStatusNumeric();
            BValue bValue = this.getValue().newCopy();
            switch (this.getDataType().getOrdinal()) {
                case 0: 
                case 1: 
                case 2: {
                    int n = ((BInteger)bValue).getInt();
                    int n2 = this.getFacets().geti(ACTIVE_VALUE, -1);
                    int n3 = this.getFacets().geti(INACTIVE_VALUE, -1);
                    if (n2 != -1) {
                        boolean bl = false;
                        if (n == n2) {
                            bl = true;
                        }
                        bStatusNumeric = new BStatusBoolean(bl);
                        break;
                    }
                    if (n3 != -1) {
                        boolean bl = false;
                        if (n != n3) {
                            bl = true;
                        }
                        bStatusNumeric = new BStatusBoolean(bl);
                        break;
                    }
                    bStatusNumeric = new BStatusNumeric((double)n);
                    break;
                }
                case 4: {
                    String string2 = ((BString)bValue).getString();
                    String string3 = this.getFacets().gets(ACTIVE_TEXT, null);
                    String string4 = this.getFacets().gets(INACTIVE_TEXT, null);
                    if (string3 != null) {
                        bStatusNumeric = new BStatusBoolean(string2.equals(string3));
                        break;
                    }
                    if (string4 != null) {
                        bStatusNumeric = new BStatusBoolean(string2.equals(string4) ^ true);
                        break;
                    }
                    bStatusNumeric = new BStatusString(((BString)bValue).getString());
                    break;
                }
                case 3: {
                    if (bValue instanceof BStatusNumeric) {
                        bStatusNumeric = (BStatusNumeric)bValue;
                        break;
                    }
                    if (bValue instanceof BDouble) {
                        bStatusNumeric = new BStatusNumeric(((BDouble)bValue).getDouble());
                        break;
                    }
                    if (!(bValue instanceof BFloat)) break;
                    bStatusNumeric = new BStatusNumeric(((BFloat)bValue).getDouble());
                    break;
                }
            }
            try {
                bFlexMessageSelect.add(string, (BValue)bStatusNumeric, 9);
            }
            catch (DuplicateSlotException duplicateSlotException) {
                bFlexMessageSelect.set(string, (BValue)bStatusNumeric);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected BIFlexMessageBlock getParentMessageComponent() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BIFlexMessageBlock) {
                return (BIFlexMessageBlock)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void readFrom(BObject bObject, FlexInputStream flexInputStream) {
        this.readFromDirect(bObject, flexInputStream);
    }

    public void readFromDirect(BObject bObject, FlexInputStream flexInputStream) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    this.set(value, (BValue)BInteger.make((int)(flexInputStream.read(this.getEncode(), this.getFacets()) & 0xFF)), Context.decoding);
                    break;
                }
                case 1: {
                    this.set(value, (BValue)BInteger.make((int)flexInputStream.readWord(this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 2: {
                    this.set(value, (BValue)BInteger.make((int)flexInputStream.readInt(this.getSize(), this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 4: {
                    this.set(value, (BValue)BString.make((String)flexInputStream.readString(this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 3: {
                    this.set(value, (BValue)BFloat.make((float)flexInputStream.readFloat(this.getEncode(), this.getFacets())), Context.decoding);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + bObject.getType());
            this.getDataType().getOrdinal();
        }
    }

    public void readFromIndirect(BObject bObject, FlexInputStream flexInputStream) {
        BOrd bOrd = this.getSource();
        BObject bObject2 = bOrd.get(bObject);
        this.readFrom(flexInputStream, bObject);
    }

    public void readFrom(FlexInputStream flexInputStream, BObject bObject) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    if (bObject instanceof BStatusNumeric) {
                        ((BStatusNumeric)bObject).setValue((double)(flexInputStream.read(this.getEncode(), this.getFacets()) & 0xFF));
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + bObject.getType());
            this.getDataType().getOrdinal();
        }
    }

    public void writeTo(BObject bObject, FlexOutputStream flexOutputStream) {
        if (this.isIndirect()) {
            this.writeToIndirect(bObject, flexOutputStream);
        } else {
            this.writeToDirect(bObject, flexOutputStream);
        }
    }

    public void writeToDirect(BObject bObject, FlexOutputStream flexOutputStream) {
        this.writeTo(flexOutputStream, (BObject)this.getValue());
    }

    public void writeToIndirect(BObject bObject, FlexOutputStream flexOutputStream) {
        BOrd bOrd = this.getSource();
        BObject bObject2 = bOrd.get(bObject);
        if (bObject2 instanceof BProgram) {
            BProgram bProgram = (BProgram)bObject2;
            bProgram.set("byteArray", (BValue)BBlob.make((byte[])flexOutputStream.toByteArray()));
            bProgram.set("offset", (BValue)BInteger.make((int)flexOutputStream.getCksumStart()));
            bProgram.doExecute();
            this.writeTo(flexOutputStream, (BObject)bProgram.get("cksumResults"));
            this.setValue(bProgram.get("cksumResults"));
        } else {
            this.writeTo(flexOutputStream, bObject2);
            if (bObject2 instanceof BComplex) {
                this.set(value, ((BComplex)bObject2).newCopy(), Context.decoding);
            } else {
                this.set(value, (BValue)bObject2, Context.decoding);
            }
        }
    }

    public void writeTo(FlexOutputStream flexOutputStream, BObject bObject) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    flexOutputStream.write(this.convertInputToInt(bObject), this.getEncode(), this.getFacets());
                    break;
                }
                case 1: {
                    flexOutputStream.writeInt(this.convertInputToInt(bObject), 2, this.getEncode(), this.getFacets());
                    break;
                }
                case 2: {
                    flexOutputStream.writeInt(this.convertInputToInt(bObject), this.getSize(), this.getEncode(), this.getFacets());
                    break;
                }
                case 3: {
                    flexOutputStream.writeInt(Float.floatToIntBits(this.convertInputToFloat(bObject)), 4, this.getEncode(), this.getFacets());
                    this.setSize(4);
                    break;
                }
                case 4: {
                    flexOutputStream.writeString(this.convertInputToString(bObject), this.getEncode(), this.getFacets());
                    if (this.getFacets().getb(NULL_TERMINATE, false)) {
                        flexOutputStream.write(0);
                    }
                    break;
                }
                case 5: {
                    if (!this.getName().equals(CKSUM_START_MARKER_NAME)) break;
                    flexOutputStream.setCksumStart(flexOutputStream.size());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + bObject.getType());
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    flexOutputStream.write(-1);
                    break;
                }
                case 1: {
                    flexOutputStream.writeInt(-1, 2, this.getEncode(), this.getFacets());
                    break;
                }
                case 2: {
                    flexOutputStream.writeInt(-1, this.getSize(), this.getEncode(), this.getFacets());
                    break;
                }
                case 3: {
                    flexOutputStream.writeInt(Float.floatToIntBits(Float.NaN), 4, this.getEncode(), this.getFacets());
                    this.setSize(4);
                    break;
                }
                case 4: {
                    flexOutputStream.writeString("Invalid", this.getEncode(), this.getFacets());
                    break;
                }
            }
        }
    }

    public int getMarker(String string) {
        if (this.getName().equals(string)) {
            return this.getOffset();
        }
        return -1;
    }

    public boolean isIndirect() {
        return this.getSource().equals((Object)BOrd.NULL) ^ true;
    }

    public String toString(Context context) {
        return this.getValue().toString(context);
    }

    public int convertInputToInt(BObject bObject) {
        try {
            if (bObject instanceof BString) {
                return BInteger.decode((String)((BString)bObject).getString());
            }
            if (bObject instanceof BInteger) {
                return ((BInteger)bObject).getInt();
            }
            if (bObject instanceof BFloat) {
                return (int)((BFloat)bObject).getFloat();
            }
            if (bObject instanceof BDouble) {
                return (int)((BDouble)bObject).getDouble();
            }
            if (bObject instanceof BBoolean) {
                int n = 1;
                int n2 = 0;
                BObject bObject2 = this.getFacets().getFacet(ACTIVE_VALUE);
                try {
                    n = ((BInteger)bObject2).getInt();
                }
                catch (Exception exception) {}
                BObject bObject3 = this.getFacets().getFacet(INACTIVE_VALUE);
                try {
                    n2 = ((BInteger)bObject3).getInt();
                }
                catch (Exception exception) {}
                if (((BBoolean)bObject).getBoolean()) {
                    return n;
                }
                return n2;
            }
            if (bObject instanceof BEnum) {
                return ((BEnum)bObject).getOrdinal();
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public float convertInputToFloat(BObject bObject) {
        try {
            if (bObject instanceof BString) {
                return BFloat.decode((String)((BString)bObject).getString());
            }
            if (bObject instanceof BNumber) {
                return ((BNumber)bObject).getFloat();
            }
        }
        catch (Exception exception) {
            return 0.0f;
        }
        return 0.0f;
    }

    public String convertInputToString(BObject bObject) {
        try {
            String string = "";
            if (bObject instanceof BString) {
                return ((BString)bObject).getString();
            }
            if (bObject instanceof BNumber) {
                BNumber bNumber = (BNumber)bObject;
                BFacets bFacets = this.getFacets();
                String string2 = bFacets.gets(DECIMAL_FORMAT, "");
                int n = bFacets.geti(PAD_WITH, -1);
                int n2 = bFacets.geti(FIELD_WIDTH, -1);
                float f = bFacets.getf(MAX, Float.POSITIVE_INFINITY);
                float f2 = bFacets.getf(MIN, Float.NEGATIVE_INFINITY);
                boolean bl = bFacets.getb(NULL_TERMINATE, false);
                double d = bNumber.getNumeric();
                if (d > (double)f) {
                    d = f;
                } else if (d < (double)f2) {
                    d = f2;
                }
                if (string2.length() > 0) {
                    if (d < 0.0 && string2.startsWith("0")) {
                        string2 = string2.substring(1);
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(string2);
                    string = decimalFormat.format(d);
                } else {
                    string = bNumber.toString((Context)new DataContext(bFacets));
                }
                if (n2 > 0) {
                    if (bl) {
                        --n2;
                    }
                    if (string.length() > n2) {
                        string = string.substring(0, n2);
                    }
                }
                return string;
            }
            if (bObject instanceof BBoolean) {
                String string3 = this.getFacets().gets(ACTIVE_TEXT, "1");
                String string4 = this.getFacets().gets(INACTIVE_TEXT, "0");
                if (((BBoolean)bObject).getBoolean()) {
                    return string3;
                }
                return string4;
            }
            if (bObject instanceof BEnum) {
                return ((BEnum)bObject).toString((Context)new DataContext(this.getFacets()));
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "";
    }

    public boolean getBooleanValue() {
        if (this.getValue() instanceof BString) {
            String string = ((BString)this.getValue()).getString().trim();
            String string2 = this.getFacets().gets(ACTIVE_TEXT, "");
            String string3 = this.getFacets().gets(INACTIVE_TEXT, "");
            if (string2.length() > 0) {
                return string.equals(string2);
            }
            if (string3.length() > 0) {
                return string.equals(string3) ^ true;
            }
        }
        if (this.getValue() instanceof BNumber) {
            int n = ((BNumber)this.getValue()).getInt();
            boolean bl = false;
            if (n != 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public String getStringValue() {
        if (this.getValue() instanceof BString) {
            return ((BString)this.getValue()).getString();
        }
        return this.getValue().toString((Context)new DataContext(this.getFacets()));
    }

    public double getDoubleValue() {
        if (this.getValue() instanceof BNumber) {
            return ((BNumber)this.getValue()).getDouble();
        }
        return Double.NaN;
    }

    public BEnum getEnumValue() {
        int n = -1;
        if (this.getValue() instanceof BNumber) {
            n = ((BNumber)this.getValue()).getInt();
        }
        return BDynamicEnum.make((int)n);
    }

    public static boolean isBigEndian(BFacets bFacets) {
        boolean bl = false;
        BObject bObject = bFacets.getFacet(BIG_ENDIAN);
        try {
            bl = ((BBoolean)bObject).getBoolean();
        }
        catch (Exception exception) {}
        return bl;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$flexSerial$messages$BFlexMessageElement;
        if (clazz == null) {
            clazz = class$com$tridium$flexSerial$messages$BFlexMessageElement = BFlexMessageElement.class("[Lcom.tridium.flexSerial.messages.BFlexMessageElement;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://flexSerial/com/tridium/flexSerial/icons/flexMessageElement.png");
        BIG_ENDIAN = "bigEndian";
        ACTIVE_VALUE = "activeValue";
        INACTIVE_VALUE = "inactiveValue";
        ACTIVE_TEXT = "activeText";
        INACTIVE_TEXT = "inactiveText";
        PAD_WITH = "padWith";
        NULL_TERMINATE = "nullTerminate";
        DECIMAL_FORMAT = "decimalFormat";
        FIELD_WIDTH = "fieldWidth";
        MAX = "max";
        MIN = "min";
        SHOW_ASCII = "showAscii";
        CKSUM_START_MARKER_NAME = "cksumStart";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DataContext
    implements Context {
        BFacets facets;

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return new BUser();
        }

        public BFacets getFacets() {
            return this.facets;
        }

        public BObject getFacet(String string) {
            return this.getFacets().get(string);
        }

        public String getLanguage() {
            return Sys.getLanguage();
        }

        public DataContext(BFacets bFacets) {
            this.facets = bFacets;
        }
    }
}

