/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.comm;

import com.tridium.flexSerial.comm.TLinkedListElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TLinkedListManager {
    private TLinkedListElement head;
    private TLinkedListElement tail;
    private int size;
    private String name;

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        boolean bl = false;
        if (this.head == null) {
            bl = true;
        }
        return bl;
    }

    public synchronized void signal() {
        this.notifyAll();
    }

    public synchronized void addToHead(TLinkedListElement tLinkedListElement) {
        TLinkedListManager tLinkedListManager = tLinkedListElement.getLinkedListManager();
        if (tLinkedListManager != null) {
            throw new IllegalStateException("Already linked " + tLinkedListManager.getName() + ", my name " + this.getName());
        }
        tLinkedListElement.setLinkedListManager(this);
        if (this.head == null) {
            this.head = this.tail = tLinkedListElement;
        } else {
            tLinkedListElement.setNext(this.head);
            this.head = tLinkedListElement;
        }
        ++this.size;
        this.notifyAll();
    }

    public synchronized void addToTail(TLinkedListElement tLinkedListElement) {
        TLinkedListManager tLinkedListManager = tLinkedListElement.getLinkedListManager();
        if (tLinkedListManager != null) {
            throw new IllegalStateException("Already linked " + tLinkedListManager.getName() + ", my name " + this.getName());
        }
        tLinkedListElement.setLinkedListManager(this);
        if (this.head == null) {
            this.head = this.tail = tLinkedListElement;
        } else {
            this.tail.setNext(tLinkedListElement);
            this.tail = tLinkedListElement;
        }
        ++this.size;
        this.notifyAll();
    }

    public synchronized TLinkedListElement removeFromHead() {
        if (this.head == null) {
            return null;
        }
        TLinkedListElement tLinkedListElement = this.head;
        this.head = tLinkedListElement.getNext();
        if (this.head == null) {
            this.tail = null;
        }
        --this.size;
        tLinkedListElement.setLinkedListManager(null);
        tLinkedListElement.setNext(null);
        return tLinkedListElement;
    }

    public synchronized TLinkedListElement removeFromHead(long l) throws InterruptedException {
        if (this.head == null) {
            if (l == (long)-1) {
                this.wait();
            } else {
                this.wait(l);
            }
        }
        return this.removeFromHead();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        boolean bl = true;
        stringBuffer.append(this.size()).append(" {");
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(enumeration.nextElement());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Enumeration elements() {
        return new Enumerator();
    }

    public TLinkedListManager(String string) {
        this.name = string;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Enumerator
    implements Enumeration {
        private TLinkedListElement cur;

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.cur != null) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            TLinkedListElement tLinkedListElement = this.cur;
            this.cur = this.cur.getNext();
            return tLinkedListElement;
        }

        public Enumerator() {
            this.cur = TLinkedListManager.this.head;
        }
    }
}

