/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.flexSerial.messages.SerialMessageConst;
import com.tridium.flexSerial.messages.SerialReceivedMessage;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FlexSerialCommReceiver
extends CommReceiver
implements SerialMessageConst {
    private static Integer DEFAULT_TAG = new Integer(-1);
    private static final int WAIT_FOR_FRAME_START = 0;
    private static final int READ_DATA = 20;
    private static final int READ_FRAME_END = 30;
    private long lastCharTicks;
    private long maxReceiveSilentTime;
    private byte[] frameStart;
    private byte[] frameEnd;
    private boolean stripReceiveFraming;
    private int state;
    private ByteBuffer rcvBuffer;
    private SerialReceivedMessage msg;

    public void setFrameStart(byte[] byArray) {
        this.frameStart = byArray;
    }

    public void setFrameEnd(byte[] byArray) {
        this.frameEnd = byArray;
    }

    public void setStripReceiveFraming(boolean bl) {
        this.stripReceiveFraming = bl;
    }

    public void setMaxReceiveSilentTime(int n) {
        this.maxReceiveSilentTime = n;
    }

    protected ReceivedMessage receive() throws Exception {
        this.state = this.frameStart.length == 0 ? 0 : 0;
        boolean bl = false;
        this.rcvBuffer.reset();
        while (!bl) {
            int n = this.getInputStream().read();
            boolean bl2 = false;
            if (n != -1) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            n &= 0xFF;
            if (bl3) {
                this.getLog().trace("state= " + this.state + "; rx= " + Integer.toHexString(n));
                switch (this.state) {
                    case 0: {
                        if (this.frameStart.length == 0) {
                            this.rcvBuffer.reset();
                            this.rcvBuffer.write((int)((byte)n));
                            this.state = 20;
                            break;
                        }
                        if (n != (this.frameStart[0] & 0xFF)) break;
                        this.rcvBuffer.reset();
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)n));
                        }
                        if (this.frameStart.length == 1) {
                            this.state = 20;
                            break;
                        }
                        this.state = 1;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        int n2;
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)n));
                        }
                        if (n == (this.frameStart[n2 = this.state] & 0xFF)) {
                            ++this.state;
                            if (this.frameStart.length != ++n2) break;
                            this.state = 20;
                            break;
                        }
                        this.state = 0;
                        break;
                    }
                    case 20: {
                        if (this.frameEnd.length > 0) {
                            if (n == (this.frameEnd[0] & 0xFF)) {
                                if (!this.stripReceiveFraming) {
                                    this.rcvBuffer.write((int)((byte)n));
                                }
                                if (this.frameEnd.length == 1) {
                                    bl = true;
                                    break;
                                }
                                this.state = 31;
                                break;
                            }
                            this.rcvBuffer.write((int)((byte)n));
                            break;
                        }
                        this.rcvBuffer.write((int)((byte)n));
                        break;
                    }
                    default: {
                        int n2;
                        if (!this.stripReceiveFraming) {
                            this.rcvBuffer.write((int)((byte)n));
                        }
                        if (n == (this.frameEnd[n2 = this.state - 30] & 0xFF)) {
                            ++this.state;
                            if (this.frameEnd.length != ++n2) break;
                            bl = true;
                            break;
                        }
                        this.state = 20;
                    }
                }
                if (this.rcvBuffer.getLength() > 0) {
                    this.lastCharTicks = Clock.ticks();
                }
            }
            if (this.frameEnd.length != 0 || this.rcvBuffer.getLength() <= 0 || this.maxReceiveSilentTime <= 0L || Clock.ticks() - this.lastCharTicks <= this.maxReceiveSilentTime) continue;
            bl = true;
        }
        if (this.msg == null) {
            this.msg = new SerialReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength(), DEFAULT_TAG);
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
            this.msg.setTag(DEFAULT_TAG);
        }
        return this.msg;
    }

    Log getLog() {
        Log log = this.getComm().getNetwork().getLog();
        return Log.getLog((String)(log.getLogName() + ".rx"));
    }

    private final /* synthetic */ void this() {
        this.lastCharTicks = 0L;
        this.maxReceiveSilentTime = 0L;
        this.frameStart = new byte[0];
        this.frameEnd = new byte[]{13};
        this.stripReceiveFraming = false;
        this.state = 0;
        this.rcvBuffer = new ByteBuffer();
        this.msg = null;
    }

    public FlexSerialCommReceiver() {
        this.this();
    }
}

