/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.json.BoxWriter;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.ContractEncoderVisitor;
import com.tridium.box.typenode.TypeNodeBuilder;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import javax.baja.naming.BOrdScheme;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

public final class RegistryEncoderVisitor
extends TypeNodeVisitor {
    private static final TypeInfo ordSchemeType = Sys.getRegistry().getType("baja:OrdScheme");
    private static final TypeInfo interfaceType = Sys.getRegistry().getType("baja:Interface");
    private static final TypeInfo objectType = Sys.getRegistry().getType("baja:Object");
    private static final BIcon stdObjIcon = BIcon.std((String)"object.png");
    private BoxWriter out;
    private ContractEncoderVisitor contractEncoder;
    private String lang;
    private boolean useCache;
    private boolean includeCommonTypes;

    public final boolean doVisit(TypeNodeBuilder.TypeNode typeNode) throws Exception {
        TypeInfo typeInfo = typeNode.getTypeInfo();
        String string = typeInfo.toString();
        boolean bl = false;
        if (this.includeCommonTypes || !CommonTypes.isCommonType(string)) {
            bl = true;
        }
        boolean bl2 = bl;
        this.out.key(string);
        if (bl2) {
            if (this.useCache) {
                if (!typeNode.hasCache() || !typeNode.getCacheKey().equals(this.lang)) {
                    BoxWriter boxWriter = new BoxWriter();
                    boxWriter.object();
                    this.encode(typeInfo, boxWriter, typeNode);
                    boxWriter.endObject();
                    typeNode.setCache(this.lang, (Object)boxWriter);
                }
                this.out.value(typeNode.getCache());
            } else {
                this.out.object();
                this.encode(typeInfo, this.out, typeNode);
                this.out.endObject();
            }
        } else {
            this.out.object().endObject();
        }
        return bl2;
    }

    private final void encode(TypeInfo typeInfo, BoxWriter boxWriter, TypeNodeBuilder.TypeNode typeNode) throws Exception {
        BOrdScheme bOrdScheme;
        boolean bl;
        if (typeInfo.is(BComplex.TYPE) || typeInfo.is(BFrozenEnum.TYPE)) {
            if (this.contractEncoder != null) {
                boxWriter.key("c");
                this.contractEncoder.encode(typeNode, boxWriter);
            } else if (typeInfo.is(BComplex.TYPE)) {
                try {
                    ComplexType complexType = (ComplexType)typeInfo.getTypeSpec().getResolvedType();
                    if (complexType.getFrozenSlots().length == 0) {
                        boxWriter.key("c").array().endArray();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        if (bl = typeInfo.isInterface()) {
            boxWriter.key("i").value(true);
        }
        if (typeInfo.isTransient()) {
            boxWriter.key("t").value(true);
        }
        if (typeInfo.is(BValue.TYPE)) {
            boxWriter.key("isv").value(true);
        }
        if (typeInfo.is(BSimple.TYPE)) {
            boxWriter.key("iss").value(true);
        }
        if (typeInfo.is(BSingleton.TYPE)) {
            boxWriter.key("isg").value(true);
        }
        if (typeInfo.is(BNumber.TYPE)) {
            boxWriter.key("isn").value(true);
        }
        if (typeInfo.is(BComplex.TYPE)) {
            boxWriter.key("isx").value(true);
        }
        if (typeInfo.is(BComponent.TYPE)) {
            boxWriter.key("isc").value(true);
        }
        if (typeInfo.is(BLink.TYPE)) {
            boxWriter.key("isl").value(true);
        }
        if (typeInfo.is(BAction.TYPE)) {
            boxWriter.key("isa").value(true);
        }
        if (typeInfo.is(BTopic.TYPE)) {
            boxWriter.key("ist").value(true);
        }
        if (typeInfo.is(BFrozenEnum.TYPE)) {
            boxWriter.key("ise").value(true);
        }
        if (!bl) {
            if (typeInfo.isAbstract()) {
                boxWriter.key("a").value(true);
            } else if (typeInfo.is(ordSchemeType)) {
                bOrdScheme = (BOrdScheme)typeInfo.getInstance();
                boxWriter.key("os").value((Object)bOrdScheme.getId());
            }
        }
        if ((bOrdScheme = typeInfo.getInterfaces()) != null && ((TypeInfo[])bOrdScheme).length > 0) {
            boxWriter.key("it").array();
            int n = 0;
            while (n < ((BOrdScheme)bOrdScheme).length) {
                if (!bOrdScheme[n].equals(interfaceType)) {
                    boxWriter.value(bOrdScheme[n]);
                }
                ++n;
            }
            boxWriter.endArray();
        }
        BIcon bIcon = typeInfo.getIcon(null);
        if (!bl) {
            if (!typeInfo.isAbstract()) {
                try {
                    bIcon = typeInfo.getInstance().getIcon();
                }
                catch (Throwable throwable) {}
            }
            if (typeInfo.getSuperType() != null && !typeInfo.getSuperType().equals(objectType)) {
                boxWriter.key("p").value((Object)typeInfo.getSuperType().toString());
            }
        }
        if (bIcon != null && bIcon != BIcon.DEFAULT && !bIcon.equals((Object)stdObjIcon)) {
            try {
                boxWriter.key("ic").value((Object)bIcon.encodeToString());
            }
            catch (Exception exception) {
                System.out.println("Error encoding icon to BOX...");
                exception.printStackTrace();
            }
        }
    }

    public RegistryEncoderVisitor(BoxWriter boxWriter, ContractEncoderVisitor contractEncoderVisitor, Context context, boolean bl, boolean bl2) {
        this.out = boxWriter;
        this.contractEncoder = contractEncoderVisitor;
        this.includeCommonTypes = bl2;
        this.lang = context != null ? context.getLanguage() : "";
        this.useCache = bl;
    }
}

