/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import com.tridium.box.json.BlackListedTypes;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import org.json.JSONException;
import org.json.JSONWriter;

public final class BsonEncoderPlugin
implements ValueDocEncoder.IEncoderPlugin {
    private JSONWriter w;
    private OutputStream out;
    private OutputStreamWriter outw;

    public final ValueDocEncoder.IEncoderPlugin encodeDocStart() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin encodeDocEnd() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin encodeDocument(ValueDocEncoder valueDocEncoder, BValue bValue) throws IOException {
        valueDocEncoder.encode(bValue);
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin start(String string) throws IOException {
        try {
            this.w.object().key("nm").value((Object)string);
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin startArray(String string) throws IOException {
        try {
            this.w.key(string).array();
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin endArray() throws IOException {
        try {
            this.w.endArray();
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin end() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin end(String string) throws IOException {
        return this.end();
    }

    public final ValueDocEncoder.IEncoderPlugin endAttr() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin newLine() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin endProp() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin key(String string) throws IOException {
        try {
            this.w.key(string);
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin attr(String string, boolean bl) throws IOException {
        this.attr(string, String.valueOf(bl));
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin attr(String string, double d) throws IOException {
        this.attr(string, String.valueOf(d));
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin attr(String string, String string2) throws IOException {
        try {
            this.w.key(string).value((Object)string2);
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin attrSafe(String string, String string2) throws IOException {
        return this.attr(string, string2);
    }

    public final ValueDocEncoder.IEncoderPlugin value(String string) throws IOException {
        try {
            this.w.value((Object)string);
        }
        catch (JSONException jSONException) {
            throw new BsonIoException(jSONException);
        }
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin comment(String string) throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin incrementIndent() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin decrementIndent() throws IOException {
        return this;
    }

    public final ValueDocEncoder.IEncoderPlugin indent() throws IOException {
        return this;
    }

    public final int getIndent() {
        return -1;
    }

    public final ValueDocEncoder.IEncoderPlugin encodeType(Type type) throws IOException {
        this.attr("t", type.toString());
        return this;
    }

    public final void flush() throws IOException {
        if (this.outw != null) {
            this.outw.flush();
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public final void close() throws IOException {
        this.flush();
        if (this.outw != null) {
            this.outw.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public final boolean isZipped() {
        return false;
    }

    public final void setZipped(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static final String marshal(BValue bValue) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DisplayEncoder displayEncoder = new DisplayEncoder(new BsonEncoderPlugin(byteArrayOutputStream));
        displayEncoder.encode(bValue);
        displayEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static final String marshal(BValue bValue, Context context) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DisplayEncoder displayEncoder = new DisplayEncoder(new BsonEncoderPlugin(byteArrayOutputStream), context);
        displayEncoder.encode(bValue);
        displayEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static final void encodingSlotBson(ValueDocEncoder valueDocEncoder, BComplex bComplex, Slot slot) throws IOException {
        valueDocEncoder.getPlugin().attr("dn", BsonEncoderPlugin.getSlotDisplayName(bComplex, slot, valueDocEncoder.getContext()));
    }

    public static final String getSlotDisplayName(BComplex bComplex, Slot slot, Context context) {
        BValue bValue;
        if (slot.isDynamic() && (bValue = bComplex.get((Property)slot)) instanceof BIMixIn) {
            return ((BIMixIn)bValue).getDisplayNameInParent(context);
        }
        return slot.getDefaultDisplayName(context);
    }

    public static final void encodingValueBson(ValueDocEncoder valueDocEncoder, BValue bValue, Context context) throws IOException {
        BAction bAction;
        valueDocEncoder.getPlugin().attr("d", valueDocEncoder.isTypeBlackListed(bValue.getType()) ? "" : bValue.toString(context));
        if (bValue.getType().is(BAction.TYPE)) {
            bAction = (BAction)bValue;
            BsonEncoderPlugin.encodeActionBson(valueDocEncoder, bAction.getParameterType(), bAction.getParameterDefault(), bAction.getReturnType());
        }
        if (bValue.getType().is(BTopic.TYPE)) {
            bAction = (BTopic)bValue;
            BsonEncoderPlugin.encodeTopicBson(valueDocEncoder, bAction.getEventType());
        }
    }

    public static final void encodeActionBson(ValueDocEncoder valueDocEncoder, Type type, BValue bValue, Type type2) throws IOException {
        ValueDocEncoder.IEncoderPlugin iEncoderPlugin = valueDocEncoder.getPlugin();
        if (type != null) {
            iEncoderPlugin.attr("apt", type.toString());
        }
        if (bValue != null) {
            valueDocEncoder.key("apd");
            valueDocEncoder.encode(bValue);
        }
        if (type2 != null) {
            valueDocEncoder.attr("art", type2.toString());
        }
    }

    public static final void encodeTopicBson(ValueDocEncoder valueDocEncoder, Type type) throws IOException {
        if (type != null) {
            valueDocEncoder.attr("tet", type.toString());
        }
    }

    public BsonEncoderPlugin(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public BsonEncoderPlugin(OutputStream outputStream) throws IOException {
        this.out = new BufferedOutputStream(outputStream);
        this.outw = new OutputStreamWriter(outputStream);
        this.w = new JSONWriter((Writer)this.outw);
    }

    public BsonEncoderPlugin(JSONWriter jSONWriter) throws IOException {
        this.w = jSONWriter;
    }

    private static class BsonIoException
    extends IOException {
        private BsonIoException(JSONException jSONException) {
            super(jSONException.getMessage());
            this.initCause(jSONException);
        }
    }

    public static final class DisplayEncoder
    extends ValueDocEncoder {
        protected final void encodingSlot(BComplex bComplex, Slot slot) throws IOException {
            BsonEncoderPlugin.encodingSlotBson(this, bComplex, slot);
        }

        protected final void encodingValue(BValue bValue, Context context) throws IOException {
            BsonEncoderPlugin.encodingValueBson(this, bValue, context);
        }

        public final boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        public DisplayEncoder(ValueDocEncoder.IEncoderPlugin iEncoderPlugin) throws IOException {
            super(iEncoderPlugin);
            this.setEncodeComments(false);
            this.setEncodeTransients(true);
        }

        public DisplayEncoder(ValueDocEncoder.IEncoderPlugin iEncoderPlugin, Context context) throws IOException {
            super(iEncoderPlugin, context);
            this.setEncodeComments(false);
            this.setEncodeTransients(true);
        }
    }
}

