/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxServlet;
import com.tridium.box.BOrdChannel;
import com.tridium.box.BRegistryChannel;
import com.tridium.box.BServerCacheConfig;
import com.tridium.box.BServerSessionChannel;
import com.tridium.box.BSysChannel;
import com.tridium.box.json.BoxWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.WebOp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBoxService
extends BAbstractService {
    public static final Property servlet = BBoxService.newProperty((int)4, (BValue)new BBoxServlet(), null);
    public static final Property sys = BBoxService.newProperty((int)0, (BValue)new BSysChannel(), null);
    public static final Property reg = BBoxService.newProperty((int)0, (BValue)new BRegistryChannel(), null);
    public static final Property ssession = BBoxService.newProperty((int)0, (BValue)new BServerSessionChannel(), null);
    public static final Property ord = BBoxService.newProperty((int)0, (BValue)new BOrdChannel(), null);
    public static final Property serverCacheConfig = BBoxService.newProperty((int)0, (BValue)BServerCacheConfig.medium, null);
    public static final Property enableWebStorage = BBoxService.newProperty((int)0, (boolean)true, null);
    public static final Property logClientErrors = BBoxService.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    public static final Log log;
    private static final BIcon icon;
    private static final Object sessionMonitor;
    private Array listeners;
    private volatile boolean hasListeners;
    private volatile int sessionLimit;
    private volatile int sessionCount;
    static /* synthetic */ Class class$com$tridium$box$BBoxService;
    static /* synthetic */ Class class$com$tridium$box$BBoxService$IBoxListener;

    public final BBoxServlet getServlet() {
        return (BBoxServlet)this.get(servlet);
    }

    public final void setServlet(BBoxServlet bBoxServlet) {
        this.set(servlet, (BValue)bBoxServlet, null);
    }

    public final BSysChannel getSys() {
        return (BSysChannel)this.get(sys);
    }

    public final void setSys(BSysChannel bSysChannel) {
        this.set(sys, (BValue)bSysChannel, null);
    }

    public final BRegistryChannel getReg() {
        return (BRegistryChannel)this.get(reg);
    }

    public final void setReg(BRegistryChannel bRegistryChannel) {
        this.set(reg, (BValue)bRegistryChannel, null);
    }

    public final BServerSessionChannel getSsession() {
        return (BServerSessionChannel)this.get(ssession);
    }

    public final void setSsession(BServerSessionChannel bServerSessionChannel) {
        this.set(ssession, (BValue)bServerSessionChannel, null);
    }

    public final BOrdChannel getOrd() {
        return (BOrdChannel)this.get(ord);
    }

    public final void setOrd(BOrdChannel bOrdChannel) {
        this.set(ord, (BValue)bOrdChannel, null);
    }

    public final BServerCacheConfig getServerCacheConfig() {
        return (BServerCacheConfig)this.get(serverCacheConfig);
    }

    public final void setServerCacheConfig(BServerCacheConfig bServerCacheConfig) {
        this.set(serverCacheConfig, (BValue)bServerCacheConfig, null);
    }

    public final boolean getEnableWebStorage() {
        return this.getBoolean(enableWebStorage);
    }

    public final void setEnableWebStorage(boolean bl) {
        this.setBoolean(enableWebStorage, bl, null);
    }

    public final boolean getLogClientErrors() {
        return this.getBoolean(logClientErrors);
    }

    public final void setLogClientErrors(boolean bl) {
        this.setBoolean(logClientErrors, bl, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public final void serviceStarted() throws Exception {
        this.setFlags((Slot)enabled, this.getFlags((Slot)enabled) | 4);
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBoxChannel.TYPE.getTypeInfo());
        int n = 0;
        while (n < typeInfoArray.length) {
            BBoxChannel bBoxChannel = (BBoxChannel)typeInfoArray[n].getInstance();
            String string = bBoxChannel.getChannelName();
            if (this.get(string) == null) {
                this.add(string, (BValue)bBoxChannel);
            }
            ++n;
        }
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void changed(Property property, Context context) {
        if (property == serverCacheConfig && this.isRunning()) {
            this.getReg().clearBuilder(this.getServerCacheConfig());
        }
    }

    public final void handleRequest(Reader reader, Writer writer, Context object) throws Exception {
        block23: {
            try {
                Writer writer2;
                object = new BoxContext((Context)object);
                JSONTokener jSONTokener = new JSONTokener(reader);
                JSONObject jSONObject = new JSONObject(jSONTokener);
                if (!jSONObject.getString("p").equals("box")) {
                    throw new Exception("Unsuppored JSON Protocol: " + jSONObject.getString("p"));
                }
                boolean bl = log.isTraceOn();
                if (bl || this.hasListeners) {
                    if (bl) {
                        log.trace(BBoxService.makeLogMsg("BOX Request - " + jSONObject.toString(2), object));
                    }
                    if (this.hasListeners) {
                        this.notifyListeners((Context)object, BBoxRecordType.request, jSONObject.toString());
                    }
                    writer2 = new StringWriter();
                } else {
                    writer2 = writer;
                }
                BoxWriter boxWriter = new BoxWriter(writer2);
                boxWriter.object().key("v").value(1L).key("p").value((Object)"box");
                boxWriter.key("m").array();
                JSONArray jSONArray = jSONObject.getJSONArray("m");
                int n = 0;
                while (n < jSONArray.length()) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(n);
                    if (jSONObject2.getString("t").equals("rt")) {
                        String string = SlotPath.escape((String)jSONObject2.getString("c"));
                        String string2 = jSONObject2.getString("k").intern();
                        int n2 = jSONObject2.getInt("r");
                        BoxWriter boxWriter2 = BBoxService.makeMessageWriter(string, string2, n2);
                        try {
                            if (this.isFatalFault()) {
                                throw new BoxServiceFatalFaultException((Context)object);
                            }
                            if (!this.isOperational()) {
                                throw new BoxServiceNonOperationalException((Context)object);
                            }
                            BBoxChannel bBoxChannel = (BBoxChannel)this.get(string);
                            if (bBoxChannel == null) {
                                throw new Exception("Could not find Box Channel to service request: " + string);
                            }
                            boxWriter2.key("b");
                            boolean bl2 = bBoxChannel.service(string2, jSONObject2.get("b"), boxWriter2, (Context)object);
                            if (!bl2) {
                                throw new Exception("Unsupported Key: " + string2 + " for Box Channel: " + string);
                            }
                            boxWriter2.key("t").value((Object)"rp");
                        }
                        catch (Throwable throwable) {
                            boxWriter2 = BBoxService.makeMessageWriter(string, string2, n2);
                            if (throwable instanceof BoxCommsFailed) {
                                BoxCommsFailed boxCommsFailed = (BoxCommsFailed)throwable;
                                boxWriter2.key("et").value((Object)boxCommsFailed.getBsonErrorType());
                                boxWriter2.key("cf").value(true);
                            } else {
                                boxWriter2.key("et").value((Object)"BoxError");
                            }
                            log.error(BBoxService.makeLogMsg("Request", object), throwable);
                            if (this.hasListeners) {
                                StringWriter stringWriter = new StringWriter();
                                throwable.printStackTrace(new PrintWriter(stringWriter));
                                this.notifyListeners((Context)object, BBoxRecordType.error, stringWriter.toString());
                            }
                            boxWriter2.key("t").value((Object)"e");
                            StringWriter stringWriter = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(stringWriter));
                            stringWriter.flush();
                            boxWriter2.key("b").value((Object)stringWriter);
                        }
                        boxWriter2.endObject();
                        boxWriter.value((Object)boxWriter2);
                    }
                    ++n;
                }
                boxWriter.endArray().endObject();
                writer2.flush();
                if (!bl && !this.hasListeners) break block23;
                String string = ((StringWriter)writer2).toString();
                if (bl) {
                    try {
                        log.trace(BBoxService.makeLogMsg("Response - " + new JSONObject(string).toString(2), object));
                    }
                    catch (Exception exception) {
                        log.error(BBoxService.makeLogMsg("Response - " + string, object), (Throwable)exception);
                    }
                }
                if (this.hasListeners) {
                    this.notifyListeners((Context)object, BBoxRecordType.response, string);
                }
                writer.write(string);
            }
            catch (Exception exception) {
                if (this.hasListeners) {
                    StringWriter stringWriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringWriter));
                    this.notifyListeners((Context)object, BBoxRecordType.error, stringWriter.toString());
                }
                log.error(BBoxService.makeLogMsg("Processing Request", object), (Throwable)exception);
                throw exception;
            }
        }
    }

    private static final BoxWriter makeMessageWriter(String string, String string2, int n) throws JSONException {
        BoxWriter boxWriter = new BoxWriter();
        boxWriter.object();
        boxWriter.key("c").value((Object)string);
        boxWriter.key("k").value((Object)string2);
        boxWriter.key("r").value((long)n);
        return boxWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void registerListener(IBoxListener iBoxListener) {
        this.hasListeners = true;
        Array array = this.listeners;
        synchronized (array) {
            if (!this.listeners.contains((Object)iBoxListener)) {
                this.listeners.add((Object)iBoxListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unregisterListener(IBoxListener iBoxListener) {
        Array array = this.listeners;
        synchronized (array) {
            this.listeners.remove((Object)iBoxListener);
            boolean bl = false;
            if (this.listeners.size() == 0) {
                bl = true;
            }
            this.hasListeners = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void notifyListeners(Context context, BBoxRecordType bBoxRecordType, String string) {
        if (!this.hasListeners) return;
        String string2 = context.getUser() != null ? context.getUser().getName() : "";
        BAbsTime bAbsTime = BAbsTime.now();
        String string3 = context.getFacets().gets("remoteHost", "");
        int n = context.getFacets().geti("remotePort", -1);
        Array array = this.listeners;
        synchronized (array) {
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                try {
                    ((IBoxListener)this.listeners.get(n2)).newRecord(bAbsTime, bBoxRecordType, string2, string3, n, string);
                }
                catch (Throwable throwable) {
                    log.error("Notifying Listeners", throwable);
                }
                ++n2;
            }
            return;
        }
    }

    final boolean hasListeners() {
        return this.hasListeners;
    }

    static final String makeLogMsg(String string, Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(context.getUser() != null ? context.getUser().getName() : "");
        stringBuffer.append(" @ ");
        stringBuffer.append(context.getFacets().gets("remoteHost", ""));
        stringBuffer.append(" (");
        stringBuffer.append(context.getFacets().gets("remotePort", ""));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "box");
        String string = feature.get("session.limit", "none");
        this.sessionLimit = string.equals("none") ? -1 : Integer.parseInt(string);
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void incrementSessionCount() {
        Object object = sessionMonitor;
        synchronized (object) {
            ++this.sessionCount;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void decrementSessionCount() {
        Object object = sessionMonitor;
        synchronized (object) {
            --this.sessionCount;
            return;
        }
    }

    final int getSessionCount() {
        return this.sessionCount;
    }

    final int getSessionLimit() {
        return this.sessionLimit;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Session Limit");
        spyWriter.prop((Object)"Limit", (Object)(this.sessionLimit == -1 ? "none" : String.valueOf(this.sessionLimit)));
        spyWriter.prop((Object)"Active Count", this.sessionCount);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$box$BBoxService$IBoxListener;
        if (clazz == null) {
            clazz = class$com$tridium$box$BBoxService$IBoxListener = BBoxService.class("[Lcom.tridium.box.BBoxService$IBoxListener;", false);
        }
        this.listeners = new Array(clazz);
        this.hasListeners = false;
        this.sessionLimit = -1;
        this.sessionCount = 0;
    }

    public BBoxService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$box$BBoxService;
        if (clazz == null) {
            clazz = class$com$tridium$box$BBoxService = BBoxService.class("[Lcom.tridium.box.BBoxService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"box");
        icon = BIcon.std((String)"rectangle.png");
        sessionMonitor = new Object();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BoxContext
    extends BasicContext {
        private Map requestMap;

        public final Object get(Object object) {
            if (this.requestMap == null) {
                return null;
            }
            return this.requestMap.get(object);
        }

        public final void put(Object object, Object object2) {
            if (this.requestMap == null) {
                this.requestMap = new HashMap();
            }
            this.requestMap.put(object, object2);
        }

        public final BOrd getHomePage() {
            Context context = this.getBase();
            while (context != null) {
                if (context instanceof WebOp) break;
                context = context.getBase();
            }
            if (context != null && context instanceof WebOp) {
                WebOp webOp = (WebOp)context;
                return webOp.getWebEnv().getHomePage(webOp);
            }
            return this.getUser().getHomePage();
        }

        private final /* synthetic */ void this() {
            this.requestMap = null;
        }

        public BoxContext(Context context) {
            super(context);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BoxServiceFatalFaultException
    extends BoxCommsFailed {
        String getBsonErrorType() {
            return "BoxFatalFaultError";
        }

        public BoxServiceFatalFaultException(Context context) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("service.fatalFault", new Object[]{BBoxService.this.getFaultCause()}));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BoxServiceNonOperationalException
    extends BoxCommsFailed {
        String getBsonErrorType() {
            return "BoxNonOperationalError";
        }

        public BoxServiceNonOperationalException(Context context) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("service.notOperational"));
        }
    }

    static abstract class BoxCommsFailed
    extends Exception {
        abstract String getBsonErrorType();

        public BoxCommsFailed(String string) {
            super(string);
        }
    }

    public static interface IBoxListener {
        public void newRecord(BAbsTime var1, BBoxRecordType var2, String var3, String var4, int var5, String var6);
    }
}

