/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmRdb;

import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmRdb.BRdbAlarmDatabase;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

public class BRdbAlarmService
extends BAlarmService {
    public static final Property capacity = BRdbAlarmService.newProperty((int)4, (int)50000, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)1, (int)500000));
    public static final Property driver = BRdbAlarmService.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarmRdb:RdbmsFE")));
    public static final Property alarmTableName = BRdbAlarmService.newProperty((int)4, (String)"AlarmRecord", null);
    public static final Property schemaTableName = BRdbAlarmService.newProperty((int)4, (String)"schema_versions", null);
    public static final Property schemaVersion = BRdbAlarmService.newProperty((int)5, (int)-1, null);
    public static final Property initRdb = BRdbAlarmService.newProperty((int)4, (boolean)true, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$alarmRdb$BRdbAlarmService == null ? (class$javax$baja$alarmRdb$BRdbAlarmService = BRdbAlarmService.class$("javax.baja.alarmRdb.BRdbAlarmService")) : class$javax$baja$alarmRdb$BRdbAlarmService));
    static /* synthetic */ Class class$javax$baja$alarmRdb$BRdbAlarmService;

    public int getCapacity() {
        return this.getInt(capacity);
    }

    public void setCapacity(int n) {
        this.setInt(capacity, n, null);
    }

    public String getDriver() {
        return this.getString(driver);
    }

    public void setDriver(String string) {
        this.setString(driver, string, null);
    }

    public String getAlarmTableName() {
        return this.getString(alarmTableName);
    }

    public void setAlarmTableName(String string) {
        this.setString(alarmTableName, string, null);
    }

    public String getSchemaTableName() {
        return this.getString(schemaTableName);
    }

    public void setSchemaTableName(String string) {
        this.setString(schemaTableName, string, null);
    }

    public int getSchemaVersion() {
        return this.getInt(schemaVersion);
    }

    public void setSchemaVersion(int n) {
        this.setInt(schemaVersion, n, null);
    }

    public boolean getInitRdb() {
        return this.getBoolean(initRdb);
    }

    public void setInitRdb(boolean bl) {
        this.setBoolean(initRdb, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BAlarmDatabase createAlarmDb() {
        try {
            return new BRdbAlarmDatabase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changed(Property property, Context context) {
        if (property.equals(capacity)) {
            BAlarmDatabase bAlarmDatabase = this.getAlarmDb();
            if (bAlarmDatabase != null && !(bAlarmDatabase instanceof BRdbAlarmDatabase)) return;
        }
        if (property.equals(driver)) {
            if (!Sys.isStationStarted()) {
                super.changed(property, context);
                return;
            }
            BAlarmDatabase bAlarmDatabase = this.getAlarmDb();
            if (bAlarmDatabase == null || !(bAlarmDatabase instanceof BRdbAlarmDatabase)) return;
            try {
                this.serviceStopped();
                this.serviceStarted();
                return;
            }
            catch (Exception exception) {
                logger.error("Cannot change database driver to " + this.getDriver() + ".", (Throwable)exception);
            }
            return;
        } else {
            super.changed(property, context);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

