/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial;

import com.tridium.sms.BAbstractSmsTransport;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.BSmsService;
import com.tridium.sms.SmsException;
import com.tridium.sms.serial.CommTransaction;
import com.tridium.sms.serial.SmsCommReceiver;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.serial.command.SmsDeleteMessageCommand;
import com.tridium.sms.serial.command.SmsPingCommand;
import com.tridium.sms.serial.command.SmsReadMessagesCommand;
import com.tridium.sms.serial.command.SmsSendMsgCommand;
import com.tridium.sms.serial.command.SmsSignalStrengthCommand;
import com.tridium.sms.serial.command.SmsStartupCheckCommand;
import com.tridium.sms.util.SmsToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSerialSmsTransport
extends BAbstractSmsTransport
implements BISerialHelperParent,
SmsCommand.ICommsImplementer {
    public static final Property serialPortConfig = BSerialSmsTransport.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property responseTimeout = BSerialSmsTransport.newProperty((int)4, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property interMessageDelay = BSerialSmsTransport.newProperty((int)0, (BValue)BRelTime.make((long)10L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property deleteReadMessages = BSerialSmsTransport.newProperty((int)0, (boolean)true, null);
    public static final Action runStartupCommands = BSerialSmsTransport.newAction((int)20, null);
    public static final Type TYPE;
    private static final String CHAR_ENCODING = "ISO-8859-1";
    private BISerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private Thread rxThread;
    private boolean active;
    private SmsCommReceiver commReceiver;
    static /* synthetic */ Class class$com$tridium$sms$serial$BSerialSmsTransport;

    public final BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public final void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public final BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public final void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public final BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public final void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public final boolean getDeleteReadMessages() {
        return this.getBoolean(deleteReadMessages);
    }

    public final void setDeleteReadMessages(boolean bl) {
        this.setBoolean(deleteReadMessages, bl, null);
    }

    public final void runStartupCommands() {
        this.invoke(runStartupCommands, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void send(String string, String string2) throws SmsException {
        SmsSendMsgCommand smsSendMsgCommand = new SmsSendMsgCommand(this, string, string2);
        if (!smsSendMsgCommand.run()) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsSendMsgCommand);
        }
    }

    public final void ping() throws SmsException {
        SmsPingCommand smsPingCommand = new SmsPingCommand(this);
        if (!smsPingCommand.run()) {
            this.reopenPort();
            smsPingCommand = new SmsPingCommand(this);
            if (!smsPingCommand.run()) {
                throw new SmsException(SmsToolkit.getText("service.pingFailed"));
            }
        }
    }

    public final double getSignalStrength() throws SmsException {
        double d = -1.0;
        SmsSignalStrengthCommand smsSignalStrengthCommand = new SmsSignalStrengthCommand(this);
        boolean bl = smsSignalStrengthCommand.run();
        if (!bl) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsSignalStrengthCommand);
        }
        d = smsSignalStrengthCommand.getSignalStrength();
        return d;
    }

    private final BSmsService getService() {
        return (BSmsService)this.getParent();
    }

    public final void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public final void stationStarted() throws Exception {
        this.init();
    }

    private final void init() {
        this.reopenPort();
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("Sms async thread started");
        }
    }

    public final void stopped() {
        this.stopComm();
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("Sms async thread stopped");
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        this.getService().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public final synchronized void reopenPort() {
        if (!this.getService().isFatalFault()) {
            String string;
            if (SmsToolkit.log.isTraceOn()) {
                SmsToolkit.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            if ((string = this.getSerialPortConfig().getPortName()).equals("none")) {
                this.getService().pingFail(SmsToolkit.getText("transport.noPortSelected"));
                this.stopComm();
            } else {
                this.stopComm();
                this.startComm();
            }
        }
    }

    private final synchronized void startComm() {
        try {
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = this.getSerialPortConfig().open(this.getService().getName());
            this.serialPort.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
            this.commReceiver.setInputStream(this.in);
            this.commReceiver.setCancelled(false);
            this.rxThread = new Thread((Runnable)this.commReceiver, "SerialRcv:" + this.getService().getName());
            this.rxThread.start();
            this.active = true;
            this.runStartupCommands();
            if (SmsToolkit.log.isTraceOn()) {
                SmsToolkit.log.trace("Started comms and read thread");
            }
        }
        catch (Exception exception) {
            this.active = false;
            try {
                if (this.in != null) {
                    try {
                        this.in.close();
                        this.in = null;
                    }
                    catch (Exception exception2) {
                        SmsToolkit.log.error("Unable to close serial input stream.", (Throwable)exception2);
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                        this.out = null;
                    }
                    catch (Exception exception3) {
                        SmsToolkit.log.error("Unable to close serial output stream.", (Throwable)exception3);
                    }
                }
                if (this.serialPort != null) {
                    this.serialPort.close();
                    this.serialPort = null;
                }
            }
            catch (Exception exception4) {
                SmsToolkit.log.error("Fatal error shutting down serial port objects on start up!", (Throwable)exception4);
            }
            SmsToolkit.log.error("Error starting the serial port", (Throwable)exception);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    private final synchronized void stopComm() {
        this.active = false;
        try {
            if (this.rxThread != null) {
                this.commReceiver.setCancelled(true);
                this.rxThread.join();
                this.rxThread = null;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception exception) {
                    SmsToolkit.log.error("Unable to close serial input stream.", (Throwable)exception);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (Exception exception) {
                    SmsToolkit.log.error("Unable to close serial output stream.", (Throwable)exception);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
                this.serialPort = null;
            }
        }
        catch (Exception exception) {
            SmsToolkit.log.error("Error stopping the serial port", (Throwable)exception);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    public final synchronized boolean isCommsActive() {
        return this.active;
    }

    public final void doRunStartupCommands() {
        if (!this.getService().isDisabled() && !this.getService().isFatalFault()) {
            SmsStartupCheckCommand smsStartupCheckCommand = new SmsStartupCheckCommand(this);
            if (smsStartupCheckCommand.run()) {
                this.getService().pingOk();
            } else {
                this.getService().pingFail(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsStartupCheckCommand);
            }
        }
    }

    public final String write(String string, String string2) throws IOException {
        return this.write(string, string2, this.getResponseTimeout());
    }

    public final synchronized String write(String string, String string2, BRelTime bRelTime) throws IOException {
        if (this.out != null && this.rxThread != null && this.isRunning()) {
            CommTransaction commTransaction;
            block7: {
                long l;
                if (SmsToolkit.log.isTraceOn()) {
                    SmsToolkit.log.trace("*** Writing: " + this.removeNewLines(string) + " attempting read: " + this.removeNewLines(string2) + " ***");
                }
                commTransaction = new CommTransaction(string2);
                this.commReceiver.setTransaction(commTransaction);
                this.out.write(string.getBytes(CHAR_ENCODING));
                this.out.flush();
                int n = 0;
                while (!commTransaction.isCompleted()) {
                    if ((long)(n += commTransaction.waitForTransaction()) >= bRelTime.getMillis()) break;
                }
                if ((l = this.getInterMessageDelay().getMillis()) > 0L) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!SmsToolkit.log.isTraceOn()) break block7;
                        SmsToolkit.log.trace("Interrupt exception thrown for write");
                    }
                }
            }
            if (commTransaction.isCompleted()) {
                return commTransaction.getRecStr();
            }
            throw new IOException("Sms command error! Did not get message!");
        }
        throw new IOException("Sms serial not open!");
    }

    private final String removeNewLines(String string) {
        return string.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
    }

    public final BSmsMessage[] readMessages() throws SmsException {
        BSmsMessage[] bSmsMessageArray = new BSmsMessage[]{};
        if (!(this.getService().isDisabled() || this.getService().isFatalFault() || this.getService().isDown())) {
            SmsReadMessagesCommand smsReadMessagesCommand = new SmsReadMessagesCommand(this);
            if (smsReadMessagesCommand.run()) {
                bSmsMessageArray = smsReadMessagesCommand.getMessages();
                if (this.getDeleteReadMessages()) {
                    int n = 0;
                    while (n < bSmsMessageArray.length) {
                        this.deleteMessage(bSmsMessageArray[n].getId());
                        ++n;
                    }
                }
            } else {
                throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsReadMessagesCommand);
            }
        }
        return bSmsMessageArray;
    }

    private final void deleteMessage(int n) throws SmsException {
        SmsDeleteMessageCommand smsDeleteMessageCommand = new SmsDeleteMessageCommand(this, n);
        if (!smsDeleteMessageCommand.run()) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsDeleteMessageCommand);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serialPort = null;
        this.in = null;
        this.out = null;
        this.rxThread = null;
        this.active = false;
        this.commReceiver = new SmsCommReceiver();
    }

    public BSerialSmsTransport() {
        this.this();
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
    }

    static {
        Class clazz = class$com$tridium$sms$serial$BSerialSmsTransport;
        if (clazz == null) {
            clazz = class$com$tridium$sms$serial$BSerialSmsTransport = BSerialSmsTransport.class("[Lcom.tridium.sms.serial.BSerialSmsTransport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

