/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.gprs;

import com.tridium.sms.BAbstractSmsTransport;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.BSmsService;
import com.tridium.sms.SmsException;
import com.tridium.sms.gprs.GprsCommReceiver;
import com.tridium.sms.gprs.GprsCommTransaction;
import com.tridium.sms.gprs.command.GprsSmsSendMsgCommand;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.serial.command.SmsDeleteMessageCommand;
import com.tridium.sms.serial.command.SmsPingCommand;
import com.tridium.sms.serial.command.SmsReadMessagesCommand;
import com.tridium.sms.serial.command.SmsSignalStrengthCommand;
import com.tridium.sms.serial.command.SmsStartupCheckCommand;
import com.tridium.sms.util.SmsToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BGprsSmsTransport
extends BAbstractSmsTransport
implements BISerialHelperParent,
SmsCommand.ICommsImplementer {
    public static final Property responseTimeout = BGprsSmsTransport.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)8), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE));
    public static final Property smsWriteResponseTimeout = BGprsSmsTransport.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE));
    public static final Property interMessageDelay = BGprsSmsTransport.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)30)));
    public static final Property deleteReadMessages = BGprsSmsTransport.newProperty((int)0, (boolean)true, null);
    public static final Action runStartupCommands = BGprsSmsTransport.newAction((int)20, null);
    public static final Type TYPE;
    private static final String CHAR_ENCODING = "ISO-8859-1";
    private InputStream in;
    private OutputStream out;
    private Thread rxThread;
    private boolean active;
    private String gprsPort;
    private GprsCommReceiver commReceiver;
    static /* synthetic */ Class class$com$tridium$sms$gprs$BGprsSmsTransport;

    public final BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public final void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public final BRelTime getSmsWriteResponseTimeout() {
        return (BRelTime)this.get(smsWriteResponseTimeout);
    }

    public final void setSmsWriteResponseTimeout(BRelTime bRelTime) {
        this.set(smsWriteResponseTimeout, (BValue)bRelTime, null);
    }

    public final BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public final void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public final boolean getDeleteReadMessages() {
        return this.getBoolean(deleteReadMessages);
    }

    public final void setDeleteReadMessages(boolean bl) {
        this.setBoolean(deleteReadMessages, bl, null);
    }

    public final void runStartupCommands() {
        this.invoke(runStartupCommands, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void send(String string, String string2) throws SmsException {
        GprsSmsSendMsgCommand gprsSmsSendMsgCommand = new GprsSmsSendMsgCommand(this, string, string2);
        if (!gprsSmsSendMsgCommand.run()) {
            throw new SmsException(SmsToolkit.getText("gprsSmsTransport.commandFailed") + ": " + gprsSmsSendMsgCommand);
        }
    }

    public final void ping() throws SmsException {
        SmsPingCommand smsPingCommand = new SmsPingCommand(this);
        if (!smsPingCommand.run()) {
            this.reopenPort();
            smsPingCommand = new SmsPingCommand(this);
            if (!smsPingCommand.run()) {
                throw new SmsException(SmsToolkit.getText("service.pingFailed"));
            }
        }
    }

    public final double getSignalStrength() throws SmsException {
        double d = -1.0;
        SmsSignalStrengthCommand smsSignalStrengthCommand = new SmsSignalStrengthCommand(this);
        boolean bl = smsSignalStrengthCommand.run();
        if (!bl) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsSignalStrengthCommand);
        }
        d = smsSignalStrengthCommand.getSignalStrength();
        return d;
    }

    private final BSmsService getService() {
        return (BSmsService)this.getParent();
    }

    public final void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public final void stationStarted() throws Exception {
        this.init();
    }

    private final void init() {
        this.reopenPort();
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("Sms async thread started");
        }
    }

    public final void stopped() {
        this.stopComm();
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("Sms async thread stopped");
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        this.getService().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public final synchronized void reopenPort() {
        if (!this.getService().isFatalFault()) {
            if (SmsToolkit.log.isTraceOn()) {
                SmsToolkit.log.trace(this.getName() + " *** Restarting gprs comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    private final synchronized void startComm() {
        try {
            File file = new File(this.gprsPort);
            this.in = new FileInputStream(file);
            Thread.sleep(2000L);
            this.out = new FileOutputStream(file);
            Thread.sleep(2000L);
            this.commReceiver.setInputStream(this.in);
            this.commReceiver.setCancelled(false);
            this.rxThread = new Thread((Runnable)this.commReceiver, "GprsRcv:" + this.getService().getName());
            this.rxThread.start();
            this.active = true;
            this.runStartupCommands();
            if (SmsToolkit.log.isTraceOn()) {
                SmsToolkit.log.trace("Started comms and read thread");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            SmsToolkit.log.error("Unable to find /dev/gprs/sms device", (Throwable)fileNotFoundException);
            this.getService().pingFail("Unable to find /dev/gprs/sms device");
        }
        catch (Exception exception) {
            this.active = false;
            try {
                if (this.in != null) {
                    try {
                        this.in.close();
                        this.in = null;
                    }
                    catch (Exception exception2) {
                        SmsToolkit.log.error("Unable to close gprs input stream.", (Throwable)exception2);
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                        this.out = null;
                    }
                    catch (Exception exception3) {
                        SmsToolkit.log.error("Unable to close gprs output stream.", (Throwable)exception3);
                    }
                }
            }
            catch (Exception exception4) {
                SmsToolkit.log.error("Fatal error shutting down gprs sms object on start up!", (Throwable)exception4);
            }
            SmsToolkit.log.error("Error starting the gprs transport", (Throwable)exception);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    private final synchronized void stopComm() {
        this.active = false;
        try {
            if (this.rxThread != null) {
                this.commReceiver.setCancelled(true);
                this.rxThread.join();
                this.rxThread = null;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception exception) {
                    SmsToolkit.log.error("Unable to close gprs input stream.", (Throwable)exception);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (Exception exception) {
                    SmsToolkit.log.error("Unable to close gprs output stream.", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            SmsToolkit.log.error("Error stopping the gprs port", (Throwable)exception);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    public final synchronized boolean isCommsActive() {
        return this.active;
    }

    public final void doRunStartupCommands() {
        if (!this.getService().isDisabled() && !this.getService().isFatalFault()) {
            SmsStartupCheckCommand smsStartupCheckCommand = new SmsStartupCheckCommand(this);
            if (smsStartupCheckCommand.run()) {
                this.getService().pingOk();
            } else {
                this.getService().pingFail(SmsToolkit.getText("gprsSmsTransport.commandFailed") + ": " + smsStartupCheckCommand);
            }
        }
    }

    public final String write(String string, String string2) throws IOException {
        return this.write(string, string2, this.getResponseTimeout());
    }

    public final synchronized String write(String string, String string2, BRelTime bRelTime) throws IOException {
        if (this.out != null && this.rxThread != null && this.isRunning()) {
            GprsCommTransaction gprsCommTransaction;
            block7: {
                long l;
                if (SmsToolkit.log.isTraceOn()) {
                    SmsToolkit.log.trace("*** Writing: " + this.removeNewLines(string) + " looking for response: " + this.removeNewLines(string2) + " ***");
                }
                gprsCommTransaction = new GprsCommTransaction(string2);
                this.commReceiver.setTransaction(gprsCommTransaction);
                this.out.write(string.getBytes(CHAR_ENCODING));
                this.out.flush();
                int n = 0;
                while (!gprsCommTransaction.isCompleted()) {
                    if ((long)(n += gprsCommTransaction.waitForTransaction()) >= bRelTime.getMillis()) break;
                }
                if ((l = this.getInterMessageDelay().getMillis()) > 0L) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!SmsToolkit.log.isTraceOn()) break block7;
                        SmsToolkit.log.trace("Interrupt exception thrown for write");
                    }
                }
            }
            if (gprsCommTransaction.isCompleted()) {
                SmsToolkit.log.trace("*** Read complete: " + this.removeNewLines(gprsCommTransaction.getRecStr()) + " ***");
                return gprsCommTransaction.getRecStr();
            }
            SmsToolkit.log.trace("*** Read failed: " + this.removeNewLines(gprsCommTransaction.getRecStr()) + " ***");
            throw new IOException("Sms command error! Did not get message!");
        }
        throw new IOException("Sms serial not open!");
    }

    private final String removeNewLines(String string) {
        return string.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
    }

    public final BSmsMessage[] readMessages() throws SmsException {
        BSmsMessage[] bSmsMessageArray = new BSmsMessage[]{};
        if (!(this.getService().isDisabled() || this.getService().isFatalFault() || this.getService().isDown())) {
            SmsReadMessagesCommand smsReadMessagesCommand = new SmsReadMessagesCommand(this);
            if (smsReadMessagesCommand.run()) {
                bSmsMessageArray = smsReadMessagesCommand.getMessages();
                if (this.getDeleteReadMessages()) {
                    int n = 0;
                    while (n < bSmsMessageArray.length) {
                        this.deleteMessage(bSmsMessageArray[n].getId());
                        ++n;
                    }
                }
            } else {
                throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsReadMessagesCommand);
            }
        }
        return bSmsMessageArray;
    }

    private final void deleteMessage(int n) throws SmsException {
        SmsDeleteMessageCommand smsDeleteMessageCommand = new SmsDeleteMessageCommand(this, n);
        if (!smsDeleteMessageCommand.run()) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + smsDeleteMessageCommand);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.in = null;
        this.out = null;
        this.rxThread = null;
        this.active = false;
        this.gprsPort = "/dev/gprs/sms";
        this.commReceiver = new GprsCommReceiver();
    }

    public BGprsSmsTransport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sms$gprs$BGprsSmsTransport;
        if (clazz == null) {
            clazz = class$com$tridium$sms$gprs$BGprsSmsTransport = BGprsSmsTransport.class("[Lcom.tridium.sms.gprs.BGprsSmsTransport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

