/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.table.BTable;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;

public abstract class TreeTableNode {
    TreeTableModel model;
    TreeTableNode parent;
    boolean expanded;
    int index;
    int depth;

    public BTreeTable getTable() {
        return (BTreeTable)this.model.getTable();
    }

    public TreeTableModel getModel() {
        return this.model;
    }

    public BWidgetShell getShell() {
        BTable bTable = this.model.getTable();
        if (bTable != null) {
            return bTable.getShell();
        }
        return null;
    }

    public boolean isGroup() {
        return false;
    }

    public abstract Object getValueAt(int var1);

    public Object getSubject() {
        return this.getValueAt(0);
    }

    public BImage getIcon() {
        return null;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean hasChildren() {
        boolean bl = false;
        if (this.getChildCount() != 0) {
            bl = true;
        }
        return bl;
    }

    public int getChildCount() {
        return 0;
    }

    public TreeTableNode getChild(int n) {
        throw new UnsupportedOperationException();
    }

    public int getChildIndex(TreeTableNode treeTableNode) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getChild(n2) == treeTableNode) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isDescendantOf(TreeTableNode treeTableNode) {
        TreeTableNode treeTableNode2 = this.getParent();
        while (treeTableNode2 != null && treeTableNode2 != treeTableNode) {
            treeTableNode2 = treeTableNode2.getParent();
        }
        boolean bl = false;
        if (treeTableNode2 == treeTableNode) {
            bl = true;
        }
        return bl;
    }

    public TreeTableNode[] getPathFromRoot() {
        ArrayList<TreeTableNode> arrayList = new ArrayList<TreeTableNode>(4);
        arrayList.add(this);
        TreeTableNode treeTableNode = this.getParent();
        while (treeTableNode != null) {
            arrayList.add(treeTableNode);
            treeTableNode = treeTableNode.getParent();
        }
        int n = arrayList.size();
        TreeTableNode[] treeTableNodeArray = new TreeTableNode[n];
        int n2 = 0;
        while (n2 < n) {
            treeTableNodeArray[n2] = (TreeTableNode)arrayList.get(n - n2 - 1);
            ++n2;
        }
        return treeTableNodeArray;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.expanded = bl;
            if (this.expanded) {
                this.expanded();
            } else {
                this.collapsed();
            }
            boolean bl2 = bl;
            this.getModel().updateTreeTable(bl2);
        }
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public void expanded() {
    }

    public void collapsed() {
    }

    public TreeTableNode(TreeTableModel treeTableModel) {
        if (treeTableModel == null) {
            throw new NullPointerException("null model");
        }
        this.model = treeTableModel;
        this.parent = null;
        this.depth = 0;
    }

    public TreeTableNode(TreeTableNode treeTableNode) {
        if (treeTableNode.model == null) {
            throw new NullPointerException("null model");
        }
        this.model = treeTableNode.model;
        this.parent = treeTableNode;
        this.depth = treeTableNode.depth + 1;
    }
}

