/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import javax.baja.sys.BValue;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;

public class TreeTableController
extends TableController {
    public final BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public final TreeTableModel getTreeTableModel() {
        return ((BTreeTable)this.getTable()).model;
    }

    public void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        TreeTableNode treeTableNode = treeTableModel.rowToNode(n);
        if (n2 == 0 || treeTableNode != null && treeTableNode.isGroup()) {
            TreeTableTheme treeTableTheme = Theme.treeTable();
            int n3 = treeTableNode.getDepth();
            double d = treeTableTheme.getIndent(n3);
            double d2 = d - 1.0;
            double d3 = d + treeTableTheme.getExpanderWidth() + 1.0;
            double d4 = bMouseEvent.getX();
            if (d2 <= d4 && d4 <= d3 && treeTableModel.isDepthExpandable(n3) && treeTableNode.hasChildren()) {
                int[] nArray = this.getSelection().getRows();
                int n4 = treeTableNode.getChildCount();
                int n5 = treeTableNode.isExpanded() ? -n4 : n4;
                this.getSelection().deselectAll();
                treeTableNode.setExpanded(treeTableNode.isExpanded() ^ true);
                int n6 = 0;
                while (n6 < nArray.length) {
                    if (nArray[n6] > n) {
                        this.getSelection().select(nArray[n6] + n5);
                    } else {
                        this.getSelection().select(nArray[n6]);
                    }
                    ++n6;
                }
                return;
            }
        }
        super.cellPressed(bMouseEvent, n, n2);
    }

    protected BMenu makeOptionsMenu() {
        BTable bTable = this.getTable();
        TableModel tableModel = this.getModel();
        BMenu bMenu = new BMenu();
        bMenu.add("resizeColumns", new TableController.ResizeColumnsCommand(bTable));
        bMenu.add("export", new TableController.ExportCommand(bTable));
        if (tableModel instanceof DynamicTreeTableModel) {
            DynamicTreeTableModel dynamicTreeTableModel = (DynamicTreeTableModel)tableModel;
            bMenu.add("showSep", (BValue)new BSeparator());
            int n = 0;
            int n2 = 0;
            while (n2 < dynamicTreeTableModel.getRootColumnCount()) {
                if (dynamicTreeTableModel.isColumnShowable(n2)) {
                    bMenu.add(null, new ShowColumnCommand(dynamicTreeTableModel, n2));
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                bMenu.remove("showSep");
            }
        }
        return bMenu;
    }

    protected final BMenu makePopup(TableSubject tableSubject) {
        return this.makePopup((TreeTableSubject)tableSubject);
    }

    protected BMenu makePopup(TreeTableSubject treeTableSubject) {
        return null;
    }

    protected void headerPopup(BMouseEvent bMouseEvent, int n) {
        DynamicTreeTableModel dynamicTreeTableModel;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof DynamicTreeTableModel && (dynamicTreeTableModel = (DynamicTreeTableModel)tableModel).isColumnShowable(n = dynamicTreeTableModel.toRootColumnIndex(n))) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, new HideColumnCommand(dynamicTreeTableModel, n));
            bMenu.open(this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ShowColumnCommand
    extends ToggleCommand {
        DynamicTreeTableModel model;
        int column;

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.model.setShowColumn(this.column, bl);
        }

        ShowColumnCommand(DynamicTreeTableModel dynamicTreeTableModel, int n) {
            super(dynamicTreeTableModel.getTable(), dynamicTreeTableModel.getRootColumnName(n));
            this.model = dynamicTreeTableModel;
            this.column = n;
            this.setSelected(dynamicTreeTableModel.showColumn(n));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HideColumnCommand
    extends Command {
        DynamicTreeTableModel model;
        int column;

        public CommandArtifact doInvoke() {
            this.model.setShowColumn(this.column, false);
            return null;
        }

        HideColumnCommand(DynamicTreeTableModel dynamicTreeTableModel, int n) {
            super((BWidget)dynamicTreeTableModel.getTable(), UiLexicon.bajaui().module, "commands.table.hideColumn");
            this.model = dynamicTreeTableModel;
            this.column = n;
        }
    }
}

