/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreeTableCellRenderer
extends TableCellRenderer {
    private RectGeom clip;

    public final BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public final TreeTableModel getTreeTableModel() {
        return ((BTreeTable)this.getTable()).model;
    }

    public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
        double d = super.getPreferredCellWidth(cell);
        if (cell.column == 0) {
            TreeTableTheme treeTableTheme = Theme.treeTable();
            TreeTableModel treeTableModel = this.getTreeTableModel();
            TreeTableNode treeTableNode = treeTableModel.rowToNode(cell.row);
            if (treeTableNode.isGroup()) {
                return 0.0;
            }
            int n = treeTableNode.getDepth();
            d += treeTableTheme.getIndent(n);
            if (treeTableModel.isDepthExpandable(n)) {
                d += treeTableTheme.getExpanderWidth() + (double)5;
            }
        }
        return d;
    }

    public IGeom getClip(TableCellRenderer.Cell cell) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        TreeTableNode treeTableNode = treeTableModel.rowToNode(cell.row);
        if (treeTableNode.isGroup()) {
            if (cell.column == 0) {
                double d = this.getTable().getWidth() - this.getTable().getVscrollBar().getWidth();
                this.clip.set(0.0, 0.0, d - 1.0, cell.height);
                return this.clip;
            }
            this.clip.set(0.0, 0.0, 0.0, 0.0);
            return this.clip;
        }
        return super.getClip(cell);
    }

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        return Theme.treeTable().getTextBrush();
    }

    public BBrush getBackground(TableCellRenderer.Cell cell) {
        if (this.getTreeTableModel().rowToNode(cell.row).isGroup()) {
            return Theme.treeTable().getGroupBackground();
        }
        return super.getBackground(cell);
    }

    public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
        String string;
        BImage bImage;
        double d;
        TreeTableTheme treeTableTheme = Theme.treeTable();
        TreeTableModel treeTableModel = this.getTreeTableModel();
        TreeTableNode treeTableNode = treeTableModel.rowToNode(cell.row);
        int n = treeTableNode.getDepth();
        boolean bl = treeTableNode.isGroup();
        if (cell.column > 0) {
            if (!bl) {
                super.paintCell(graphics, cell);
                this.paintVerticalLine(graphics, cell);
            }
            return;
        }
        if (bl) {
            double d2;
            cell.width = d2 = this.getTable().getWidth() - this.getTable().getVscrollBar().getWidth();
        }
        this.paintCellBackground(graphics, cell);
        BBrush bBrush = graphics.getBrush();
        double d3 = treeTableTheme.getIndent(n);
        if (treeTableModel.isDepthExpandable(n)) {
            if (treeTableNode.hasChildren()) {
                int n2 = treeTableNode.isExpanded() + 1;
                d = (cell.height - treeTableTheme.getExpanderHeight()) / (double)2;
                treeTableTheme.paintExpander(graphics, d3, d, cell.selected, n2, bl);
            }
            d3 += treeTableTheme.getExpanderWidth() + (double)5;
        }
        if ((bImage = treeTableModel.getRowIcon(cell.row)) != null) {
            d = (cell.height - 16.0) / (double)2;
            graphics.drawImage(bImage, d3, d);
            d3 += 18.0;
        }
        if ((string = this.getCellText(cell)) != null && string.length() > 0) {
            BFont bFont = this.getFont(cell);
            graphics.setBrush(bBrush);
            graphics.setFont(bFont);
            graphics.drawString(string, d3, (cell.height + bFont.getAscent() - bFont.getDescent()) / (double)2);
        }
        if (!bl) {
            this.paintVerticalLine(graphics, cell);
        }
    }

    public void paintVerticalLine(Graphics graphics, TableCellRenderer.Cell cell) {
        BTable bTable = this.getTable();
        if (!bTable.getVgridVisible()) {
            return;
        }
        BBrush bBrush = this.getTable().getGridBrush();
        if (bBrush.isNull()) {
            bBrush = Theme.table().getGridBrush();
        }
        graphics.setBrush(bBrush);
        graphics.strokeLine(cell.width - 1.0, 0.0, cell.width - 1.0, cell.height);
    }

    private final /* synthetic */ void this() {
        this.clip = new RectGeom();
    }

    public TreeTableCellRenderer() {
        this.this();
    }
}

