/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;

public class TreeNodeRenderer
extends BTree.TreeSupport {
    private static final double ICON_WIDTH = 16.0;
    private static final double ICON_HEIGHT = 16.0;
    private static final double MARGIN = 4.0;
    private BImage defaultIcon;
    private RectGeom nodeBounds;
    private RectGeom textBounds;
    private RectGeom focusBounds;

    public BImage getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = BImage.make((String)"module://icons/x16/folder.png");
        }
        return this.defaultIcon;
    }

    public BImage getIcon(TreeNode treeNode) {
        return treeNode.getIcon();
    }

    public void setDefaultIcon(BImage bImage) {
        this.defaultIcon = bImage;
    }

    public BBrush getForeground(TreeNode treeNode) {
        return Theme.tree().getForeground(this.getTree());
    }

    public BBrush getBackground(TreeNode treeNode) {
        return null;
    }

    public BBrush getSelectionForeground(TreeNode treeNode) {
        return Theme.tree().getSelectionForeground();
    }

    public BBrush getSelectionBackground(TreeNode treeNode) {
        return Theme.tree().getSelectionBackground();
    }

    public double getWidth(TreeNode treeNode) {
        return 20.0 + this.getTextFont().width(TreeNodeRenderer.getNodeText(treeNode)) + (double)2;
    }

    public double getHeight() {
        BFont bFont = this.getTextFont();
        double d = bFont.getAscent() + bFont.getDescent();
        double d2 = Theme.tree().getExpanderHeight() + Theme.tree().getInsets().top + Theme.tree().getInsets().bottom + (double)2;
        return Math.max(Math.max(16.0, d2), d - 1.0);
    }

    public double getIconWidth() {
        return 16.0;
    }

    public double getIconHeight() {
        return 16.0;
    }

    public static String getNodeText(TreeNode treeNode) {
        String string = treeNode.getText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public BFont getTextFont() {
        return Theme.tree().getFont(this.getTree());
    }

    public void paintNode(Graphics graphics, TreeNode treeNode, double d, double d2) {
        BImage bImage;
        boolean bl = treeNode.getTree().hasFocus();
        BFont bFont = this.getTextFont();
        graphics.setFont(bFont);
        String string = TreeNodeRenderer.getNodeText(treeNode);
        double d3 = this.getHeight();
        double d4 = d2 + (d3 - 16.0) / (double)2;
        double d5 = d2 + (d3 - bFont.getAscent()) / (double)2 + bFont.getAscent() - 1.0;
        double d6 = d + 16.0 + (double)4;
        BBrush bBrush = this.getBackground(treeNode);
        boolean bl2 = treeNode.isSelected();
        boolean bl3 = treeNode.hasFocus();
        double d7 = -1.0;
        if (bl2 || bl && bl3) {
            d7 = bFont.width(string);
        }
        if (!bl2 && bBrush != null) {
            if (this.nodeBounds == null) {
                this.nodeBounds = new RectGeom(d, d2, this.getWidth(treeNode), this.getHeight());
            } else {
                this.nodeBounds.set(d, d2, this.getWidth(treeNode), this.getHeight());
            }
            graphics.setBrush(bBrush);
            graphics.fillRect(this.nodeBounds.x, this.nodeBounds.y, this.nodeBounds.width, this.nodeBounds.height);
        }
        if ((bImage = this.getIcon(treeNode)) == null) {
            bImage = this.getDefaultIcon();
        }
        if (bImage != null) {
            graphics.drawImage(bImage, d, d4);
        }
        if (bl2) {
            if (this.textBounds == null) {
                this.textBounds = new RectGeom(d6 - (double)2, d2 + 1.0, d7 + (double)4, d3 - (double)2);
            } else {
                this.textBounds.set(d6 - (double)2, d2 + 1.0, d7 + (double)4, d3 - (double)2);
            }
            graphics.setBrush(this.getSelectionBackground(treeNode));
            graphics.fillRect(this.textBounds.x, this.textBounds.y, this.textBounds.width, this.textBounds.height);
        }
        if (bl && bl3) {
            if (this.focusBounds == null) {
                this.focusBounds = new RectGeom(d6 - (double)3, d2, d7 + (double)5, d3 - 1.0);
            } else {
                this.focusBounds.set(d6 - (double)3, d2, d7 + (double)5, d3 - 1.0);
            }
            Theme.tree().paintFocus(graphics, this.focusBounds);
        }
        if (bl2) {
            graphics.setBrush(this.getSelectionForeground(treeNode));
        } else {
            graphics.setBrush(this.getForeground(treeNode));
        }
        graphics.drawString(string, d6, d5);
    }
}

