/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTheme;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNodeRenderer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TreeNode {
    private static final double MARGIN = 4.0;
    private TreeModel model;
    private TreeNode parent;
    private double x;
    private double y;
    private boolean isTop;
    private boolean isLast;
    private double height;
    private double expanderX;
    private double expanderWidth;
    private double expanderY;
    private double expanderHeight;
    private double nodeX;
    private double nodeY;
    private boolean expanded;
    private boolean selected;
    private boolean focus;

    public TreeModel getModel() {
        TreeNode treeNode;
        if (this.model == null && (treeNode = this.getParent()) != null) {
            this.model = treeNode.getModel();
        }
        return this.model;
    }

    public BTree getTree() {
        return this.getModel().getTree();
    }

    public BWidgetShell getShell() {
        BTree bTree = this.getTree();
        if (bTree != null) {
            return bTree.getShell();
        }
        return null;
    }

    public abstract String getText();

    public String toString() {
        return this.getText();
    }

    public abstract BImage getIcon();

    public boolean isLeaf() {
        return this.hasChildren() ^ true;
    }

    public boolean hasChildren() {
        boolean bl = false;
        if (this.getChildCount() != 0) {
            bl = true;
        }
        return bl;
    }

    public abstract int getChildCount();

    public abstract TreeNode getChild(int var1);

    public int getChildIndex(TreeNode treeNode) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getChild(n2) == treeNode) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object getSubject() {
        return this.getText();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isDescendantOf(TreeNode treeNode) {
        TreeNode treeNode2 = this.getParent();
        while (treeNode2 != null && treeNode2 != treeNode) {
            treeNode2 = treeNode2.getParent();
        }
        boolean bl = false;
        if (treeNode2 == treeNode) {
            bl = true;
        }
        return bl;
    }

    public TreeNode[] getPathFromRoot() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(4);
        arrayList.add(this);
        TreeNode treeNode = this.getParent();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        int n = arrayList.size();
        TreeNode[] treeNodeArray = new TreeNode[n];
        int n2 = 0;
        while (n2 < n) {
            treeNodeArray[n2] = (TreeNode)arrayList.get(n - n2 - 1);
            ++n2;
        }
        return treeNodeArray;
    }

    public boolean isValid() {
        TreeNode treeNode = this;
        TreeNode treeNode2 = treeNode.getParent();
        while (treeNode2 != null) {
            if (treeNode2.getChildIndex(this) == -1) {
                return false;
            }
            treeNode = treeNode2;
            treeNode2 = treeNode.getParent();
        }
        boolean bl = false;
        if (this.model.getRootIndex(treeNode) != -1) {
            bl = true;
        }
        return bl;
    }

    public final void setExpanded(boolean bl) {
        this.expanded = bl;
        if (this.expanded) {
            this.expanded();
        } else {
            this.collapsed();
        }
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public void expanded() {
    }

    public void collapsed() {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean hasFocus() {
        return this.focus;
    }

    void setFocus(boolean bl) {
        this.focus = bl;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    double layout(double d, double d2, boolean bl, boolean bl2, ArrayList arrayList, Size size) {
        this.x = d;
        this.y = d2;
        this.isTop = bl;
        this.isLast = bl2;
        arrayList.add(this);
        BTree bTree = this.getTree();
        if (bTree == null) {
            System.out.println("ERROR: TreeNode.layout no tree: " + this.getClass().getName());
            return 0.0;
        }
        TreeTheme treeTheme = Theme.tree();
        TreeNodeRenderer treeNodeRenderer = bTree.getNodeRenderer();
        double d3 = treeNodeRenderer.getHeight();
        this.height = this.getTree().getRowHeight();
        this.expanderWidth = treeTheme.getExpanderWidth();
        this.expanderHeight = treeTheme.getExpanderHeight();
        this.expanderX = d;
        this.expanderY = d2 + (this.height - this.expanderHeight) / (double)2;
        this.nodeX = this.expanderX + this.expanderWidth + (double)4;
        this.nodeY = d2 + (this.height - d3) / (double)2;
        d2 += this.height;
        if (this.expanded) {
            RectGeom rectGeom = null;
            if (this.getTree().widgetSupport(this) != null) {
                rectGeom = new RectGeom(0.0, d2 - this.height, this.getTree().getWidth(), this.height);
            }
            double d4 = this.nodeX + (treeNodeRenderer.getIconWidth() - this.expanderWidth) / (double)2;
            int n = this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode = this.getChild(n2);
                boolean bl3 = false;
                if (n2 == n - 1) {
                    bl3 = true;
                }
                d2 = treeNode.layout(d4, d2, false, bl3, arrayList, size);
                ++n2;
            }
            if (rectGeom != null) {
                rectGeom.height = d2 - rectGeom.y;
                this.getTree().widgetSupport(rectGeom);
            }
        }
        size.width = Math.max(size.width, this.nodeX + treeNodeRenderer.getWidth(this));
        return d2;
    }

    public boolean inExpander(double d, double d2) {
        return Theme.tree().inExpander(this.expanderX, this.expanderY, d, d2);
    }

    public boolean isSelection(double d, double d2) {
        BTree bTree = this.getTree();
        TreeNodeRenderer treeNodeRenderer = bTree.getNodeRenderer();
        double d3 = treeNodeRenderer.getWidth(this);
        boolean bl = false;
        if (d >= this.nodeX && d <= this.nodeX + d3) {
            bl = true;
        }
        return bl;
    }

    public double getWidth() {
        return this.expanderWidth + (double)4 + this.getTree().getNodeRenderer().getWidth(this);
    }

    double paint(Graphics graphics, double d) {
        try {
            TreeTheme treeTheme = Theme.tree();
            TreeNodeRenderer treeNodeRenderer = this.getTree().getNodeRenderer();
            boolean bl = this.isLeaf();
            if (!bl) {
                treeTheme.paintExpander(graphics, this.getTree(), this.expanderX, this.expanderY, this.expanded);
            }
            double d2 = this.expanderX + this.expanderWidth / (double)2;
            double d3 = this.expanderY + this.expanderHeight / (double)2;
            graphics.setBrush(treeTheme.getConnectingBrush(this.getTree()));
            if (bl) {
                PaintUtil.drawDashedLine(graphics, d2, d3, d2 + this.expanderWidth / (double)2 + (double)4, d3);
            } else {
                PaintUtil.drawDashedLine(graphics, this.expanderX + this.expanderWidth, d3, this.expanderX + this.expanderWidth + (double)4, d3);
            }
            if (!this.isTop) {
                if (bl) {
                    PaintUtil.drawDashedLine(graphics, d2, d3, d2, d);
                } else {
                    PaintUtil.drawDashedLine(graphics, d2, this.expanderY, d2, d);
                }
            }
            if (!this.isLast) {
                if (bl) {
                    PaintUtil.drawDashedLine(graphics, d2, d3, d2, this.y + this.height);
                } else {
                    PaintUtil.drawDashedLine(graphics, d2, this.expanderY + this.expanderHeight, d2, this.y + this.height);
                }
            }
            treeNodeRenderer.paintNode(graphics, this, this.nodeX, this.nodeY);
            if (this.expanded) {
                IRectGeom iRectGeom = graphics.getClipBounds();
                double d4 = iRectGeom.y();
                double d5 = iRectGeom.y() + iRectGeom.height();
                d = this.y + this.height;
                int n = this.getChildCount();
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode treeNode;
                    TreeNode treeNode2 = this.getChild(n2);
                    if (treeNode2.getY() > d5) {
                        if (bl2) break;
                        bl2 = true;
                    }
                    TreeNode treeNode3 = treeNode = n2 == n - 1 ? null : this.getChild(n2 + 1);
                    if (treeNode == null || !(treeNode.getY() <= d4)) {
                        d = this.getChild(n2).paint(graphics, d);
                    }
                    ++n2;
                }
            }
            return this.y + this.height;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.y + this.height;
        }
    }

    private final /* synthetic */ void this() {
        this.isTop = true;
        this.isLast = true;
        this.expanded = false;
        this.selected = false;
        this.focus = false;
    }

    public TreeNode(TreeModel treeModel, TreeNode treeNode) {
        this.this();
        this.model = treeModel;
        this.parent = treeNode;
    }

    public TreeNode(TreeModel treeModel) {
        this.this();
        this.model = treeModel;
    }

    public TreeNode(TreeNode treeNode) {
        this.this();
        this.parent = treeNode;
    }
}

