/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import javax.baja.gx.Point;
import javax.baja.sys.BComplex;
import javax.baja.sys.Clock;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.tree.TreeSubject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreeController
extends BTree.TreeSupport {
    private String searchText;
    private long lastSearchTime;
    private TreeNode focus;
    private TreeNode mouseNode;
    private TreeNode lastTarget;
    private TreeNode startTarget;

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.getTree().repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.getTree().repaint();
    }

    public void expanded(TreeNode treeNode) {
    }

    public void collapsed(TreeNode treeNode) {
        if (this.focus == null) {
            return;
        }
        if (this.focus.isDescendantOf(treeNode)) {
            this.setFocus(null);
        }
    }

    public TreeNode getFocus() {
        return this.focus;
    }

    public void setFocus(TreeNode treeNode) {
        if (this.focus != null) {
            this.focus.setFocus(false);
        }
        this.focus = treeNode;
        if (this.focus != null) {
            this.focus.setFocus(true);
            this.getTree().fireActionPerformed(new BWidgetEvent(2, this.getTree()));
        }
        this.getTree().repaint();
    }

    protected void mouseSelection(TreeNode treeNode, BMouseEvent bMouseEvent) {
        boolean bl;
        boolean bl2 = false;
        if (bMouseEvent.getId() == 501) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if (bMouseEvent.getId() == 502) {
            bl4 = bl = true;
        }
        if (treeNode == null) {
            this.getSelection().deselectAll();
            this.lastTarget = null;
            this.startTarget = null;
            this.setFocus(null);
            return;
        }
        if (bMouseEvent.isControlDown()) {
            if (treeNode.isSelected() && treeNode != this.lastTarget && bl) {
                this.getSelection().deselect(treeNode);
                this.lastTarget = null;
            } else if (treeNode.isSelected() && bl3 && bMouseEvent.getClickCount() != 2) {
                this.getSelection().deselect(treeNode);
                this.lastTarget = null;
            } else if (!treeNode.isSelected() && bl3) {
                this.getSelection().select(treeNode);
                this.lastTarget = treeNode;
            }
        } else if (bMouseEvent.isShiftDown()) {
            if (bl3) {
                if (this.startTarget != null) {
                    this.getSelection().deselectAll();
                    this.getSelection().select(this.startTarget);
                    this.selectBetween(treeNode, this.startTarget);
                }
                this.getSelection().select(treeNode);
                this.lastTarget = treeNode;
            }
        } else if (!treeNode.isSelected() || bl) {
            this.getSelection().deselectAll();
            this.getSelection().select(treeNode);
            this.startTarget = this.lastTarget = treeNode;
        }
        this.setFocus(treeNode);
        if (this.startTarget == null) {
            this.startTarget = treeNode;
        }
    }

    private final void selectBetween(TreeNode treeNode, TreeNode treeNode2) {
        int n;
        if (treeNode == treeNode2) {
            return;
        }
        TreeNode[] treeNodeArray = this.getTree().getVisibleNodes();
        int n2 = this.getNodeIndex(treeNodeArray, treeNode);
        int n3 = this.getNodeIndex(treeNodeArray, treeNode2);
        if (n2 == -1 || n3 == -1) {
            return;
        }
        this.getSelection().supressUpdates(true);
        if (n3 < n2) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        n = n2 + 1;
        while (n < n3) {
            this.getSelection().select(treeNodeArray[n]);
            ++n;
        }
        this.getSelection().supressUpdates(false);
    }

    private final int getNodeIndex(TreeNode[] treeNodeArray, TreeNode treeNode) {
        int n = 0;
        while (n < treeNodeArray.length) {
            if (treeNode == treeNodeArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.getTree().requestFocus();
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        TreeNode treeNode = this.getTree().yToTreeNode(d2);
        if (treeNode != null) {
            if (treeNode.inExpander(d, d2)) {
                this.getTree().toggleExpanded(treeNode);
            } else if (treeNode.isSelection(d, d2)) {
                this.mouseSelection(treeNode, bMouseEvent);
                if (!bMouseEvent.isButton3Down() && bMouseEvent.getClickCount() == 2) {
                    this.getSelection().deselectAll();
                    this.getSelection().select(treeNode);
                    this.nodeDoubleClicked(bMouseEvent, treeNode);
                }
            } else {
                treeNode = null;
                this.mouseSelection(null, bMouseEvent);
            }
        } else {
            this.mouseSelection(null, bMouseEvent);
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bMouseEvent, treeNode);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            TreeNode treeNode = this.getFocus();
            if (treeNode == null && (treeNode = this.getTree().yToTreeNode(d2)) != null && !treeNode.isSelection(d, d2)) {
                treeNode = null;
            }
            this.popup(bMouseEvent, treeNode);
        } else {
            TreeNode treeNode = this.getFocus();
            this.mouseSelection(treeNode, bMouseEvent);
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        TreeNode treeNode = this.getTree().yToTreeNode(d2);
        if (treeNode != null && !treeNode.isSelection(d, d2)) {
            treeNode = null;
        }
        this.setMouseNode(treeNode);
    }

    private final void setMouseNode(TreeNode treeNode) {
        if (this.mouseNode == treeNode) {
            return;
        }
        TreeNode treeNode2 = this.mouseNode;
        this.mouseNode = treeNode;
        if (treeNode2 != null) {
            this.nodeExited(treeNode2);
        }
        if (this.mouseNode != null) {
            this.nodeEntered(this.mouseNode);
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.mouseMoved(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.setMouseNode(null);
    }

    protected void nodeEntered(TreeNode treeNode) {
    }

    protected void nodeExited(TreeNode treeNode) {
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
    }

    protected final void initFocus() {
        TreeNode treeNode = this.getSelection().getNode();
        if (treeNode == null) {
            TreeModel treeModel = this.getModel();
            int n = treeModel.getRootCount();
            if (n == 0) {
                return;
            }
            treeNode = treeModel.getRoot(0);
        }
        this.setFocus(treeNode);
        this.getSelection().deselectAll();
        this.getSelection().select(treeNode);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.isControlDown() || bKeyEvent.isAltDown()) {
            return;
        }
        int n = bKeyEvent.getKeyCode();
        TreeNode treeNode = this.getFocus();
        if (treeNode != null) {
            switch (n) {
                case 39: {
                    this.getTree().setExpanded(treeNode, true);
                    bKeyEvent.consume();
                    this.searchText = "";
                    return;
                }
                case 37: {
                    this.getTree().setExpanded(treeNode, false);
                    bKeyEvent.consume();
                    this.searchText = "";
                    return;
                }
                case 10: {
                    this.doSelectAction(treeNode, treeNode.getX(), treeNode.getY());
                    bKeyEvent.consume();
                    this.searchText = "";
                    return;
                }
                case 525: {
                    this.popup(new BMouseEvent(501, this.getTree(), 0, this.getSelection().getNode().getX(), this.getSelection().getNode().getY(), 0, true), this.getSelection().getNode());
                }
            }
            char c = bKeyEvent.getKeyChar();
            if (32 <= n && n <= 57 || 65 <= n && n <= 90) {
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + c : "" + c;
                int n2 = 0;
                while (n2 < this.getModel().getRootCount()) {
                    if (this.search(this.getModel().getRoot(n2), this.searchText)) break;
                    ++n2;
                }
                this.lastSearchTime = Clock.ticks();
                bKeyEvent.consume();
            }
        }
        switch (n) {
            case 38: {
                this.previousSelection(bKeyEvent);
                bKeyEvent.consume();
                this.searchText = "";
                break;
            }
            case 40: {
                this.nextSelection(bKeyEvent);
                bKeyEvent.consume();
                this.searchText = "";
                break;
            }
        }
    }

    private final boolean search(TreeNode treeNode, String string) {
        if (treeNode == null) {
            return false;
        }
        TreeSelection treeSelection = this.getSelection();
        String string2 = treeNode.getText();
        if (string2 != null && string2.length() > 0 && string2.toLowerCase().startsWith(string.toLowerCase())) {
            treeSelection.deselectAll();
            treeSelection.select(treeNode);
            this.setFocus(treeNode);
            this.getTree().scrollNodeToVisible(treeNode);
            return true;
        }
        if (treeNode.isExpanded()) {
            int n = 0;
            while (n < treeNode.getChildCount()) {
                if (this.search(treeNode.getChild(n), string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        if (bKeyEvent.getKeyCode() == 10) {
            this.handleEnter(bKeyEvent);
        } else if (bKeyEvent.getKeyCode() == 27) {
            this.handleEscape(bKeyEvent);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    protected void handleEnter(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getTree().fireActionPerformed(new BWidgetEvent(2, this.getTree()));
    }

    protected void handleEscape(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getTree().fireCancelled(new BWidgetEvent(2, this.getTree()));
    }

    private final void previousSelection(BKeyEvent bKeyEvent) {
        TreeNode treeNode = this.getFocus();
        if (treeNode == null) {
            this.initFocus();
        } else {
            TreeNode treeNode2 = this.getTree().getPrevious(treeNode);
            if (treeNode2 != null) {
                if (bKeyEvent != null && (bKeyEvent.isControlDown() || bKeyEvent.isShiftDown())) {
                    this.getSelection().getSelection().select(treeNode2);
                } else {
                    this.getSelection().deselectAll();
                    this.getSelection().select(treeNode2);
                }
                this.setFocus(treeNode2);
                this.getTree().scrollNodeToVisible(treeNode2);
            }
        }
    }

    private final void nextSelection(BKeyEvent bKeyEvent) {
        TreeNode treeNode = this.getFocus();
        if (treeNode == null) {
            this.initFocus();
        } else {
            TreeNode treeNode2 = this.getTree().getNext(treeNode);
            if (treeNode2 != null) {
                if (bKeyEvent != null && (bKeyEvent.isControlDown() || bKeyEvent.isShiftDown())) {
                    this.getSelection().select(treeNode2);
                } else {
                    this.getSelection().deselectAll();
                    this.getSelection().select(treeNode2);
                }
                this.setFocus(treeNode2);
                this.getTree().scrollNodeToVisible(treeNode2);
            }
        }
    }

    protected void nodeDoubleClicked(BMouseEvent bMouseEvent, TreeNode treeNode) {
        this.doSelectAction(treeNode, bMouseEvent.getX(), bMouseEvent.getY());
    }

    protected void doSelectAction(TreeNode treeNode, double d, double d2) {
    }

    public boolean pulseViewport(double d, double d2) {
        BComplex bComplex = this.getTree().getParent();
        if (bComplex instanceof BScrollPane) {
            return ((BScrollPane)bComplex).pulseViewport(new Point(d, d2), this.getNodeRenderer().getHeight());
        }
        return false;
    }

    protected void popup(BMouseEvent bMouseEvent, TreeNode treeNode) {
        TreeSubject treeSubject = this.getSelection().getSubject(treeNode);
        BMenu bMenu = this.makePopup(treeSubject);
        if (bMenu != null) {
            bMenu.removeConsecutiveSeparators();
            bMenu.open(bMouseEvent);
        }
    }

    protected BMenu makePopup(TreeSubject treeSubject) {
        return null;
    }

    private final /* synthetic */ void this() {
        this.searchText = "";
        this.lastSearchTime = 0L;
        this.lastTarget = null;
        this.startTarget = null;
    }

    public TreeController() {
        this.this();
    }
}

