/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTree
extends BTransferWidget {
    public static final Property multipleSelection = BTree.newProperty((int)0, (boolean)false, null);
    public static final Topic actionPerformed = BTree.newTopic((int)0, null);
    public static final Topic cancelled = BTree.newTopic((int)0, null);
    public static final Topic treeModified = BTree.newTopic((int)0, null);
    public static final Topic selectionModified = BTree.newTopic((int)0, null);
    public static final Type TYPE;
    TreeModel model;
    TreeController controller;
    TreeNodeRenderer nodeRenderer;
    TreeSelection selection;
    ArrayList visibleNodes;
    TreeNode toVisible;
    TreeNode lastExpand;
    RectGeom toVisibleRect;
    static /* synthetic */ Class class$javax$baja$ui$tree$BTree;

    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    public void setMultipleSelection(boolean bl) {
        this.setBoolean(multipleSelection, bl, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public void fireCancelled(BWidgetEvent bWidgetEvent) {
        this.fire(cancelled, (BValue)bWidgetEvent, null);
    }

    public void fireTreeModified(BWidgetEvent bWidgetEvent) {
        this.fire(treeModified, (BValue)bWidgetEvent, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel treeModel) {
        this.installSupport(this.model, treeModel);
        this.model = treeModel;
        this.visibleNodes = new ArrayList(64);
        this.toVisible = null;
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public TreeController getController() {
        return this.controller;
    }

    public void setController(TreeController treeController) {
        this.installSupport(this.controller, treeController);
        this.controller = treeController;
    }

    public TreeNodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(TreeNodeRenderer treeNodeRenderer) {
        this.installSupport(this.nodeRenderer, treeNodeRenderer);
        this.nodeRenderer = treeNodeRenderer;
    }

    public TreeSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TreeSelection treeSelection) {
        this.installSupport(this.selection, treeSelection);
        this.selection = treeSelection;
    }

    private final void installSupport(TreeSupport treeSupport, TreeSupport treeSupport2) {
        if (treeSupport2 == null) {
            throw new NullPointerException();
        }
        if (treeSupport == treeSupport2) {
            return;
        }
        if (treeSupport2.tree != null) {
            throw new IllegalArgumentException("Already installed on another tree");
        }
        if (treeSupport != null) {
            treeSupport.tree = null;
        }
        treeSupport2.tree = this;
    }

    public void computePreferredSize() {
        Size size = new Size(0.0, 0.0);
        size = this.doLayout(null, size);
        this.setPreferredSize(size.width, size.height);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.doLayout(bWidgetArray, null);
        if (this.toVisibleRect != null) {
            this.scrollToVisible(this.toVisibleRect);
        }
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public Size doLayout(BWidget[] bWidgetArray, Size size) {
        if (size == null) {
            size = new Size(0.0, 0.0);
        }
        double d = Theme.tree().getInsets().left;
        double d2 = Theme.tree().getInsets().top;
        this.visibleNodes.clear();
        TreeModel treeModel = this.model;
        int n = treeModel.getRootCount();
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode = treeModel.getRoot(n2);
            boolean bl = false;
            if (n2 == 0) {
                bl = true;
            }
            boolean bl2 = false;
            if (n2 == n - 1) {
                bl2 = true;
            }
            d2 = treeNode.layout(d, d2, bl, bl2, this.visibleNodes, size);
            ++n2;
        }
        size.height = d2;
        if (this.getParent() instanceof BTreePane) {
            size.height += this.getRowHeight();
        }
        return size;
    }

    public double getRowHeight() {
        return Math.max(Theme.tree().getExpanderHeight(), this.nodeRenderer.getHeight());
    }

    public int getRow(double d) {
        double d2 = this.getRowHeight();
        if ((d -= Theme.tree().getInsets().top) < 0.0) {
            d = 0.0;
        }
        return (int)(d / d2);
    }

    public TreeNode yToTreeNode(double d) {
        int n = this.getRow(d);
        if (n >= this.visibleNodes.size()) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(n);
    }

    public TreeNode getPrevious(TreeNode treeNode) {
        double d = treeNode.getY();
        int n = this.getRow(d);
        if (n == 0) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(n - 1);
    }

    public TreeNode getNext(TreeNode treeNode) {
        double d = treeNode.getY();
        int n = this.getRow(d);
        if (n == this.visibleNodes.size() - 1) {
            return null;
        }
        return (TreeNode)this.visibleNodes.get(n + 1);
    }

    public void paint(Graphics graphics) {
        IRectGeom iRectGeom = graphics.getClipBounds();
        graphics.setBrush(Theme.tree().getBackground(this));
        graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        int n = this.model.getRootCount();
        double d = this.nodeRenderer.getHeight();
        double d2 = iRectGeom.y();
        double d3 = iRectGeom.y() + iRectGeom.height();
        double d4 = 0.0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode;
            TreeNode treeNode2 = this.model.getRoot(n2);
            if (treeNode2.getY() > d3) {
                if (bl) break;
                bl = true;
            }
            TreeNode treeNode3 = treeNode = n2 == n - 1 ? null : this.model.getRoot(n2 + 1);
            if (treeNode == null || !(treeNode.getY() <= d2)) {
                d4 = treeNode2.paint(graphics, d4);
                if (this.toVisible != null) {
                    RectGeom rectGeom = new RectGeom(this.toVisible.getX(), this.toVisible.getY(), this.toVisible.getWidth() + (double)4, this.getRowHeight());
                    this.scrollToVisible(rectGeom);
                    this.toVisible = null;
                }
            }
            ++n2;
        }
    }

    public String getStyleSelector() {
        return "tree";
    }

    public final void toggleExpanded(TreeNode treeNode) {
        this.setExpanded(treeNode, treeNode.isExpanded() ^ true);
    }

    public void setExpanded(TreeNode treeNode, boolean bl) {
        if (treeNode.isExpanded() == bl) {
            return;
        }
        treeNode.setExpanded(bl);
        if (!bl) {
            this.selection.collapsed(treeNode);
            this.controller.collapsed(treeNode);
        } else {
            this.selection.expanded(treeNode);
            this.controller.expanded(treeNode);
            this.lastExpand = treeNode;
        }
        this.relayout();
    }

    public void expandToNode(TreeNode treeNode) {
        this.expandPath(treeNode.getPathFromRoot());
    }

    public void expandPath(TreeNode[] treeNodeArray) {
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n - 1) {
            treeNodeArray[n2].setExpanded(true);
            ++n2;
        }
        this.relayout();
    }

    public void scrollNodeToVisible(TreeNode treeNode) {
        this.scrollPathToVisible(treeNode.getPathFromRoot());
    }

    public void scrollPathToVisible(TreeNode[] treeNodeArray) {
        this.toVisible = treeNodeArray[treeNodeArray.length - 1];
        this.expandPath(treeNodeArray);
    }

    public Object widgetSupport(Object object) {
        if (object instanceof TreeNode) {
            if (object == this.lastExpand) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (object instanceof RectGeom) {
            this.toVisibleRect = (RectGeom)object;
            return null;
        }
        return super.widgetSupport(object);
    }

    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.controller.focusGained(bFocusEvent);
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.controller.focusLost(bFocusEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.controller.mousePressed(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.controller.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.controller.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.controller.mouseExited(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.controller.mousePulsed(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.controller.mouseMoved(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.controller.mouseDragged(bMouseEvent);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        this.controller.keyPressed(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        this.controller.keyReleased(bKeyEvent);
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        this.controller.keyTyped(bKeyEvent);
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int dragOver(TransferContext transferContext) {
        if (transferContext.isPulse()) {
            this.controller.pulseViewport(transferContext.getX(), transferContext.getY());
        }
        return super.dragOver(transferContext);
    }

    public TreeNode[] getVisibleNodes() {
        TreeNode[] treeNodeArray = new TreeNode[this.visibleNodes.size()];
        int n = 0;
        while (n < this.visibleNodes.size()) {
            treeNodeArray[n] = (TreeNode)this.visibleNodes.get(n);
            ++n;
        }
        return treeNodeArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.visibleNodes = new ArrayList(64);
        this.toVisible = null;
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public BTree() {
        this(new TreeModel.DefaultTreeModel(), new TreeController());
    }

    public BTree(TreeModel treeModel) {
        this(treeModel, new TreeController());
    }

    public BTree(TreeModel treeModel, TreeController treeController) {
        this.this();
        this.setModel(treeModel);
        this.setController(treeController);
        this.setNodeRenderer(new TreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    static {
        Class clazz = class$javax$baja$ui$tree$BTree;
        if (clazz == null) {
            clazz = class$javax$baja$ui$tree$BTree = BTree.class("[Ljavax.baja.ui.tree.BTree;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static abstract class TreeSupport {
        BTree tree;

        public final BTree getTree() {
            return this.tree;
        }

        public final TreeModel getModel() {
            return this.tree.model;
        }

        public final TreeController getController() {
            return this.tree.controller;
        }

        public final TreeNodeRenderer getNodeRenderer() {
            return this.tree.nodeRenderer;
        }

        public final TreeSelection getSelection() {
            return this.tree.selection;
        }

        public final BWidgetShell getShell() {
            return this.tree.getShell();
        }
    }
}

