/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.transfer;

import javax.baja.space.Mark;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;

public final class TransferEnvelope {
    private TransferFormat[] formats;
    private Object[] data;

    public static final TransferEnvelope make(String string) {
        return new TransferEnvelope(new TransferFormat[]{TransferFormat.string}, new Object[]{string});
    }

    public static final TransferEnvelope make(Mark mark) {
        return new TransferEnvelope(new TransferFormat[]{TransferFormat.mark, TransferFormat.string}, new Object[]{mark, mark.toStringFormat()});
    }

    public final boolean supports(TransferFormat transferFormat) {
        int n = 0;
        while (n < this.formats.length) {
            if (this.formats[n].equals(transferFormat)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final TransferFormat[] getFormats() {
        return (TransferFormat[])this.formats.clone();
    }

    public final Object getData(TransferFormat transferFormat) {
        int n = 0;
        while (n < this.formats.length) {
            if (this.formats[n].equals(transferFormat)) {
                return this.data[n];
            }
            ++n;
        }
        throw new UnsupportedFormatException(transferFormat.toString());
    }

    private TransferEnvelope(TransferFormat[] transferFormatArray, Object[] objectArray) {
        this.formats = transferFormatArray;
        this.data = objectArray;
    }
}

