/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.transfer;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellManager;
import javax.baja.space.Mark;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferConst;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BTransferWidget
extends BWidget
implements TransferConst {
    public static final Type TYPE;
    boolean cutEnabled;
    boolean copyEnabled;
    boolean pasteEnabled;
    boolean pasteSpecialEnabled;
    boolean duplicateEnabled;
    boolean deleteEnabled;
    boolean renameEnabled;
    static /* synthetic */ Class class$javax$baja$ui$transfer$BTransferWidget;

    public Type getType() {
        return TYPE;
    }

    public boolean isCutEnabled() {
        return this.cutEnabled;
    }

    public void setCutEnabled(boolean bl) {
        if (this.cutEnabled == bl) {
            return;
        }
        this.cutEnabled = bl;
        this.updateStates();
    }

    public boolean isCopyEnabled() {
        return this.copyEnabled;
    }

    public void setCopyEnabled(boolean bl) {
        if (this.copyEnabled == bl) {
            return;
        }
        this.copyEnabled = bl;
        this.updateStates();
    }

    public boolean isPasteEnabled() {
        return this.pasteEnabled;
    }

    public void setPasteEnabled(boolean bl) {
        if (this.pasteEnabled == bl) {
            return;
        }
        this.pasteEnabled = bl;
        this.updateStates();
    }

    public boolean isPasteSpecialEnabled() {
        return this.pasteSpecialEnabled;
    }

    public void setPasteSpecialEnabled(boolean bl) {
        if (this.pasteSpecialEnabled == bl) {
            return;
        }
        this.pasteSpecialEnabled = bl;
        this.updateStates();
    }

    public boolean isDuplicateEnabled() {
        return this.duplicateEnabled;
    }

    public void setDuplicateEnabled(boolean bl) {
        if (this.duplicateEnabled == bl) {
            return;
        }
        this.duplicateEnabled = bl;
        this.updateStates();
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public void setDeleteEnabled(boolean bl) {
        if (this.deleteEnabled == bl) {
            return;
        }
        this.deleteEnabled = bl;
        this.updateStates();
    }

    public boolean isRenameEnabled() {
        return this.renameEnabled;
    }

    public void setRenameEnabled(boolean bl) {
        if (this.renameEnabled == bl) {
            return;
        }
        this.renameEnabled = bl;
        this.updateStates();
    }

    private final void updateStates() {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell instanceof NiagaraWbShell) {
            ((NiagaraWbShell)((Object)bWidgetShell)).updateTransferWidgetStates();
        }
    }

    public void startDrag(BMouseEvent bMouseEvent, TransferContext transferContext, DragRenderer dragRenderer) {
        ShellManager shellManager = (ShellManager)this.widgetSupport(null);
        shellManager.startDragOperation(this, bMouseEvent, transferContext, dragRenderer);
    }

    public void startDrag(BMouseEvent bMouseEvent, TransferEnvelope transferEnvelope, DragRenderer dragRenderer) {
        this.startDrag(bMouseEvent, this.makeTransferContext(transferEnvelope), dragRenderer);
    }

    public void dragEnter(TransferContext transferContext) {
    }

    public int dragOver(TransferContext transferContext) {
        return 0;
    }

    public void dragExit(TransferContext transferContext) {
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doCopy() throws Exception {
        this.setCurrentMark(null);
        if (!this.copyEnabled) {
            return null;
        }
        TransferEnvelope transferEnvelope = this.getTransferData();
        if (transferEnvelope == null) {
            return null;
        }
        Clipboard.getDefault().setContents(transferEnvelope);
        if (transferEnvelope.supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
            this.setCurrentMark(mark);
        }
        return null;
    }

    public CommandArtifact doCut() throws Exception {
        Object object;
        this.setCurrentMark(null);
        if (!this.cutEnabled) {
            return null;
        }
        TransferEnvelope transferEnvelope = this.getTransferData();
        if (transferEnvelope == null) {
            return null;
        }
        Clipboard.getDefault().setContents(transferEnvelope);
        if (transferEnvelope.supports(TransferFormat.mark)) {
            object = (Mark)transferEnvelope.getData(TransferFormat.mark);
            object.setPendingMove(true);
            this.setCurrentMark((Mark)object);
        }
        object = this.makeTransferContext(null, 32, transferEnvelope);
        return this.removeTransferData((TransferContext)object);
    }

    public CommandArtifact doPaste() throws Exception {
        if (!this.pasteEnabled) {
            return null;
        }
        try {
            Object object;
            TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
            if (transferEnvelope == null) {
                BDialog.error(this, UiLexicon.bajaui().getText("command.paste.emptyClipboard"));
                return null;
            }
            int n = 16;
            if (transferEnvelope.supports(TransferFormat.mark) && (object = (Mark)transferEnvelope.getData(TransferFormat.mark)).isPendingMove()) {
                n = 32;
                Clipboard.getDefault().setContents(null);
                this.setCurrentMark(null);
                object.setPendingMove(false);
            }
            object = this.makeTransferContext(null, n, transferEnvelope);
            return this.insertTransferData((TransferContext)object);
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            BDialog.error(this, UiLexicon.bajaui().getText("command.paste.unsupportedFormat"));
            return null;
        }
    }

    public CommandArtifact doPasteSpecial() throws Exception {
        if (!this.pasteSpecialEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doDuplicate() throws Exception {
        if (!this.duplicateEnabled) {
            return null;
        }
        TransferEnvelope transferEnvelope = this.getTransferData();
        if (transferEnvelope == null) {
            return null;
        }
        TransferContext transferContext = this.makeTransferContext(null, 16, transferEnvelope);
        return this.insertTransferData(transferContext);
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.deleteEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doRename() throws Exception {
        if (!this.renameEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public abstract TransferEnvelope getTransferData() throws Exception;

    public abstract CommandArtifact insertTransferData(TransferContext var1) throws Exception;

    public abstract CommandArtifact removeTransferData(TransferContext var1) throws Exception;

    public final TransferContext makeTransferContext(TransferEnvelope transferEnvelope) {
        return this.makeTransferContext(null, 16, transferEnvelope);
    }

    public TransferContext makeTransferContext(Context context, int n, TransferEnvelope transferEnvelope) {
        return new TransferContext(context, n, transferEnvelope);
    }

    void setCurrentMark(Mark mark) {
        Mark.setCurrent((Mark)mark);
        this.getShell().repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cutEnabled = false;
        this.copyEnabled = false;
        this.pasteEnabled = false;
        this.pasteSpecialEnabled = false;
        this.duplicateEnabled = false;
        this.deleteEnabled = false;
        this.renameEnabled = false;
    }

    public BTransferWidget() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$transfer$BTransferWidget;
        if (clazz == null) {
            clazz = class$javax$baja$ui$transfer$BTransferWidget = BTransferWidget.class("[Ljavax.baja.ui.transfer.BTransferWidget;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

