/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class PythonParser
extends TextParser {
    protected Segment nextSegment() {
        Segment segment = this.parseWhitespace();
        if (segment != null) {
            return segment;
        }
        int n = this.current;
        if (n == 123 || n == 125 || n == 40 || n == 41 || n == 91 || n == 93) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)n)) {
            Segment segment2 = this.parseIdentifier();
            if (this.isKeyword(segment2)) {
                return new Segment(6, 8, segment2.offset, segment2.length);
            }
            return segment2;
        }
        if (n == 35) {
            this.advance();
            return this.newSegment(10);
        }
        if (!(n != 34 && n != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= n && n <= 57 || n == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current)) {
            if (!this.advance()) break;
        }
        return this.newSegment(0);
    }

    private final Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private final boolean isKeyword(Segment segment) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(segment, "and")) {
                    return true;
                }
                return this.isKeyword(segment, "assert");
            }
            case 'b': {
                return this.isKeyword(segment, "break");
            }
            case 'c': {
                if (this.isKeyword(segment, "class")) {
                    return true;
                }
                return this.isKeyword(segment, "continue");
            }
            case 'd': {
                if (this.isKeyword(segment, "def")) {
                    return true;
                }
                return this.isKeyword(segment, "del");
            }
            case 'e': {
                if (this.isKeyword(segment, "elif")) {
                    return true;
                }
                if (this.isKeyword(segment, "else")) {
                    return true;
                }
                if (this.isKeyword(segment, "except")) {
                    return true;
                }
                return this.isKeyword(segment, "exec");
            }
            case 'f': {
                if (this.isKeyword(segment, "finally")) {
                    return true;
                }
                if (this.isKeyword(segment, "from")) {
                    return true;
                }
                return this.isKeyword(segment, "for");
            }
            case 'g': {
                return this.isKeyword(segment, "global");
            }
            case 'i': {
                if (this.isKeyword(segment, "if")) {
                    return true;
                }
                if (this.isKeyword(segment, "import")) {
                    return true;
                }
                if (this.isKeyword(segment, "in")) {
                    return true;
                }
                return this.isKeyword(segment, "is");
            }
            case 'l': {
                return this.isKeyword(segment, "lambda");
            }
            case 'n': {
                return this.isKeyword(segment, "not");
            }
            case 'o': {
                return this.isKeyword(segment, "or");
            }
            case 'p': {
                if (this.isKeyword(segment, "pass")) {
                    return true;
                }
                return this.isKeyword(segment, "print");
            }
            case 'r': {
                if (this.isKeyword(segment, "raise")) {
                    return true;
                }
                return this.isKeyword(segment, "return");
            }
            case 't': {
                return this.isKeyword(segment, "try");
            }
            case 'w': {
                return this.isKeyword(segment, "while");
            }
            case 'y': {
                return this.isKeyword(segment, "yield");
            }
        }
        return false;
    }

    private final boolean isKeyword(Segment segment, String string) {
        int n = segment.length;
        if (n != string.length()) {
            return false;
        }
        char[] cArray = this.buffer;
        int n2 = this.segmentStart;
        int n3 = 1;
        while (n3 < n) {
            if (string.charAt(n3) != cArray[n2 + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final Segment parseNumberLiteral() {
        int n;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (n = this.current) && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70 || n == 108 || n == 76 || n == 46 || n == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private final boolean isSymbol(int n) {
        switch (n) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

