/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class HtmlParser
extends TextParser {
    boolean inTag;

    protected Segment nextSegment() {
        Segment segment = this.parseWhitespace();
        if (segment != null) {
            return segment;
        }
        int n = this.current;
        if (Character.isJavaIdentifierStart((char)n)) {
            Segment segment2 = this.parseIdentifier();
            if (this.inTag && this.isKeyword(segment2)) {
                return new Segment(6, 8, segment2.offset, segment2.length);
            }
            return segment2;
        }
        if (n == 60 && this.next == 33 && this.isCurrent("<!--")) {
            return this.newSegment(11);
        }
        if (n == 45 && this.next == 45 && this.isCurrent("-->")) {
            return this.newSegment(12);
        }
        if (n == 60) {
            if (this.next == 47) {
                this.advance();
            }
            this.inTag = true;
            this.advance();
            return this.newSegment(8);
        }
        if (n == 62) {
            this.inTag = false;
            this.advance();
            return this.newSegment(8);
        }
        if (n == 47 && this.next == 62) {
            this.inTag = false;
            this.advance();
            this.advance();
            return this.newSegment(8);
        }
        if (!(!this.inTag || n != 34 && n != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (this.inTag && (48 <= n && n <= 57 || n == 45 && 48 <= this.next && this.next <= 57)) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current)) {
            if (!this.advance()) break;
        }
        return this.newSegment(0);
    }

    private final Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private final boolean isKeyword(Segment segment) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(segment, "a")) {
                    return true;
                }
                if (this.isKeyword(segment, "abbr")) {
                    return true;
                }
                if (this.isKeyword(segment, "above")) {
                    return true;
                }
                if (this.isKeyword(segment, "acronym")) {
                    return true;
                }
                if (this.isKeyword(segment, "address")) {
                    return true;
                }
                if (this.isKeyword(segment, "applet")) {
                    return true;
                }
                if (this.isKeyword(segment, "array")) {
                    return true;
                }
                if (this.isKeyword(segment, "area")) {
                    return true;
                }
                if (this.isKeyword(segment, "abbr")) {
                    return true;
                }
                if (this.isKeyword(segment, "accept-charset")) {
                    return true;
                }
                if (this.isKeyword(segment, "accept")) {
                    return true;
                }
                if (this.isKeyword(segment, "accesskey")) {
                    return true;
                }
                if (this.isKeyword(segment, "action")) {
                    return true;
                }
                if (this.isKeyword(segment, "align")) {
                    return true;
                }
                if (this.isKeyword(segment, "alink")) {
                    return true;
                }
                if (this.isKeyword(segment, "alt")) {
                    return true;
                }
                if (this.isKeyword(segment, "archive")) {
                    return true;
                }
                return this.isKeyword(segment, "axis");
            }
            case 'b': {
                if (this.isKeyword(segment, "b")) {
                    return true;
                }
                if (this.isKeyword(segment, "base")) {
                    return true;
                }
                if (this.isKeyword(segment, "basefont")) {
                    return true;
                }
                if (this.isKeyword(segment, "bdo")) {
                    return true;
                }
                if (this.isKeyword(segment, "bbsound")) {
                    return true;
                }
                if (this.isKeyword(segment, "big")) {
                    return true;
                }
                if (this.isKeyword(segment, "blink")) {
                    return true;
                }
                if (this.isKeyword(segment, "blockquote")) {
                    return true;
                }
                if (this.isKeyword(segment, "body")) {
                    return true;
                }
                if (this.isKeyword(segment, "br")) {
                    return true;
                }
                if (this.isKeyword(segment, "button")) {
                    return true;
                }
                if (this.isKeyword(segment, "background")) {
                    return true;
                }
                if (this.isKeyword(segment, "behavior")) {
                    return true;
                }
                if (this.isKeyword(segment, "below")) {
                    return true;
                }
                if (this.isKeyword(segment, "bgcolor")) {
                    return true;
                }
                return this.isKeyword(segment, "border");
            }
            case 'c': {
                if (this.isKeyword(segment, "caption")) {
                    return true;
                }
                if (this.isKeyword(segment, "center")) {
                    return true;
                }
                if (this.isKeyword(segment, "cite")) {
                    return true;
                }
                if (this.isKeyword(segment, "code")) {
                    return true;
                }
                if (this.isKeyword(segment, "col")) {
                    return true;
                }
                if (this.isKeyword(segment, "colgroup")) {
                    return true;
                }
                if (this.isKeyword(segment, "command")) {
                    return true;
                }
                if (this.isKeyword(segment, "comment")) {
                    return true;
                }
                if (this.isKeyword(segment, "cellpadding")) {
                    return true;
                }
                if (this.isKeyword(segment, "cellspacing")) {
                    return true;
                }
                if (this.isKeyword(segment, "char")) {
                    return true;
                }
                if (this.isKeyword(segment, "charoff")) {
                    return true;
                }
                if (this.isKeyword(segment, "charset")) {
                    return true;
                }
                if (this.isKeyword(segment, "checked")) {
                    return true;
                }
                if (this.isKeyword(segment, "cite")) {
                    return true;
                }
                if (this.isKeyword(segment, "class")) {
                    return true;
                }
                if (this.isKeyword(segment, "classid")) {
                    return true;
                }
                if (this.isKeyword(segment, "clear")) {
                    return true;
                }
                if (this.isKeyword(segment, "codebase")) {
                    return true;
                }
                if (this.isKeyword(segment, "codetype")) {
                    return true;
                }
                if (this.isKeyword(segment, "color")) {
                    return true;
                }
                if (this.isKeyword(segment, "cols")) {
                    return true;
                }
                if (this.isKeyword(segment, "colspan")) {
                    return true;
                }
                if (this.isKeyword(segment, "compact")) {
                    return true;
                }
                if (this.isKeyword(segment, "content")) {
                    return true;
                }
                return this.isKeyword(segment, "coords");
            }
            case 'd': {
                if (this.isKeyword(segment, "dd")) {
                    return true;
                }
                if (this.isKeyword(segment, "del")) {
                    return true;
                }
                if (this.isKeyword(segment, "dfn")) {
                    return true;
                }
                if (this.isKeyword(segment, "dir")) {
                    return true;
                }
                if (this.isKeyword(segment, "div")) {
                    return true;
                }
                if (this.isKeyword(segment, "dl")) {
                    return true;
                }
                if (this.isKeyword(segment, "dt")) {
                    return true;
                }
                if (this.isKeyword(segment, "data")) {
                    return true;
                }
                if (this.isKeyword(segment, "datetime")) {
                    return true;
                }
                if (this.isKeyword(segment, "declare")) {
                    return true;
                }
                if (this.isKeyword(segment, "defer")) {
                    return true;
                }
                return this.isKeyword(segment, "disabled");
            }
            case 'e': {
                if (this.isKeyword(segment, "em")) {
                    return true;
                }
                if (this.isKeyword(segment, "embed")) {
                    return true;
                }
                if (this.isKeyword(segment, "envar")) {
                    return true;
                }
                return this.isKeyword(segment, "enctype");
            }
            case 'f': {
                if (this.isKeyword(segment, "fieldset")) {
                    return true;
                }
                if (this.isKeyword(segment, "filename")) {
                    return true;
                }
                if (this.isKeyword(segment, "fig")) {
                    return true;
                }
                if (this.isKeyword(segment, "font")) {
                    return true;
                }
                if (this.isKeyword(segment, "form")) {
                    return true;
                }
                if (this.isKeyword(segment, "frame")) {
                    return true;
                }
                if (this.isKeyword(segment, "frameset")) {
                    return true;
                }
                if (this.isKeyword(segment, "face")) {
                    return true;
                }
                if (this.isKeyword(segment, "for")) {
                    return true;
                }
                if (this.isKeyword(segment, "frameborder")) {
                    return true;
                }
                return this.isKeyword(segment, "framespacing");
            }
            case 'h': {
                if (this.isKeyword(segment, "h1")) {
                    return true;
                }
                if (this.isKeyword(segment, "h2")) {
                    return true;
                }
                if (this.isKeyword(segment, "h3")) {
                    return true;
                }
                if (this.isKeyword(segment, "h4")) {
                    return true;
                }
                if (this.isKeyword(segment, "h5")) {
                    return true;
                }
                if (this.isKeyword(segment, "h6")) {
                    return true;
                }
                if (this.isKeyword(segment, "head")) {
                    return true;
                }
                if (this.isKeyword(segment, "hr")) {
                    return true;
                }
                if (this.isKeyword(segment, "html")) {
                    return true;
                }
                if (this.isKeyword(segment, "headers")) {
                    return true;
                }
                if (this.isKeyword(segment, "height")) {
                    return true;
                }
                if (this.isKeyword(segment, "hidden")) {
                    return true;
                }
                if (this.isKeyword(segment, "href")) {
                    return true;
                }
                if (this.isKeyword(segment, "hreflang")) {
                    return true;
                }
                if (this.isKeyword(segment, "hspace")) {
                    return true;
                }
                return this.isKeyword(segment, "http-equiv");
            }
            case 'i': {
                if (this.isKeyword(segment, "i")) {
                    return true;
                }
                if (this.isKeyword(segment, "iframe")) {
                    return true;
                }
                if (this.isKeyword(segment, "ilayer")) {
                    return true;
                }
                if (this.isKeyword(segment, "img")) {
                    return true;
                }
                if (this.isKeyword(segment, "input")) {
                    return true;
                }
                if (this.isKeyword(segment, "ins")) {
                    return true;
                }
                if (this.isKeyword(segment, "isindex")) {
                    return true;
                }
                if (this.isKeyword(segment, "id")) {
                    return true;
                }
                return this.isKeyword(segment, "ismap");
            }
            case 'l': {
                if (this.isKeyword(segment, "label")) {
                    return true;
                }
                if (this.isKeyword(segment, "layer")) {
                    return true;
                }
                if (this.isKeyword(segment, "legend")) {
                    return true;
                }
                if (this.isKeyword(segment, "li")) {
                    return true;
                }
                if (this.isKeyword(segment, "link")) {
                    return true;
                }
                if (this.isKeyword(segment, "listing")) {
                    return true;
                }
                if (this.isKeyword(segment, "lang")) {
                    return true;
                }
                if (this.isKeyword(segment, "language")) {
                    return true;
                }
                if (this.isKeyword(segment, "loop")) {
                    return true;
                }
                return this.isKeyword(segment, "longdesc");
            }
            case 'm': {
                if (this.isKeyword(segment, "map")) {
                    return true;
                }
                if (this.isKeyword(segment, "marquee")) {
                    return true;
                }
                if (this.isKeyword(segment, "menu")) {
                    return true;
                }
                if (this.isKeyword(segment, "meta")) {
                    return true;
                }
                if (this.isKeyword(segment, "multicol")) {
                    return true;
                }
                if (this.isKeyword(segment, "mailto")) {
                    return true;
                }
                if (this.isKeyword(segment, "marginheight")) {
                    return true;
                }
                if (this.isKeyword(segment, "marginwidth")) {
                    return true;
                }
                if (this.isKeyword(segment, "maxlength")) {
                    return true;
                }
                if (this.isKeyword(segment, "media")) {
                    return true;
                }
                if (this.isKeyword(segment, "method")) {
                    return true;
                }
                return this.isKeyword(segment, "multiple");
            }
            case 'n': {
                if (this.isKeyword(segment, "nextid")) {
                    return true;
                }
                if (this.isKeyword(segment, "nobr")) {
                    return true;
                }
                if (this.isKeyword(segment, "noframes")) {
                    return true;
                }
                if (this.isKeyword(segment, "nolayer")) {
                    return true;
                }
                if (this.isKeyword(segment, "note")) {
                    return true;
                }
                if (this.isKeyword(segment, "noscript")) {
                    return true;
                }
                if (this.isKeyword(segment, "name")) {
                    return true;
                }
                if (this.isKeyword(segment, "nohref")) {
                    return true;
                }
                if (this.isKeyword(segment, "noresize")) {
                    return true;
                }
                return this.isKeyword(segment, "noshade");
            }
            case 'o': {
                if (this.isKeyword(segment, "object")) {
                    return true;
                }
                if (this.isKeyword(segment, "ol")) {
                    return true;
                }
                if (this.isKeyword(segment, "option")) {
                    return true;
                }
                if (this.isKeyword(segment, "optgroup")) {
                    return true;
                }
                if (this.isKeyword(segment, "object")) {
                    return true;
                }
                if (this.isKeyword(segment, "onblur")) {
                    return true;
                }
                if (this.isKeyword(segment, "onchange")) {
                    return true;
                }
                if (this.isKeyword(segment, "onfocus")) {
                    return true;
                }
                if (this.isKeyword(segment, "onkeydown")) {
                    return true;
                }
                if (this.isKeyword(segment, "onkeypress")) {
                    return true;
                }
                if (this.isKeyword(segment, "onkeyup")) {
                    return true;
                }
                if (this.isKeyword(segment, "onload")) {
                    return true;
                }
                if (this.isKeyword(segment, "onreset")) {
                    return true;
                }
                if (this.isKeyword(segment, "onselect")) {
                    return true;
                }
                if (this.isKeyword(segment, "onsubmit")) {
                    return true;
                }
                if (this.isKeyword(segment, "onunload")) {
                    return true;
                }
                if (this.isKeyword(segment, "onclick")) {
                    return true;
                }
                if (this.isKeyword(segment, "ondblclick")) {
                    return true;
                }
                if (this.isKeyword(segment, "onmousedown")) {
                    return true;
                }
                if (this.isKeyword(segment, "onmousemove")) {
                    return true;
                }
                if (this.isKeyword(segment, "onmouseout")) {
                    return true;
                }
                if (this.isKeyword(segment, "onmouseover")) {
                    return true;
                }
                return this.isKeyword(segment, "onmouseup");
            }
            case 'p': {
                if (this.isKeyword(segment, "p")) {
                    return true;
                }
                if (this.isKeyword(segment, "param")) {
                    return true;
                }
                if (this.isKeyword(segment, "pre")) {
                    return true;
                }
                if (this.isKeyword(segment, "profile")) {
                    return true;
                }
                return this.isKeyword(segment, "prompt");
            }
            case 'q': {
                if (this.isKeyword(segment, "q")) {
                    return true;
                }
                return this.isKeyword(segment, "quote");
            }
            case 'r': {
                if (this.isKeyword(segment, "range")) {
                    return true;
                }
                if (this.isKeyword(segment, "root")) {
                    return true;
                }
                if (this.isKeyword(segment, "readonly")) {
                    return true;
                }
                if (this.isKeyword(segment, "rel")) {
                    return true;
                }
                if (this.isKeyword(segment, "rev")) {
                    return true;
                }
                if (this.isKeyword(segment, "rows")) {
                    return true;
                }
                if (this.isKeyword(segment, "rowspan")) {
                    return true;
                }
                return this.isKeyword(segment, "rules");
            }
            case 's': {
                if (this.isKeyword(segment, "s")) {
                    return true;
                }
                if (this.isKeyword(segment, "samp")) {
                    return true;
                }
                if (this.isKeyword(segment, "script")) {
                    return true;
                }
                if (this.isKeyword(segment, "select")) {
                    return true;
                }
                if (this.isKeyword(segment, "small")) {
                    return true;
                }
                if (this.isKeyword(segment, "sound")) {
                    return true;
                }
                if (this.isKeyword(segment, "spacer")) {
                    return true;
                }
                if (this.isKeyword(segment, "span")) {
                    return true;
                }
                if (this.isKeyword(segment, "sqrt")) {
                    return true;
                }
                if (this.isKeyword(segment, "strike")) {
                    return true;
                }
                if (this.isKeyword(segment, "strong")) {
                    return true;
                }
                if (this.isKeyword(segment, "style")) {
                    return true;
                }
                if (this.isKeyword(segment, "sub")) {
                    return true;
                }
                if (this.isKeyword(segment, "sup")) {
                    return true;
                }
                if (this.isKeyword(segment, "scheme")) {
                    return true;
                }
                if (this.isKeyword(segment, "scope")) {
                    return true;
                }
                if (this.isKeyword(segment, "scrolling")) {
                    return true;
                }
                if (this.isKeyword(segment, "selected")) {
                    return true;
                }
                if (this.isKeyword(segment, "shape")) {
                    return true;
                }
                if (this.isKeyword(segment, "size")) {
                    return true;
                }
                if (this.isKeyword(segment, "span")) {
                    return true;
                }
                if (this.isKeyword(segment, "src")) {
                    return true;
                }
                if (this.isKeyword(segment, "standby")) {
                    return true;
                }
                if (this.isKeyword(segment, "start")) {
                    return true;
                }
                return this.isKeyword(segment, "summary");
            }
            case 't': {
                if (this.isKeyword(segment, "table")) {
                    return true;
                }
                if (this.isKeyword(segment, "tbody")) {
                    return true;
                }
                if (this.isKeyword(segment, "td")) {
                    return true;
                }
                if (this.isKeyword(segment, "text")) {
                    return true;
                }
                if (this.isKeyword(segment, "textarea")) {
                    return true;
                }
                if (this.isKeyword(segment, "tfoot")) {
                    return true;
                }
                if (this.isKeyword(segment, "th")) {
                    return true;
                }
                if (this.isKeyword(segment, "thead")) {
                    return true;
                }
                if (this.isKeyword(segment, "title")) {
                    return true;
                }
                if (this.isKeyword(segment, "tr")) {
                    return true;
                }
                if (this.isKeyword(segment, "tt")) {
                    return true;
                }
                if (this.isKeyword(segment, "tabindex")) {
                    return true;
                }
                if (this.isKeyword(segment, "target")) {
                    return true;
                }
                if (this.isKeyword(segment, "topmargin")) {
                    return true;
                }
                return this.isKeyword(segment, "type");
            }
            case 'u': {
                if (this.isKeyword(segment, "u")) {
                    return true;
                }
                if (this.isKeyword(segment, "ul")) {
                    return true;
                }
                if (this.isKeyword(segment, "url")) {
                    return true;
                }
                return this.isKeyword(segment, "usemap");
            }
            case 'v': {
                if (this.isKeyword(segment, "var")) {
                    return true;
                }
                if (this.isKeyword(segment, "valign")) {
                    return true;
                }
                if (this.isKeyword(segment, "value")) {
                    return true;
                }
                if (this.isKeyword(segment, "valuetype")) {
                    return true;
                }
                if (this.isKeyword(segment, "version")) {
                    return true;
                }
                if (this.isKeyword(segment, "vlink")) {
                    return true;
                }
                return this.isKeyword(segment, "vspace");
            }
            case 'w': {
                if (this.isKeyword(segment, "wbr")) {
                    return true;
                }
                return this.isKeyword(segment, "width");
            }
            case 'x': {
                return this.isKeyword(segment, "xmp");
            }
        }
        return false;
    }

    private final boolean isKeyword(Segment segment, String string) {
        int n = segment.length;
        if (n != string.length()) {
            return false;
        }
        char[] cArray = this.buffer;
        int n2 = this.segmentStart;
        int n3 = 1;
        while (n3 < n) {
            if (string.charAt(n3) != cArray[n2 + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final Segment parseNumberLiteral() {
        int n;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (n = this.current) && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70 || n == 108 || n == 76 || n == 46 || n == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private final boolean isSymbol(int n) {
        switch (n) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

