/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class CppParser
extends TextParser {
    protected Segment nextSegment() {
        Segment segment = this.parseWhitespace();
        if (segment != null) {
            return segment;
        }
        int n = this.current;
        if (n == 123 || n == 125 || n == 40 || n == 41 || n == 91 || n == 93) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)n)) {
            Segment segment2 = this.parseIdentifier();
            if (this.isKeyword(segment2)) {
                return new Segment(6, 8, segment2.offset, segment2.length);
            }
            return segment2;
        }
        if (n == 35) {
            this.advance();
            if (!Character.isJavaIdentifierStart((char)this.current)) {
                return this.newSegment(0);
            }
            Segment segment3 = this.parseIdentifier();
            if (this.isPreprocessor(segment3)) {
                return new Segment(7, 8, segment3.offset, segment3.length);
            }
            return segment3;
        }
        if (n == 47 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(10);
        }
        if (n == 47 && this.next == 42) {
            this.advance();
            this.advance();
            int n2 = 16;
            if (this.current == 42) {
                this.advance();
                n2 = 0;
            }
            return this.newSegment(11, 0);
        }
        if (n == 42 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(12);
        }
        if (!(n != 34 && n != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= n && n <= 57 || n == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current)) {
            if (!this.advance()) break;
        }
        return this.newSegment(0);
    }

    private final Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private final boolean isPreprocessor(Segment segment) {
        if (this.isKeyword(segment, "#if")) {
            return true;
        }
        if (this.isKeyword(segment, "#ifdef")) {
            return true;
        }
        if (this.isKeyword(segment, "#ifndef")) {
            return true;
        }
        if (this.isKeyword(segment, "#else")) {
            return true;
        }
        if (this.isKeyword(segment, "#elif")) {
            return true;
        }
        if (this.isKeyword(segment, "#endif")) {
            return true;
        }
        if (this.isKeyword(segment, "#include")) {
            return true;
        }
        if (this.isKeyword(segment, "#define")) {
            return true;
        }
        if (this.isKeyword(segment, "#undef")) {
            return true;
        }
        if (this.isKeyword(segment, "#line")) {
            return true;
        }
        if (this.isKeyword(segment, "#error")) {
            return true;
        }
        return this.isKeyword(segment, "#pragma");
    }

    private final boolean isKeyword(Segment segment) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(segment, "asm")) {
                    return true;
                }
                return this.isKeyword(segment, "auto");
            }
            case 'b': {
                if (this.isKeyword(segment, "bool")) {
                    return true;
                }
                return this.isKeyword(segment, "break");
            }
            case 'c': {
                if (this.isKeyword(segment, "case")) {
                    return true;
                }
                if (this.isKeyword(segment, "catch")) {
                    return true;
                }
                if (this.isKeyword(segment, "char")) {
                    return true;
                }
                if (this.isKeyword(segment, "class")) {
                    return true;
                }
                if (this.isKeyword(segment, "const")) {
                    return true;
                }
                if (this.isKeyword(segment, "const_cast")) {
                    return true;
                }
                return this.isKeyword(segment, "continue");
            }
            case 'd': {
                if (this.isKeyword(segment, "default")) {
                    return true;
                }
                if (this.isKeyword(segment, "delete")) {
                    return true;
                }
                if (this.isKeyword(segment, "do")) {
                    return true;
                }
                if (this.isKeyword(segment, "double")) {
                    return true;
                }
                return this.isKeyword(segment, "dynamic_cast");
            }
            case 'e': {
                if (this.isKeyword(segment, "else")) {
                    return true;
                }
                if (this.isKeyword(segment, "enum")) {
                    return true;
                }
                if (this.isKeyword(segment, "explicit")) {
                    return true;
                }
                return this.isKeyword(segment, "extern");
            }
            case 'f': {
                if (this.isKeyword(segment, "false")) {
                    return true;
                }
                if (this.isKeyword(segment, "float")) {
                    return true;
                }
                if (this.isKeyword(segment, "for")) {
                    return true;
                }
                return this.isKeyword(segment, "friend");
            }
            case 'g': {
                return this.isKeyword(segment, "goto");
            }
            case 'i': {
                if (this.isKeyword(segment, "if")) {
                    return true;
                }
                if (this.isKeyword(segment, "inline")) {
                    return true;
                }
                return this.isKeyword(segment, "int");
            }
            case 'l': {
                return this.isKeyword(segment, "long");
            }
            case 'm': {
                return this.isKeyword(segment, "mutable");
            }
            case 'n': {
                if (this.isKeyword(segment, "namespace")) {
                    return true;
                }
                return this.isKeyword(segment, "new");
            }
            case 'o': {
                return this.isKeyword(segment, "operator");
            }
            case 'p': {
                if (this.isKeyword(segment, "private")) {
                    return true;
                }
                if (this.isKeyword(segment, "protected")) {
                    return true;
                }
                return this.isKeyword(segment, "public");
            }
            case 'r': {
                if (this.isKeyword(segment, "register")) {
                    return true;
                }
                if (this.isKeyword(segment, "reinterpret_cast")) {
                    return true;
                }
                return this.isKeyword(segment, "return");
            }
            case 's': {
                if (this.isKeyword(segment, "short")) {
                    return true;
                }
                if (this.isKeyword(segment, "signed")) {
                    return true;
                }
                if (this.isKeyword(segment, "sizeof")) {
                    return true;
                }
                if (this.isKeyword(segment, "static")) {
                    return true;
                }
                if (this.isKeyword(segment, "static_cast")) {
                    return true;
                }
                if (this.isKeyword(segment, "struct")) {
                    return true;
                }
                return this.isKeyword(segment, "switch");
            }
            case 't': {
                if (this.isKeyword(segment, "template")) {
                    return true;
                }
                if (this.isKeyword(segment, "this")) {
                    return true;
                }
                if (this.isKeyword(segment, "throw")) {
                    return true;
                }
                if (this.isKeyword(segment, "true")) {
                    return true;
                }
                if (this.isKeyword(segment, "try")) {
                    return true;
                }
                if (this.isKeyword(segment, "typedef")) {
                    return true;
                }
                if (this.isKeyword(segment, "typeid")) {
                    return true;
                }
                return this.isKeyword(segment, "typename");
            }
            case 'u': {
                if (this.isKeyword(segment, "union")) {
                    return true;
                }
                if (this.isKeyword(segment, "unsigned")) {
                    return true;
                }
                return this.isKeyword(segment, "using");
            }
            case 'v': {
                if (this.isKeyword(segment, "virtual")) {
                    return true;
                }
                if (this.isKeyword(segment, "void")) {
                    return true;
                }
                return this.isKeyword(segment, "volatile");
            }
            case 'w': {
                if (this.isKeyword(segment, "wchar_t")) {
                    return true;
                }
                return this.isKeyword(segment, "while");
            }
        }
        return false;
    }

    private final boolean isKeyword(Segment segment, String string) {
        int n = segment.length;
        if (n != string.length()) {
            return false;
        }
        char[] cArray = this.buffer;
        int n2 = this.segmentStart;
        int n3 = 1;
        while (n3 < n) {
            if (string.charAt(n3) != cArray[n2 + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final Segment parseNumberLiteral() {
        int n;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (n = this.current) && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70 || n == 108 || n == 76 || n == 46 || n == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private final boolean isSymbol(int n) {
        switch (n) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

