/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.commands.EditCommand;

public class WordWrap
extends EditCommand {
    public WordWrap(BTextEditor bTextEditor) {
        super(bTextEditor, BKeyBindings.wordWrap);
    }

    public CommandArtifact doInvoke() {
        String string = this.editor.getModel().getSelectedText();
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = WordWrap.wrap(string.toCharArray(), 79);
        return this.insert(cArray);
    }

    public static String wrap(String string, int n) {
        return new String(WordWrap.wrap(string.toCharArray(), n));
    }

    public static char[] wrap(char[] cArray, int n) {
        try {
            String string = WordWrap.stripRNs(cArray);
            String[] stringArray = WordWrap.parse(string);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            int n2 = 0;
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.charAt(0) == '\n') {
                    if (!bl) {
                        charArrayWriter.write(10);
                    }
                    charArrayWriter.write(string2);
                    bl = true;
                    continue;
                }
                if (bl) {
                    charArrayWriter.write(string2);
                    n2 = string2.length();
                } else if (n2 + 1 + string2.length() > n) {
                    charArrayWriter.write(10);
                    charArrayWriter.write(string2);
                    n2 = string2.length();
                } else {
                    charArrayWriter.write(32);
                    charArrayWriter.write(string2);
                    n2 += 1 + string2.length();
                }
                bl = false;
            }
            return charArrayWriter.toCharArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
    }

    static String stripRNs(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = cArray[i];
            char c3 = c = i + 1 < n ? cArray[i + 1] : (char)'\u0000';
            if (c2 == '\r' && c == '\n') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String[] parse(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(new String(string), " \n", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            if (c != ' ' && (c != '\n' || bl)) {
                arrayList.add(string2);
            }
            bl = string2.charAt(0) == '\n';
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

