/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;

public class ToggleSlashSlash
extends TextEditorCommand {
    public ToggleSlashSlash(BTextEditor bTextEditor) {
        super(bTextEditor, BKeyBindings.toggleSlashSlash);
    }

    public CommandArtifact doInvoke() {
        if (this.editor.getSelection().isEmpty()) {
            return null;
        }
        Artifact artifact = new Artifact(this.editor);
        return artifact.invoke();
    }

    static class Artifact
    implements CommandArtifact {
        BTextEditor editor;
        int line0;
        int line1;

        Artifact(BTextEditor bTextEditor) {
            Position position = bTextEditor.getSelection().getStart();
            Position position2 = bTextEditor.getSelection().getEnd();
            this.editor = bTextEditor;
            this.line0 = position.line;
            this.line1 = position2.column > 0 ? position2.line : position2.line - 1;
        }

        Artifact invoke() {
            String string = this.toggle(this.getLines());
            Position position = new Position(this.line0, 0);
            Position position2 = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
            this.editor.getModel().remove(position, position2);
            this.editor.getModel().insert(position, string);
            return this;
        }

        private String toggle(String[] stringArray) {
            boolean bl = !stringArray[0].startsWith("//");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = 0;
                if (bl) {
                    if (!string.startsWith("//")) {
                        stringBuffer.append('/').append('/');
                    }
                } else if (string.startsWith("//")) {
                    n = 2;
                }
                while (n < string.length()) {
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
            }
            return stringBuffer.toString();
        }

        private String[] getLines() {
            String[] stringArray = new String[this.line1 - this.line0 + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(this.editor.getModel().getLine((int)(i + this.line0)).buffer);
            }
            return stringArray;
        }

        public void undo() {
            this.invoke();
        }

        public void redo() {
            this.invoke();
        }
    }
}

