/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.sys.Property;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;

public abstract class MoveCommand
extends TextEditorCommand {
    private boolean shiftDown;

    MoveCommand(BTextEditor bTextEditor, Property property) {
        super(bTextEditor, property);
    }

    MoveCommand(BTextEditor bTextEditor, String string) {
        super(bTextEditor, string);
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public void setShiftDown(boolean bl) {
        this.shiftDown = bl;
    }

    public CommandArtifact move(Position position, Position position2) {
        if (position.equals(position2 = this.clip(position2))) {
            return null;
        }
        MoveCaretArtifact moveCaretArtifact = new MoveCaretArtifact(this.editor, position, position2);
        moveCaretArtifact.redo();
        if (this.shiftDown) {
            Position position3 = this.editor.getSelection().getAnchor();
            if (position3 == null) {
                position3 = position;
            }
            this.editor.getSelection().select(position3, position2);
        } else {
            this.editor.getSelection().deselect();
        }
        if (this.editor.getOptions().getUndoNavigation()) {
            return moveCaretArtifact;
        }
        return null;
    }

    Position clip(Position position) {
        int n;
        int n2 = this.editor.getModel().getLineCount();
        int n3 = position.line;
        int n4 = position.column;
        if (n3 > n2 - 1) {
            n3 = n2 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 == n2 - 1 && n4 > (n = this.editor.getModel().getLine(n3).getColumnCount())) {
            n4 = n;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Position(n3, n4);
    }

    static class MoveCaretArtifact
    implements CommandArtifact {
        private BTextEditor editor;
        private Position oldPos;
        private Position newPos;

        MoveCaretArtifact(BTextEditor bTextEditor, Position position, Position position2) {
            this.editor = bTextEditor;
            this.oldPos = position;
            this.newPos = position2;
        }

        public void redo() {
            this.editor.moveCaretPosition(this.newPos);
        }

        public void undo() {
            this.editor.moveCaretPosition(this.oldPos);
        }
    }
}

