/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;

class LineShiftArtifact
implements CommandArtifact {
    BTextEditor editor;
    boolean right;
    int line0;
    int line1;

    LineShiftArtifact(BTextEditor bTextEditor, boolean bl) {
        this.editor = bTextEditor;
        this.right = bl;
        Position position = bTextEditor.getSelection().getStart();
        Position position2 = bTextEditor.getSelection().getEnd();
        this.line0 = position.line;
        this.line1 = position2.column > 0 ? position2.line : position2.line - 1;
    }

    private void shiftLeft() {
        String[] stringArray = this.getLines();
        String string = this.shiftLeft(stringArray);
        Position position = new Position(this.line0, 0);
        Position position2 = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
        this.editor.getModel().remove(position, position2);
        this.editor.getModel().insert(position, string);
    }

    private String shiftLeft(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.editor.getOptions().getTabToSpaceConversion();
        for (int i = 0; i < stringArray.length; ++i) {
            char c;
            int n2;
            String string = stringArray[i];
            for (n2 = 0; n2 < n && (n2 >= string.length() || (c = string.charAt(n2)) == ' '); ++n2) {
            }
            while (n2 < string.length()) {
                stringBuffer.append(string.charAt(n2));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private void shiftRight() {
        String[] stringArray = this.getLines();
        String string = this.shiftRight(stringArray);
        Position position = new Position(this.line0, 0);
        Position position2 = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
        this.editor.getModel().remove(position, position2);
        this.editor.getModel().insert(position, string);
    }

    private String shiftRight(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.editor.getOptions().getTabToSpaceConversion();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] getLines() {
        String[] stringArray = new String[this.line1 - this.line0 + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String(this.editor.getModel().getLine((int)(i + this.line0)).buffer);
        }
        return stringArray;
    }

    public void undo() {
        if (this.right) {
            this.shiftLeft();
        } else {
            this.shiftRight();
        }
    }

    public void redo() {
        if (this.right) {
            this.shiftRight();
        } else {
            this.shiftLeft();
        }
    }
}

